/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustedSigners {
    private Boolean enabled;
    private Integer quantity;
    private List<String> items;

    public TrustedSigners() {
    }

    public TrustedSigners(List<String> items) {
        this.items = items;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public TrustedSigners withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public TrustedSigners withQuantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public List<String> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<String>();
        }
        return this.items;
    }

    public void setItems(Collection<String> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        ArrayList<String> itemsCopy = new ArrayList<String>(items.size());
        itemsCopy.addAll(items);
        this.items = itemsCopy;
    }

    public TrustedSigners withItems(String ... items) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<String>(items.length));
        }
        for (String value : items) {
            this.getItems().add(value);
        }
        return this;
    }

    public TrustedSigners withItems(Collection<String> items) {
        if (items == null) {
            this.items = null;
        } else {
            ArrayList<String> itemsCopy = new ArrayList<String>(items.size());
            itemsCopy.addAll(items);
            this.items = itemsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled != null) {
            sb.append("Enabled: " + this.enabled + ", ");
        }
        if (this.quantity != null) {
            sb.append("Quantity: " + this.quantity + ", ");
        }
        if (this.items != null) {
            sb.append("Items: " + this.items + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isEnabled() == null ? 0 : this.isEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getQuantity() == null ? 0 : this.getQuantity().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : ((Object)this.getItems()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedSigners)) {
            return false;
        }
        TrustedSigners other = (TrustedSigners)obj;
        if (other.isEnabled() == null ^ this.isEnabled() == null) {
            return false;
        }
        if (other.isEnabled() != null && !other.isEnabled().equals(this.isEnabled())) {
            return false;
        }
        if (other.getQuantity() == null ^ this.getQuantity() == null) {
            return false;
        }
        if (other.getQuantity() != null && !other.getQuantity().equals(this.getQuantity())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return other.getItems() == null || ((Object)other.getItems()).equals(this.getItems());
    }
}

