/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.repository;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.util.MapUtils;
import java.time.Duration;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class VcsChangeDetection
extends EntityPropertiesBuilder<VcsChangeDetectionProperties> {
    private boolean quietPeriodEnabled = false;
    private Duration quietPeriod = Duration.ofSeconds(10L);
    private int maxRetries = 5;
    private boolean commitIsolationEnabled = false;
    private Map<String, Object> configuration;
    private String changesetFilterPatternRegex;
    private FileFilteringOption filterFilePatternOption = FileFilteringOption.NONE;
    private String filterFilePatternRegex;

    public VcsChangeDetection quietPeriodEnabled(boolean quietPeriodEnabled) {
        this.quietPeriodEnabled = quietPeriodEnabled;
        return this;
    }

    public VcsChangeDetection quietPeriod(Duration quietPeriod) {
        this.quietPeriod = quietPeriod;
        return this;
    }

    public VcsChangeDetection quietPeriodInSeconds(int quietPeriodInSeconds) {
        return this.quietPeriod(Duration.ofSeconds(quietPeriodInSeconds));
    }

    public VcsChangeDetection quietPeriodMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public VcsChangeDetection commitIsolationEnabled(boolean commitIsolationEnabled) {
        this.commitIsolationEnabled = commitIsolationEnabled;
        return this;
    }

    public VcsChangeDetection configuration(@Nullable Map<String, Object> configuration) {
        this.configuration = MapUtils.copyOf(configuration);
        return this;
    }

    public VcsChangeDetection changesetFilterPatternRegex(@Nullable String changesetFilterPatternRegex) throws PropertiesValidationException {
        this.changesetFilterPatternRegex = changesetFilterPatternRegex;
        return this;
    }

    public VcsChangeDetection filterFilePatternOption(@Nullable FileFilteringOption filterFilePatternOption) throws PropertiesValidationException {
        this.filterFilePatternOption = filterFilePatternOption;
        return this;
    }

    public VcsChangeDetection filterFilePatternRegex(@Nullable String filterFilePatternRegex) throws PropertiesValidationException {
        this.filterFilePatternRegex = filterFilePatternRegex;
        return this;
    }

    @Override
    protected VcsChangeDetectionProperties build() throws PropertiesValidationException {
        return new VcsChangeDetectionProperties(this.quietPeriodEnabled, this.quietPeriod, this.maxRetries, this.commitIsolationEnabled, this.configuration, this.changesetFilterPatternRegex, this.filterFilePatternOption, this.filterFilePatternRegex);
    }

    public static enum FileFilteringOption {
        NONE,
        INCLUDE_ONLY,
        EXCLUDE_ALL;

    }
}

