/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators.plan.branch;

import com.atlassian.bamboo.specs.api.model.plan.branches.BranchCleanupProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class BranchCleanupValidator {
    private BranchCleanupValidator() {
    }

    @NotNull
    public static List<ValidationProblem> validate(@NotNull BranchCleanupProperties moduleProperties) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        if (moduleProperties.isRemoveDeletedFromRepository() && moduleProperties.getRemoveDeletedFromRepositoryPeriod().isNegative()) {
            errors.add(new ValidationProblem("Branch cleanup period for removed repository branches must be non-negative"));
        }
        if (moduleProperties.isRemoveInactiveInRepository() && moduleProperties.getRemoveInactiveInRepositoryPeriod().getSeconds() <= 0L) {
            errors.add(new ValidationProblem("Branch cleanup period for inactive repository branches must be more than 0"));
        }
        return errors;
    }
}

