/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference;

import com.azure.ai.inference.ImageEmbeddingsClientBuilder;
import com.azure.ai.inference.implementation.ImageEmbeddingsClientImpl;
import com.azure.ai.inference.implementation.models.ImageEmbedRequest;
import com.azure.ai.inference.models.EmbeddingsResult;
import com.azure.ai.inference.models.ExtraParameters;
import com.azure.ai.inference.models.ImageEmbeddingInput;
import com.azure.ai.inference.models.ModelInfo;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import java.util.List;

@ServiceClient(builder=ImageEmbeddingsClientBuilder.class)
public final class ImageEmbeddingsClient {
    private final ImageEmbeddingsClientImpl serviceClient;

    ImageEmbeddingsClient(ImageEmbeddingsClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> embedWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.embedWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EmbeddingsResult embed(List<ImageEmbeddingInput> inputs) {
        RequestOptions requestOptions = new RequestOptions();
        ImageEmbedRequest embedRequestObj = new ImageEmbedRequest(inputs);
        BinaryData embedRequest = BinaryData.fromObject((Object)embedRequestObj);
        return (EmbeddingsResult)((BinaryData)this.embedWithResponse(embedRequest, requestOptions).getValue()).toObject(EmbeddingsResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> getModelInfoWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getModelInfoWithResponse(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    ModelInfo getModelInfo() {
        RequestOptions requestOptions = new RequestOptions();
        return (ModelInfo)((BinaryData)this.getModelInfoWithResponse(requestOptions).getValue()).toObject(ModelInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    EmbeddingsResult embed(ImageEmbedRequest body, ExtraParameters extraParams) {
        RequestOptions requestOptions = new RequestOptions();
        if (extraParams != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"extra-parameters"), extraParams.toString());
        }
        return (EmbeddingsResult)((BinaryData)this.embedWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(EmbeddingsResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    EmbeddingsResult embed(ImageEmbedRequest body) {
        RequestOptions requestOptions = new RequestOptions();
        return (EmbeddingsResult)((BinaryData)this.embedWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(EmbeddingsResult.class);
    }
}

