/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;

public final class ImageEmbeddingInput
implements JsonSerializable<ImageEmbeddingInput> {
    private final String image;
    private String text;

    public ImageEmbeddingInput(Path filePath, String imageFormatType) {
        try {
            byte[] bytes = Files.readAllBytes(filePath);
            String encodedFile = new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
            String urlTemplate = "data:image/%s;base64,%s";
            this.image = String.format(urlTemplate, imageFormatType, encodedFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Local file not found.", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImageEmbeddingInput(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public String getText() {
        return this.text;
    }

    public ImageEmbeddingInput setText(String text) {
        this.text = text;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("image", this.image);
        jsonWriter.writeStringField("text", this.text);
        return jsonWriter.writeEndObject();
    }

    public static ImageEmbeddingInput fromJson(JsonReader jsonReader) throws IOException {
        return (ImageEmbeddingInput)jsonReader.readObject(reader -> {
            String image = null;
            String text = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image".equals(fieldName)) {
                    image = reader.getString();
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ImageEmbeddingInput deserializedImageEmbeddingInput = new ImageEmbeddingInput(image);
            deserializedImageEmbeddingInput.text = text;
            return deserializedImageEmbeddingInput;
        });
    }
}

