/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.inference.models;

import com.azure.ai.inference.models.ModelType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ModelInfo
implements JsonSerializable<ModelInfo> {
    private final String modelName;
    private final ModelType modelType;
    private final String modelProviderName;

    private ModelInfo(String modelName, ModelType modelType, String modelProviderName) {
        this.modelName = modelName;
        this.modelType = modelType;
        this.modelProviderName = modelProviderName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public String getModelProviderName() {
        return this.modelProviderName;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("model_name", this.modelName);
        jsonWriter.writeStringField("model_type", this.modelType == null ? null : this.modelType.toString());
        jsonWriter.writeStringField("model_provider_name", this.modelProviderName);
        return jsonWriter.writeEndObject();
    }

    public static ModelInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ModelInfo)jsonReader.readObject(reader -> {
            String modelName = null;
            ModelType modelType = null;
            String modelProviderName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("model_name".equals(fieldName)) {
                    modelName = reader.getString();
                    continue;
                }
                if ("model_type".equals(fieldName)) {
                    modelType = ModelType.fromString(reader.getString());
                    continue;
                }
                if ("model_provider_name".equals(fieldName)) {
                    modelProviderName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new ModelInfo(modelName, modelType, modelProviderName);
        });
    }
}

