/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.ExponentialBackoff;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.core.implementation.util.ImplUtils;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class RetryPolicy
implements HttpPipelinePolicy {
    private static final String RETRY_AFTER_MS_HEADER = "retry-after-ms";
    private final ClientLogger logger = new ClientLogger(RetryPolicy.class);
    private final RetryStrategy retryStrategy;

    public RetryPolicy() {
        this(new ExponentialBackoff());
    }

    public RetryPolicy(RetryStrategy retryStrategy) {
        this.retryStrategy = Objects.requireNonNull(retryStrategy, "'retryStrategy' cannot be null");
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return this.attemptAsync(context, next, context.getHttpRequest(), 0);
    }

    private Mono<HttpResponse> attemptAsync(HttpPipelineCallContext context, HttpPipelineNextPolicy next, HttpRequest originalHttpRequest, int tryCount) {
        context.setHttpRequest(originalHttpRequest.copy());
        return next.clone().process().flatMap(httpResponse -> {
            if (this.shouldRetry((HttpResponse)httpResponse, tryCount)) {
                Duration delayDuration = this.determineDelayDuration((HttpResponse)httpResponse, tryCount);
                this.logger.verbose("[Retrying] Try count: {}, Delay duration in seconds: {}", tryCount, delayDuration.getSeconds());
                return this.attemptAsync(context, next, originalHttpRequest, tryCount + 1).delaySubscription(delayDuration);
            }
            return Mono.just((Object)httpResponse);
        }).onErrorResume(err -> {
            int maxRetries = this.retryStrategy.getMaxRetries();
            if (tryCount < maxRetries) {
                this.logger.verbose("[Error Resume] Try count: {}, Error: {}", tryCount, err);
                return this.attemptAsync(context, next, originalHttpRequest, tryCount + 1).delaySubscription(this.retryStrategy.calculateRetryDelay(tryCount));
            }
            return Mono.error((Throwable)new RuntimeException(String.format("Max retries %d times exceeded. Error Details: %s", maxRetries, err.getMessage()), (Throwable)err));
        });
    }

    private boolean shouldRetry(HttpResponse response, int tryCount) {
        return tryCount < this.retryStrategy.getMaxRetries() && this.retryStrategy.shouldRetry(response);
    }

    private Duration determineDelayDuration(HttpResponse response, int tryCount) {
        int code = response.getStatusCode();
        if (code != 429 && code != 503) {
            return this.retryStrategy.calculateRetryDelay(tryCount);
        }
        String retryHeader = response.getHeaderValue(RETRY_AFTER_MS_HEADER);
        if (ImplUtils.isNullOrEmpty(retryHeader)) {
            return this.retryStrategy.calculateRetryDelay(tryCount);
        }
        return Duration.ofMillis(Integer.parseInt(retryHeader));
    }
}

