/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.rest.PagedFluxBase;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.implementation.http.PagedResponseBase;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class PagedFlux<T>
extends PagedFluxBase<T, PagedResponse<T>> {
    public PagedFlux(Supplier<Mono<PagedResponse<T>>> firstPageRetriever) {
        super(firstPageRetriever);
    }

    public PagedFlux(Supplier<Mono<PagedResponse<T>>> firstPageRetriever, Function<String, Mono<PagedResponse<T>>> nextPageRetriever) {
        super(firstPageRetriever, nextPageRetriever);
    }

    public <S> PagedFlux<S> mapPage(Function<T, S> mapper) {
        return new PagedFlux<T>(() -> this.getFirstPageRetriever().get().map(this.mapPagedResponse(mapper)), continuationToken -> this.getNextPageRetriever().apply((String)continuationToken).map(this.mapPagedResponse(mapper)));
    }

    private <S> Function<PagedResponse<T>, PagedResponse<S>> mapPagedResponse(Function<T, S> mapper) {
        return pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(mapper).collect(Collectors.toList()), pagedResponse.getContinuationToken(), null);
    }
}

