/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ServiceBusErrorContext;
import com.azure.messaging.servicebus.ServiceBusErrorSource;
import com.azure.messaging.servicebus.ServiceBusException;

final class MessagePumpTerminatedException
extends RuntimeException {
    private final long pumpId;
    private final String fullyQualifiedNamespace;
    private final String entityPath;

    MessagePumpTerminatedException(long pumpId, String fullyQualifiedNamespace, String entityPath, String detectedAt) {
        super(detectedAt);
        this.pumpId = pumpId;
        this.fullyQualifiedNamespace = fullyQualifiedNamespace;
        this.entityPath = entityPath;
    }

    MessagePumpTerminatedException(long pumpId, String fullyQualifiedNamespace, String entityPath, String detectedAt, Throwable terminationCause) {
        super(detectedAt, terminationCause);
        this.pumpId = pumpId;
        this.fullyQualifiedNamespace = fullyQualifiedNamespace;
        this.entityPath = entityPath;
    }

    static MessagePumpTerminatedException forCompletion(long pumpId, String fullyQualifiedNamespace, String entityPath) {
        return new MessagePumpTerminatedException(pumpId, fullyQualifiedNamespace, entityPath, "pumping#reached-completion");
    }

    ServiceBusErrorContext getErrorContext() {
        Throwable cause = super.getCause();
        if (cause == null) {
            return null;
        }
        if (cause instanceof ServiceBusException) {
            return new ServiceBusErrorContext(cause, this.fullyQualifiedNamespace, this.entityPath);
        }
        return new ServiceBusErrorContext((Throwable)((Object)new ServiceBusException(cause, ServiceBusErrorSource.RECEIVE)), this.fullyQualifiedNamespace, this.entityPath);
    }

    void log(ClientLogger logger, String message, boolean logError) {
        if (logError) {
            MessagePumpTerminatedException error = this;
            logger.atInfo().addKeyValue("pumpId", this.pumpId).addKeyValue("namespace", this.fullyQualifiedNamespace).addKeyValue("entityPath", this.entityPath).log(message, new Object[]{error});
        } else {
            logger.atInfo().addKeyValue("pumpId", this.pumpId).addKeyValue("namespace", this.fullyQualifiedNamespace).addKeyValue("entityPath", this.entityPath).log(message);
        }
    }
}

