/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusReceiverClient;
import com.azure.messaging.servicebus.ServiceBusSessionReceiverAsyncClient;
import java.time.Duration;
import java.util.Objects;

@ServiceClient(builder=ServiceBusClientBuilder.class)
public final class ServiceBusSessionReceiverClient
implements AutoCloseable {
    private final ServiceBusSessionReceiverAsyncClient sessionAsyncClient;
    private final boolean isPrefetchDisabled;
    private final Duration operationTimeout;

    ServiceBusSessionReceiverClient(ServiceBusSessionReceiverAsyncClient asyncClient, boolean isPrefetchDisabled, Duration operationTimeout) {
        this.sessionAsyncClient = Objects.requireNonNull(asyncClient, "'asyncClient' cannot be null.");
        this.operationTimeout = operationTimeout;
        this.isPrefetchDisabled = isPrefetchDisabled;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServiceBusReceiverClient acceptNextSession() {
        return (ServiceBusReceiverClient)this.sessionAsyncClient.acceptNextSession().map(asyncClient -> new ServiceBusReceiverClient((ServiceBusReceiverAsyncClient)asyncClient, this.isPrefetchDisabled, this.operationTimeout)).block(this.operationTimeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServiceBusReceiverClient acceptSession(String sessionId) {
        return (ServiceBusReceiverClient)this.sessionAsyncClient.acceptSession(sessionId).map(asyncClient -> new ServiceBusReceiverClient((ServiceBusReceiverAsyncClient)asyncClient, this.isPrefetchDisabled, this.operationTimeout)).block(this.operationTimeout);
    }

    @Override
    public void close() {
        this.sessionAsyncClient.close();
    }
}

