/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.FalseFilterImpl;
import com.azure.messaging.servicebus.administration.implementation.models.KeyValueImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleFilterImpl;
import com.azure.messaging.servicebus.administration.implementation.models.TrueFilterImpl;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class SqlFilterImpl
extends RuleFilterImpl {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private String sqlExpression;
    private String compatibilityLevel;
    private List<KeyValueImpl> parameters;
    private Boolean requiresPreprocessing;

    public String getSqlExpression() {
        return this.sqlExpression;
    }

    public SqlFilterImpl setSqlExpression(String sqlExpression) {
        this.sqlExpression = sqlExpression;
        return this;
    }

    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    public SqlFilterImpl setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
        return this;
    }

    public List<KeyValueImpl> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<KeyValueImpl>();
        }
        return this.parameters;
    }

    public SqlFilterImpl setParameters(List<KeyValueImpl> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Boolean isRequiresPreprocessing() {
        return this.requiresPreprocessing;
    }

    public SqlFilterImpl setRequiresPreprocessing(Boolean requiresPreprocessing) {
        this.requiresPreprocessing = requiresPreprocessing;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Filter" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeNamespace("xsi", WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE);
        xmlWriter.writeStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type", "SqlFilter");
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SqlExpression", this.sqlExpression);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CompatibilityLevel", this.compatibilityLevel);
        if (this.parameters != null) {
            xmlWriter.writeStartElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Parameters");
            for (KeyValueImpl element : this.parameters) {
                xmlWriter.writeXml((XmlSerializable)element, "KeyValueOfstringanyType");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresPreprocessing", this.requiresPreprocessing);
        return xmlWriter.writeEndElement();
    }

    public static SqlFilterImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return SqlFilterImpl.fromXml(xmlReader, null);
    }

    public static SqlFilterImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Filter" : rootElementName;
        return (SqlFilterImpl)xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            String discriminatorValue = reader.getStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type");
            if (discriminatorValue == null || "SqlFilter".equals(discriminatorValue)) {
                return SqlFilterImpl.fromXmlKnownDiscriminator(reader, finalRootElementName);
            }
            if ("TrueFilter".equals(discriminatorValue)) {
                return TrueFilterImpl.fromXml(reader, finalRootElementName);
            }
            if ("FalseFilter".equals(discriminatorValue)) {
                return FalseFilterImpl.fromXml(reader, finalRootElementName);
            }
            throw new IllegalStateException("Discriminator field 'type' didn't match one of the expected values 'SqlFilter', 'TrueFilter', or 'FalseFilter'. It was: '" + discriminatorValue + "'.");
        });
    }

    public static SqlFilterImpl fromXmlKnownDiscriminator(XmlReader xmlReader) throws XMLStreamException {
        return SqlFilterImpl.fromXmlKnownDiscriminator(xmlReader, null);
    }

    static SqlFilterImpl fromXmlKnownDiscriminator(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Filter" : rootElementName;
        return (SqlFilterImpl)xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            SqlFilterImpl deserializedSqlFilter = new SqlFilterImpl();
            String discriminatorValue = reader.getStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type");
            if (!"SqlFilter".equals(discriminatorValue)) {
                throw new IllegalStateException("'type' was expected to be non-null and equal to 'SqlFilter'. The found 'type' was '" + discriminatorValue + "'.");
            }
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("SqlExpression".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSqlFilter.sqlExpression = reader.getStringElement();
                    continue;
                }
                if ("CompatibilityLevel".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSqlFilter.compatibilityLevel = reader.getStringElement();
                    continue;
                }
                if ("Parameters".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("KeyValueOfstringanyType".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                            if (deserializedSqlFilter.parameters == null) {
                                deserializedSqlFilter.parameters = new ArrayList<KeyValueImpl>();
                            }
                            deserializedSqlFilter.parameters.add(KeyValueImpl.fromXml(reader, "KeyValueOfstringanyType"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                if ("RequiresPreprocessing".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSqlFilter.requiresPreprocessing = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedSqlFilter;
        });
    }
}

