/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.administration.implementation.models.AuthorizationRuleImpl;
import com.azure.messaging.servicebus.administration.models.AccessRights;
import com.azure.messaging.servicebus.administration.models.AuthorizationRule;
import java.security.SecureRandom;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class SharedAccessAuthorizationRule
implements AuthorizationRule {
    private static final String FIXED_CLAIM_TYPE = "SharedAccessKey";
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final ClientLogger LOGGER = new ClientLogger(SharedAccessAuthorizationRule.class);
    private final List<AccessRights> accessRights;
    private final OffsetDateTime createdAt;
    private final String keyName;
    private final OffsetDateTime modifiedAt;
    private String primaryKey;
    private String secondaryKey;

    public SharedAccessAuthorizationRule(String keyName, List<AccessRights> accessRights) {
        this(keyName, SharedAccessAuthorizationRule.generateRandomKey(), SharedAccessAuthorizationRule.generateRandomKey(), accessRights);
    }

    public SharedAccessAuthorizationRule(String keyName, String primaryKey, List<AccessRights> accessRights) {
        this(keyName, primaryKey, SharedAccessAuthorizationRule.generateRandomKey(), accessRights);
    }

    public SharedAccessAuthorizationRule(String keyName, String primaryKey, String secondaryKey, List<AccessRights> accessRights) {
        this.keyName = Objects.requireNonNull(keyName, "'keyName' cannot be null.");
        this.primaryKey = Objects.requireNonNull(primaryKey, "'primaryKey' cannot be null.");
        this.secondaryKey = Objects.requireNonNull(secondaryKey, "'secondaryKey' cannot be null.");
        this.accessRights = new ArrayList<AccessRights>((Collection)Objects.requireNonNull(accessRights, "'accessRights' cannot be null."));
        this.createdAt = null;
        this.modifiedAt = null;
        if (keyName.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'keyName' cannot be an empty string."));
        }
        if (primaryKey.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'primaryKey' cannot be an empty string."));
        }
        if (secondaryKey.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'secondaryKey' cannot be an empty string."));
        }
    }

    SharedAccessAuthorizationRule(AuthorizationRuleImpl implementation) {
        this.keyName = implementation.getKeyName();
        this.primaryKey = implementation.getPrimaryKey();
        this.secondaryKey = implementation.getSecondaryKey();
        this.accessRights = new ArrayList<AccessRights>(implementation.getRights());
        this.createdAt = implementation.getCreatedTime();
        this.modifiedAt = implementation.getModifiedTime();
    }

    @Override
    public List<AccessRights> getAccessRights() {
        return this.accessRights;
    }

    @Override
    public String getClaimType() {
        return FIXED_CLAIM_TYPE;
    }

    @Override
    public String getClaimValue() {
        return "None";
    }

    @Override
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getKeyName() {
        return this.keyName;
    }

    @Override
    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public SharedAccessAuthorizationRule setPrimaryKey(String primaryKey) {
        if (Objects.isNull(primaryKey)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'primaryKey' cannot be null."));
        }
        if (primaryKey.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'primaryKey' cannot be an empty string."));
        }
        this.primaryKey = primaryKey;
        return this;
    }

    @Override
    public String getSecondaryKey() {
        return this.secondaryKey;
    }

    public SharedAccessAuthorizationRule setSecondaryKey(String secondaryKey) {
        if (Objects.isNull(secondaryKey)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'primaryKey' cannot be null."));
        }
        if (secondaryKey.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'primaryKey' cannot be an empty string."));
        }
        this.secondaryKey = secondaryKey;
        return this;
    }

    private static String generateRandomKey() {
        byte[] key256 = new byte[32];
        SECURE_RANDOM.nextBytes(key256);
        return Base64.getEncoder().encodeToString(key256);
    }
}

