/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.NamespacePropertiesEntryContent;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseAuthor;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseLink;
import com.azure.messaging.servicebus.administration.implementation.models.Title;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class NamespacePropertiesEntry
implements XmlSerializable<NamespacePropertiesEntry> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";
    private String id;
    private Title title;
    private OffsetDateTime updated;
    private ResponseAuthor author;
    private ResponseLink link;
    private NamespacePropertiesEntryContent content;

    public String getId() {
        return this.id;
    }

    public NamespacePropertiesEntry setId(String id) {
        this.id = id;
        return this;
    }

    public Title getTitle() {
        return this.title;
    }

    public NamespacePropertiesEntry setTitle(Title title) {
        this.title = title;
        return this;
    }

    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public NamespacePropertiesEntry setUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    public ResponseAuthor getAuthor() {
        return this.author;
    }

    public NamespacePropertiesEntry setAuthor(ResponseAuthor author) {
        this.author = author;
        return this;
    }

    public ResponseLink getLink() {
        return this.link;
    }

    public NamespacePropertiesEntry setLink(ResponseLink link) {
        this.link = link;
        return this;
    }

    public NamespacePropertiesEntryContent getContent() {
        return this.content;
    }

    public NamespacePropertiesEntry setContent(NamespacePropertiesEntryContent content) {
        this.content = content;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "entry" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "id", this.id);
        xmlWriter.writeXml((XmlSerializable)this.title, "title");
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "updated", this.updated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updated));
        xmlWriter.writeXml((XmlSerializable)this.author, "author");
        xmlWriter.writeXml((XmlSerializable)this.link, "link");
        xmlWriter.writeXml((XmlSerializable)this.content, "content");
        return xmlWriter.writeEndElement();
    }

    public static NamespacePropertiesEntry fromXml(XmlReader xmlReader) throws XMLStreamException {
        return NamespacePropertiesEntry.fromXml(xmlReader, null);
    }

    public static NamespacePropertiesEntry fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "entry" : rootElementName;
        return (NamespacePropertiesEntry)xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            NamespacePropertiesEntry deserializedNamespacePropertiesEntry = new NamespacePropertiesEntry();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("id".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedNamespacePropertiesEntry.id = reader.getStringElement();
                    continue;
                }
                if ("title".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedNamespacePropertiesEntry.title = Title.fromXml(reader, "title");
                    continue;
                }
                if ("updated".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedNamespacePropertiesEntry.updated = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("author".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedNamespacePropertiesEntry.author = ResponseAuthor.fromXml(reader, "author");
                    continue;
                }
                if ("link".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedNamespacePropertiesEntry.link = ResponseLink.fromXml(reader, "link");
                    continue;
                }
                if ("content".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedNamespacePropertiesEntry.content = NamespacePropertiesEntryContent.fromXml(reader, "content");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedNamespacePropertiesEntry;
        });
    }
}

