/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.RuleAction;
import com.azure.messaging.servicebus.administration.implementation.models.RuleFilter;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class RuleDescription
implements XmlSerializable<RuleDescription> {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";
    private RuleFilter filter;
    private RuleAction action;
    private OffsetDateTime createdAt;
    private String name;

    public RuleFilter getFilter() {
        return this.filter;
    }

    public RuleDescription setFilter(RuleFilter filter) {
        this.filter = filter;
        return this;
    }

    public RuleAction getAction() {
        return this.action;
    }

    public RuleDescription setAction(RuleAction action) {
        this.action = action;
        return this;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public RuleDescription setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public RuleDescription setName(String name) {
        this.name = name;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "RuleDescription" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeXml((XmlSerializable)this.filter, "Filter");
        xmlWriter.writeXml((XmlSerializable)this.action, "Action");
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CreatedAt", this.createdAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Name", this.name);
        return xmlWriter.writeEndElement();
    }

    public static RuleDescription fromXml(XmlReader xmlReader) throws XMLStreamException {
        return RuleDescription.fromXml(xmlReader, null);
    }

    public static RuleDescription fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "RuleDescription" : rootElementName;
        return (RuleDescription)xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            RuleDescription deserializedRuleDescription = new RuleDescription();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Filter".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescription.filter = RuleFilter.fromXml(reader, "Filter");
                    continue;
                }
                if ("Action".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescription.action = RuleAction.fromXml(reader, "Action");
                    continue;
                }
                if ("CreatedAt".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescription.createdAt = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("Name".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescription.name = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedRuleDescription;
        });
    }
}

