/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseLink;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionEntryContent;
import com.azure.messaging.servicebus.administration.implementation.models.Title;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class RuleDescriptionEntry
implements XmlSerializable<RuleDescriptionEntry> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";
    private String id;
    private Title title;
    private OffsetDateTime published;
    private OffsetDateTime updated;
    private ResponseLink link;
    private RuleDescriptionEntryContent content;

    public String getId() {
        return this.id;
    }

    public RuleDescriptionEntry setId(String id) {
        this.id = id;
        return this;
    }

    public Title getTitle() {
        return this.title;
    }

    public RuleDescriptionEntry setTitle(Title title) {
        this.title = title;
        return this;
    }

    public OffsetDateTime getPublished() {
        return this.published;
    }

    public RuleDescriptionEntry setPublished(OffsetDateTime published) {
        this.published = published;
        return this;
    }

    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public RuleDescriptionEntry setUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    public ResponseLink getLink() {
        return this.link;
    }

    public RuleDescriptionEntry setLink(ResponseLink link) {
        this.link = link;
        return this;
    }

    public RuleDescriptionEntryContent getContent() {
        return this.content;
    }

    public RuleDescriptionEntry setContent(RuleDescriptionEntryContent content) {
        this.content = content;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "entry" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "id", this.id);
        xmlWriter.writeXml((XmlSerializable)this.title, "title");
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "published", this.published == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.published));
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "updated", this.updated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updated));
        xmlWriter.writeXml((XmlSerializable)this.link, "link");
        xmlWriter.writeXml((XmlSerializable)this.content, "content");
        return xmlWriter.writeEndElement();
    }

    public static RuleDescriptionEntry fromXml(XmlReader xmlReader) throws XMLStreamException {
        return RuleDescriptionEntry.fromXml(xmlReader, null);
    }

    public static RuleDescriptionEntry fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "entry" : rootElementName;
        return (RuleDescriptionEntry)xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            RuleDescriptionEntry deserializedRuleDescriptionEntry = new RuleDescriptionEntry();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("id".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescriptionEntry.id = reader.getStringElement();
                    continue;
                }
                if ("title".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescriptionEntry.title = Title.fromXml(reader, "title");
                    continue;
                }
                if ("published".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescriptionEntry.published = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("updated".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescriptionEntry.updated = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("link".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescriptionEntry.link = ResponseLink.fromXml(reader, "link");
                    continue;
                }
                if ("content".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescriptionEntry.content = RuleDescriptionEntryContent.fromXml(reader, "content");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedRuleDescriptionEntry;
        });
    }
}

