/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.messaging.servicebus.administration.implementation.models.KeyValue;
import com.azure.messaging.servicebus.administration.implementation.models.RuleAction;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class SqlRuleAction
extends RuleAction {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private String type = "SqlRuleAction";
    private String sqlExpression;
    private String compatibilityLevel;
    private List<KeyValue> parameters;
    private Boolean requiresPreprocessing;

    @Override
    public String getType() {
        return this.type;
    }

    public String getSqlExpression() {
        return this.sqlExpression;
    }

    public SqlRuleAction setSqlExpression(String sqlExpression) {
        this.sqlExpression = sqlExpression;
        return this;
    }

    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    public SqlRuleAction setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
        return this;
    }

    public List<KeyValue> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<KeyValue>();
        }
        return this.parameters;
    }

    public SqlRuleAction setParameters(List<KeyValue> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Boolean isRequiresPreprocessing() {
        return this.requiresPreprocessing;
    }

    public SqlRuleAction setRequiresPreprocessing(Boolean requiresPreprocessing) {
        this.requiresPreprocessing = requiresPreprocessing;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "Action" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeNamespace("xsi", WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE);
        xmlWriter.writeStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type", this.type);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SqlExpression", this.sqlExpression);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CompatibilityLevel", this.compatibilityLevel);
        if (this.parameters != null) {
            xmlWriter.writeStartElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Parameters");
            for (KeyValue element : this.parameters) {
                xmlWriter.writeXml((XmlSerializable)element, "KeyValueOfstringanyType");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresPreprocessing", this.requiresPreprocessing);
        return xmlWriter.writeEndElement();
    }

    public static SqlRuleAction fromXml(XmlReader xmlReader) throws XMLStreamException {
        return SqlRuleAction.fromXml(xmlReader, null);
    }

    public static SqlRuleAction fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "Action" : rootElementName;
        return (SqlRuleAction)xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            SqlRuleAction deserializedSqlRuleAction = new SqlRuleAction();
            String discriminatorValue = reader.getStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type");
            if (!"SqlRuleAction".equals(discriminatorValue)) {
                throw new IllegalStateException("'type' was expected to be non-null and equal to 'SqlRuleAction'. The found 'type' was '" + discriminatorValue + "'.");
            }
            deserializedSqlRuleAction.type = discriminatorValue;
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("SqlExpression".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSqlRuleAction.sqlExpression = reader.getStringElement();
                    continue;
                }
                if ("CompatibilityLevel".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSqlRuleAction.compatibilityLevel = reader.getStringElement();
                    continue;
                }
                if ("Parameters".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("KeyValueOfstringanyType".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                            if (deserializedSqlRuleAction.parameters == null) {
                                deserializedSqlRuleAction.parameters = new ArrayList<KeyValue>();
                            }
                            deserializedSqlRuleAction.parameters.add(KeyValue.fromXml(reader, "KeyValueOfstringanyType"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                if ("RequiresPreprocessing".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSqlRuleAction.requiresPreprocessing = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedSqlRuleAction;
        });
    }
}

