/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ClusterResourceProperties;
import com.azure.resourcemanager.appplatform.models.Sku;
import java.io.IOException;
import java.util.Map;

public final class ServiceResourceInner
extends Resource {
    private ClusterResourceProperties properties;
    private Sku sku;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    public ClusterResourceProperties properties() {
        return this.properties;
    }

    public ServiceResourceInner withProperties(ClusterResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public ServiceResourceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public ServiceResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ServiceResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static ServiceResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceResourceInner)((Object)jsonReader.readObject(reader -> {
            ServiceResourceInner deserializedServiceResourceInner = new ServiceResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedServiceResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedServiceResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedServiceResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedServiceResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedServiceResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedServiceResourceInner.properties = ClusterResourceProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedServiceResourceInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedServiceResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceResourceInner;
        }));
    }
}

