/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appplatform.fluent.DeploymentsClient;
import com.azure.resourcemanager.appplatform.fluent.models.DeploymentResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.LogFileUrlResponseInner;
import com.azure.resourcemanager.appplatform.fluent.models.RemoteDebuggingInner;
import com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.azure.resourcemanager.appplatform.models.DeploymentResourceCollection;
import com.azure.resourcemanager.appplatform.models.DiagnosticParameters;
import com.azure.resourcemanager.appplatform.models.RemoteDebuggingPayload;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DeploymentsClientImpl
implements DeploymentsClient {
    private final DeploymentsService service;
    private final AppPlatformManagementClientImpl client;

    DeploymentsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = (DeploymentsService)RestProxy.create(DeploymentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentResourceInner> getAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DeploymentResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentResourceInner> getWithResponse(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentResourceInner get(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return (DeploymentResourceInner)((Object)this.getWithResponse(resourceGroupName, serviceName, appName, deploymentName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (deploymentResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentResource is required and cannot be null."));
        }
        deploymentResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, deploymentResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (deploymentResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentResource is required and cannot be null."));
        }
        deploymentResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, deploymentResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentResourceInner>, DeploymentResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentResourceInner.class), (Type)((Object)DeploymentResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentResourceInner>, DeploymentResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentResourceInner.class), (Type)((Object)DeploymentResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentResourceInner>, DeploymentResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentResourceInner>, DeploymentResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentResourceInner createOrUpdate(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource) {
        return (DeploymentResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentResourceInner createOrUpdate(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource, Context context) {
        return (DeploymentResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, appName, deploymentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, appName, deploymentName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, appName, deploymentName).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, appName, deploymentName, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        this.deleteAsync(resourceGroupName, serviceName, appName, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        this.deleteAsync(resourceGroupName, serviceName, appName, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (deploymentResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentResource is required and cannot be null."));
        }
        deploymentResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, deploymentResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (deploymentResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentResource is required and cannot be null."));
        }
        deploymentResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, deploymentResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentResourceInner>, DeploymentResourceInner> beginUpdateAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentResourceInner.class), (Type)((Object)DeploymentResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentResourceInner>, DeploymentResourceInner> beginUpdateAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentResourceInner.class), (Type)((Object)DeploymentResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentResourceInner>, DeploymentResourceInner> beginUpdate(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentResourceInner>, DeploymentResourceInner> beginUpdate(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentResourceInner> updateAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentResourceInner> updateAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentResourceInner update(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource) {
        return (DeploymentResourceInner)((Object)this.updateAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentResourceInner update(String resourceGroupName, String serviceName, String appName, String deploymentName, DeploymentResourceInner deploymentResource, Context context) {
        return (DeploymentResourceInner)((Object)this.updateAsync(resourceGroupName, serviceName, appName, deploymentName, deploymentResource, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String appName, List<String> version) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        String accept = "application/json";
        ArrayList versionConverted = version == null ? new ArrayList() : version.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, versionConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentResourceCollection)res.getValue()).value(), ((DeploymentResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String appName, List<String> version, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        String accept = "application/json";
        ArrayList<String> versionConverted = version == null ? new ArrayList<String>() : version.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, versionConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentResourceCollection)res.getValue()).value(), ((DeploymentResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentResourceInner> listAsync(String resourceGroupName, String serviceName, String appName, List<String> version) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, appName, version), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentResourceInner> listAsync(String resourceGroupName, String serviceName, String appName) {
        List version = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, appName, version), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeploymentResourceInner> listAsync(String resourceGroupName, String serviceName, String appName, List<String> version, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, appName, version, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentResourceInner> list(String resourceGroupName, String serviceName, String appName) {
        List<String> version = null;
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, appName, version));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentResourceInner> list(String resourceGroupName, String serviceName, String appName, List<String> version, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, appName, version, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentResourceInner>> listForClusterSinglePageAsync(String resourceGroupName, String serviceName, List<String> version, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        ArrayList versionConverted = version == null ? new ArrayList() : version.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return FluxUtil.withContext(context -> this.service.listForCluster(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, versionConverted, expand, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentResourceCollection)res.getValue()).value(), ((DeploymentResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentResourceInner>> listForClusterSinglePageAsync(String resourceGroupName, String serviceName, List<String> version, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        ArrayList<String> versionConverted = version == null ? new ArrayList<String>() : version.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        context = this.client.mergeContext(context);
        return this.service.listForCluster(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, versionConverted, expand, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentResourceCollection)res.getValue()).value(), ((DeploymentResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentResourceInner> listForClusterAsync(String resourceGroupName, String serviceName, List<String> version, String expand) {
        return new PagedFlux(() -> this.listForClusterSinglePageAsync(resourceGroupName, serviceName, version, expand), nextLink -> this.listForClusterNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentResourceInner> listForClusterAsync(String resourceGroupName, String serviceName) {
        List version = null;
        String expand = null;
        return new PagedFlux(() -> this.listForClusterSinglePageAsync(resourceGroupName, serviceName, version, expand), nextLink -> this.listForClusterNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeploymentResourceInner> listForClusterAsync(String resourceGroupName, String serviceName, List<String> version, String expand, Context context) {
        return new PagedFlux(() -> this.listForClusterSinglePageAsync(resourceGroupName, serviceName, version, expand, context), nextLink -> this.listForClusterNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentResourceInner> listForCluster(String resourceGroupName, String serviceName) {
        List<String> version = null;
        String expand = null;
        return new PagedIterable(this.listForClusterAsync(resourceGroupName, serviceName, version, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentResourceInner> listForCluster(String resourceGroupName, String serviceName, List<String> version, String expand, Context context) {
        return new PagedIterable(this.listForClusterAsync(resourceGroupName, serviceName, version, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.start(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return this.beginStartAsync(resourceGroupName, serviceName, appName, deploymentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return this.beginStartAsync(resourceGroupName, serviceName, appName, deploymentName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return this.beginStartAsync(resourceGroupName, serviceName, appName, deploymentName).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> startAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return this.beginStartAsync(resourceGroupName, serviceName, appName, deploymentName, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        this.startAsync(resourceGroupName, serviceName, appName, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        this.startAsync(resourceGroupName, serviceName, appName, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stop(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.stop(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginStopAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.stopWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginStopAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.stopWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStop(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return this.beginStopAsync(resourceGroupName, serviceName, appName, deploymentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStop(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return this.beginStopAsync(resourceGroupName, serviceName, appName, deploymentName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return this.beginStopAsync(resourceGroupName, serviceName, appName, deploymentName).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> stopAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return this.beginStopAsync(resourceGroupName, serviceName, appName, deploymentName, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        this.stopAsync(resourceGroupName, serviceName, appName, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        this.stopAsync(resourceGroupName, serviceName, appName, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restart(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restart(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return this.beginRestartAsync(resourceGroupName, serviceName, appName, deploymentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return this.beginRestartAsync(resourceGroupName, serviceName, appName, deploymentName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restartAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return this.beginRestartAsync(resourceGroupName, serviceName, appName, deploymentName).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> restartAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return this.beginRestartAsync(resourceGroupName, serviceName, appName, deploymentName, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restart(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        this.restartAsync(resourceGroupName, serviceName, appName, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restart(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        this.restartAsync(resourceGroupName, serviceName, appName, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> enableRemoteDebuggingWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, RemoteDebuggingPayload remoteDebuggingPayload) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (remoteDebuggingPayload != null) {
            remoteDebuggingPayload.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.enableRemoteDebugging(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, remoteDebuggingPayload, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> enableRemoteDebuggingWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, RemoteDebuggingPayload remoteDebuggingPayload, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (remoteDebuggingPayload != null) {
            remoteDebuggingPayload.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.enableRemoteDebugging(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, remoteDebuggingPayload, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<RemoteDebuggingInner>, RemoteDebuggingInner> beginEnableRemoteDebuggingAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, RemoteDebuggingPayload remoteDebuggingPayload) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.enableRemoteDebuggingWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, remoteDebuggingPayload);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RemoteDebuggingInner.class), (Type)((Object)RemoteDebuggingInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<RemoteDebuggingInner>, RemoteDebuggingInner> beginEnableRemoteDebuggingAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        RemoteDebuggingPayload remoteDebuggingPayload = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.enableRemoteDebuggingWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, remoteDebuggingPayload);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RemoteDebuggingInner.class), (Type)((Object)RemoteDebuggingInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RemoteDebuggingInner>, RemoteDebuggingInner> beginEnableRemoteDebuggingAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, RemoteDebuggingPayload remoteDebuggingPayload, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.enableRemoteDebuggingWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, remoteDebuggingPayload, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RemoteDebuggingInner.class), (Type)((Object)RemoteDebuggingInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RemoteDebuggingInner>, RemoteDebuggingInner> beginEnableRemoteDebugging(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        RemoteDebuggingPayload remoteDebuggingPayload = null;
        return this.beginEnableRemoteDebuggingAsync(resourceGroupName, serviceName, appName, deploymentName, remoteDebuggingPayload).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RemoteDebuggingInner>, RemoteDebuggingInner> beginEnableRemoteDebugging(String resourceGroupName, String serviceName, String appName, String deploymentName, RemoteDebuggingPayload remoteDebuggingPayload, Context context) {
        return this.beginEnableRemoteDebuggingAsync(resourceGroupName, serviceName, appName, deploymentName, remoteDebuggingPayload, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoteDebuggingInner> enableRemoteDebuggingAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, RemoteDebuggingPayload remoteDebuggingPayload) {
        return this.beginEnableRemoteDebuggingAsync(resourceGroupName, serviceName, appName, deploymentName, remoteDebuggingPayload).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoteDebuggingInner> enableRemoteDebuggingAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        RemoteDebuggingPayload remoteDebuggingPayload = null;
        return this.beginEnableRemoteDebuggingAsync(resourceGroupName, serviceName, appName, deploymentName, remoteDebuggingPayload).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemoteDebuggingInner> enableRemoteDebuggingAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, RemoteDebuggingPayload remoteDebuggingPayload, Context context) {
        return this.beginEnableRemoteDebuggingAsync(resourceGroupName, serviceName, appName, deploymentName, remoteDebuggingPayload, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemoteDebuggingInner enableRemoteDebugging(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        RemoteDebuggingPayload remoteDebuggingPayload = null;
        return (RemoteDebuggingInner)this.enableRemoteDebuggingAsync(resourceGroupName, serviceName, appName, deploymentName, remoteDebuggingPayload).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemoteDebuggingInner enableRemoteDebugging(String resourceGroupName, String serviceName, String appName, String deploymentName, RemoteDebuggingPayload remoteDebuggingPayload, Context context) {
        return (RemoteDebuggingInner)this.enableRemoteDebuggingAsync(resourceGroupName, serviceName, appName, deploymentName, remoteDebuggingPayload, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> disableRemoteDebuggingWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.disableRemoteDebugging(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> disableRemoteDebuggingWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.disableRemoteDebugging(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<RemoteDebuggingInner>, RemoteDebuggingInner> beginDisableRemoteDebuggingAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.disableRemoteDebuggingWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RemoteDebuggingInner.class), (Type)((Object)RemoteDebuggingInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RemoteDebuggingInner>, RemoteDebuggingInner> beginDisableRemoteDebuggingAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.disableRemoteDebuggingWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RemoteDebuggingInner.class), (Type)((Object)RemoteDebuggingInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RemoteDebuggingInner>, RemoteDebuggingInner> beginDisableRemoteDebugging(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return this.beginDisableRemoteDebuggingAsync(resourceGroupName, serviceName, appName, deploymentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RemoteDebuggingInner>, RemoteDebuggingInner> beginDisableRemoteDebugging(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return this.beginDisableRemoteDebuggingAsync(resourceGroupName, serviceName, appName, deploymentName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoteDebuggingInner> disableRemoteDebuggingAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return this.beginDisableRemoteDebuggingAsync(resourceGroupName, serviceName, appName, deploymentName).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemoteDebuggingInner> disableRemoteDebuggingAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return this.beginDisableRemoteDebuggingAsync(resourceGroupName, serviceName, appName, deploymentName, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemoteDebuggingInner disableRemoteDebugging(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return (RemoteDebuggingInner)this.disableRemoteDebuggingAsync(resourceGroupName, serviceName, appName, deploymentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemoteDebuggingInner disableRemoteDebugging(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return (RemoteDebuggingInner)this.disableRemoteDebuggingAsync(resourceGroupName, serviceName, appName, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RemoteDebuggingInner>> getRemoteDebuggingConfigWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRemoteDebuggingConfig(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemoteDebuggingInner>> getRemoteDebuggingConfigWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getRemoteDebuggingConfig(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoteDebuggingInner> getRemoteDebuggingConfigAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return this.getRemoteDebuggingConfigWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName).flatMap(res -> Mono.justOrEmpty((Object)((RemoteDebuggingInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemoteDebuggingInner> getRemoteDebuggingConfigWithResponse(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return (Response)this.getRemoteDebuggingConfigWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemoteDebuggingInner getRemoteDebuggingConfig(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return (RemoteDebuggingInner)this.getRemoteDebuggingConfigWithResponse(resourceGroupName, serviceName, appName, deploymentName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LogFileUrlResponseInner>> getLogFileUrlWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getLogFileUrl(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogFileUrlResponseInner>> getLogFileUrlWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getLogFileUrl(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LogFileUrlResponseInner> getLogFileUrlAsync(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return this.getLogFileUrlWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName).flatMap(res -> Mono.justOrEmpty((Object)((LogFileUrlResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogFileUrlResponseInner> getLogFileUrlWithResponse(String resourceGroupName, String serviceName, String appName, String deploymentName, Context context) {
        return (Response)this.getLogFileUrlWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogFileUrlResponseInner getLogFileUrl(String resourceGroupName, String serviceName, String appName, String deploymentName) {
        return (LogFileUrlResponseInner)this.getLogFileUrlWithResponse(resourceGroupName, serviceName, appName, deploymentName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> generateHeapDumpWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (diagnosticParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticParameters is required and cannot be null."));
        }
        diagnosticParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.generateHeapDump(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> generateHeapDumpWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (diagnosticParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticParameters is required and cannot be null."));
        }
        diagnosticParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.generateHeapDump(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginGenerateHeapDumpAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.generateHeapDumpWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginGenerateHeapDumpAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.generateHeapDumpWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginGenerateHeapDump(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        return this.beginGenerateHeapDumpAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginGenerateHeapDump(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        return this.beginGenerateHeapDumpAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> generateHeapDumpAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        return this.beginGenerateHeapDumpAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> generateHeapDumpAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        return this.beginGenerateHeapDumpAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void generateHeapDump(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        this.generateHeapDumpAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void generateHeapDump(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        this.generateHeapDumpAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> generateThreadDumpWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (diagnosticParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticParameters is required and cannot be null."));
        }
        diagnosticParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.generateThreadDump(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> generateThreadDumpWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (diagnosticParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticParameters is required and cannot be null."));
        }
        diagnosticParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.generateThreadDump(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginGenerateThreadDumpAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.generateThreadDumpWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginGenerateThreadDumpAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.generateThreadDumpWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginGenerateThreadDump(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        return this.beginGenerateThreadDumpAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginGenerateThreadDump(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        return this.beginGenerateThreadDumpAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> generateThreadDumpAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        return this.beginGenerateThreadDumpAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> generateThreadDumpAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        return this.beginGenerateThreadDumpAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void generateThreadDump(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        this.generateThreadDumpAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void generateThreadDump(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        this.generateThreadDumpAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> startJfrWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (diagnosticParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticParameters is required and cannot be null."));
        }
        diagnosticParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.startJfr(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startJfrWithResponseAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (appName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (diagnosticParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diagnosticParameters is required and cannot be null."));
        }
        diagnosticParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.startJfr(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginStartJfrAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startJfrWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginStartJfrAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.startJfrWithResponseAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStartJfr(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        return this.beginStartJfrAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStartJfr(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        return this.beginStartJfrAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startJfrAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        return this.beginStartJfrAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> startJfrAsync(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        return this.beginStartJfrAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startJfr(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters) {
        this.startJfrAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startJfr(String resourceGroupName, String serviceName, String appName, String deploymentName, DiagnosticParameters diagnosticParameters, Context context) {
        this.startJfrAsync(resourceGroupName, serviceName, appName, deploymentName, diagnosticParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentResourceCollection)res.getValue()).value(), ((DeploymentResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentResourceCollection)res.getValue()).value(), ((DeploymentResourceCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentResourceInner>> listForClusterNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForClusterNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentResourceCollection)res.getValue()).value(), ((DeploymentResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentResourceInner>> listForClusterNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForClusterNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentResourceCollection)res.getValue()).value(), ((DeploymentResourceCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    public static interface DeploymentsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @BodyParam(value="application/json") DeploymentResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @BodyParam(value="application/json") DeploymentResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentResourceCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @QueryParam(value="version", multipleQueryParams=true) List<String> var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/deployments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentResourceCollection>> listForCluster(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @QueryParam(value="version", multipleQueryParams=true) List<String> var6, @QueryParam(value="$expand") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> start(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}/stop")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> stop(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}/restart")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> restart(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}/enableRemoteDebugging")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> enableRemoteDebugging(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @BodyParam(value="application/json") RemoteDebuggingPayload var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}/disableRemoteDebugging")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> disableRemoteDebugging(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}/getRemoteDebuggingConfig")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RemoteDebuggingInner>> getRemoteDebuggingConfig(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}/getLogFileUrl")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogFileUrlResponseInner>> getLogFileUrl(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}/generateHeapDump")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> generateHeapDump(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @BodyParam(value="application/json") DiagnosticParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}/generateThreadDump")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> generateThreadDump(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @BodyParam(value="application/json") DiagnosticParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}/startJFR")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> startJfr(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="appName") String var6, @PathParam(value="deploymentName") String var7, @BodyParam(value="application/json") DiagnosticParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentResourceCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentResourceCollection>> listForClusterNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

