/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ContainerRegistryCredentials;
import java.io.IOException;

public final class ContainerRegistryBasicCredentials
extends ContainerRegistryCredentials {
    private String type = "BasicAuth";
    private String server;
    private String username;
    private String password;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistryBasicCredentials.class);

    @Override
    public String type() {
        return this.type;
    }

    public String server() {
        return this.server;
    }

    public ContainerRegistryBasicCredentials withServer(String server) {
        this.server = server;
        return this;
    }

    public String username() {
        return this.username;
    }

    public ContainerRegistryBasicCredentials withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public ContainerRegistryBasicCredentials withPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.server() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property server in model ContainerRegistryBasicCredentials"));
        }
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model ContainerRegistryBasicCredentials"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model ContainerRegistryBasicCredentials"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("server", this.server);
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static ContainerRegistryBasicCredentials fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerRegistryBasicCredentials)jsonReader.readObject(reader -> {
            ContainerRegistryBasicCredentials deserializedContainerRegistryBasicCredentials = new ContainerRegistryBasicCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedContainerRegistryBasicCredentials.server = reader.getString();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedContainerRegistryBasicCredentials.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedContainerRegistryBasicCredentials.password = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedContainerRegistryBasicCredentials.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerRegistryBasicCredentials;
        });
    }
}

