/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.ContainerRegistryCredentials;
import com.azure.resourcemanager.appplatform.models.ContainerRegistryProvisioningState;
import java.io.IOException;

public final class ContainerRegistryProperties
implements JsonSerializable<ContainerRegistryProperties> {
    private ContainerRegistryCredentials credentials;
    private ContainerRegistryProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistryProperties.class);

    public ContainerRegistryCredentials credentials() {
        return this.credentials;
    }

    public ContainerRegistryProperties withCredentials(ContainerRegistryCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public ContainerRegistryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.credentials() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property credentials in model ContainerRegistryProperties"));
        }
        this.credentials().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials);
        return jsonWriter.writeEndObject();
    }

    public static ContainerRegistryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerRegistryProperties)jsonReader.readObject(reader -> {
            ContainerRegistryProperties deserializedContainerRegistryProperties = new ContainerRegistryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("credentials".equals(fieldName)) {
                    deserializedContainerRegistryProperties.credentials = ContainerRegistryCredentials.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedContainerRegistryProperties.provisioningState = ContainerRegistryProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerRegistryProperties;
        });
    }
}

