/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.InAvailabilityReasonType;
import java.io.IOException;

public final class ResourceNameAvailabilityInner
implements JsonSerializable<ResourceNameAvailabilityInner> {
    private Boolean nameAvailable;
    private InAvailabilityReasonType reason;
    private String message;

    public Boolean nameAvailable() {
        return this.nameAvailable;
    }

    public ResourceNameAvailabilityInner withNameAvailable(Boolean nameAvailable) {
        this.nameAvailable = nameAvailable;
        return this;
    }

    public InAvailabilityReasonType reason() {
        return this.reason;
    }

    public ResourceNameAvailabilityInner withReason(InAvailabilityReasonType reason) {
        this.reason = reason;
        return this;
    }

    public String message() {
        return this.message;
    }

    public ResourceNameAvailabilityInner withMessage(String message) {
        this.message = message;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("nameAvailable", this.nameAvailable);
        jsonWriter.writeStringField("reason", this.reason == null ? null : this.reason.toString());
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    public static ResourceNameAvailabilityInner fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceNameAvailabilityInner)jsonReader.readObject(reader -> {
            ResourceNameAvailabilityInner deserializedResourceNameAvailabilityInner = new ResourceNameAvailabilityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nameAvailable".equals(fieldName)) {
                    deserializedResourceNameAvailabilityInner.nameAvailable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedResourceNameAvailabilityInner.reason = InAvailabilityReasonType.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedResourceNameAvailabilityInner.message = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceNameAvailabilityInner;
        });
    }
}

