/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.BuildStatus;
import com.azure.resourcemanager.appservice.models.DatabaseConnectionOverview;
import com.azure.resourcemanager.appservice.models.StaticSiteLinkedBackend;
import com.azure.resourcemanager.appservice.models.StaticSiteUserProvidedFunctionApp;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class StaticSiteBuildArmResourceProperties
implements JsonSerializable<StaticSiteBuildArmResourceProperties> {
    private String buildId;
    private String sourceBranch;
    private String pullRequestTitle;
    private String hostname;
    private OffsetDateTime createdTimeUtc;
    private OffsetDateTime lastUpdatedOn;
    private BuildStatus status;
    private List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps;
    private List<StaticSiteLinkedBackend> linkedBackends;
    private List<DatabaseConnectionOverview> databaseConnections;

    public String buildId() {
        return this.buildId;
    }

    public String sourceBranch() {
        return this.sourceBranch;
    }

    public String pullRequestTitle() {
        return this.pullRequestTitle;
    }

    public String hostname() {
        return this.hostname;
    }

    public OffsetDateTime createdTimeUtc() {
        return this.createdTimeUtc;
    }

    public OffsetDateTime lastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public BuildStatus status() {
        return this.status;
    }

    public List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps() {
        return this.userProvidedFunctionApps;
    }

    public List<StaticSiteLinkedBackend> linkedBackends() {
        return this.linkedBackends;
    }

    public List<DatabaseConnectionOverview> databaseConnections() {
        return this.databaseConnections;
    }

    public void validate() {
        if (this.userProvidedFunctionApps() != null) {
            this.userProvidedFunctionApps().forEach(e -> e.validate());
        }
        if (this.linkedBackends() != null) {
            this.linkedBackends().forEach(e -> e.validate());
        }
        if (this.databaseConnections() != null) {
            this.databaseConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static StaticSiteBuildArmResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StaticSiteBuildArmResourceProperties)jsonReader.readObject(reader -> {
            StaticSiteBuildArmResourceProperties deserializedStaticSiteBuildArmResourceProperties = new StaticSiteBuildArmResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("buildId".equals(fieldName)) {
                    deserializedStaticSiteBuildArmResourceProperties.buildId = reader.getString();
                    continue;
                }
                if ("sourceBranch".equals(fieldName)) {
                    deserializedStaticSiteBuildArmResourceProperties.sourceBranch = reader.getString();
                    continue;
                }
                if ("pullRequestTitle".equals(fieldName)) {
                    deserializedStaticSiteBuildArmResourceProperties.pullRequestTitle = reader.getString();
                    continue;
                }
                if ("hostname".equals(fieldName)) {
                    deserializedStaticSiteBuildArmResourceProperties.hostname = reader.getString();
                    continue;
                }
                if ("createdTimeUtc".equals(fieldName)) {
                    deserializedStaticSiteBuildArmResourceProperties.createdTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedOn".equals(fieldName)) {
                    deserializedStaticSiteBuildArmResourceProperties.lastUpdatedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedStaticSiteBuildArmResourceProperties.status = BuildStatus.fromString(reader.getString());
                    continue;
                }
                if ("userProvidedFunctionApps".equals(fieldName)) {
                    List userProvidedFunctionApps;
                    deserializedStaticSiteBuildArmResourceProperties.userProvidedFunctionApps = userProvidedFunctionApps = reader.readArray(reader1 -> StaticSiteUserProvidedFunctionApp.fromJson(reader1));
                    continue;
                }
                if ("linkedBackends".equals(fieldName)) {
                    List linkedBackends;
                    deserializedStaticSiteBuildArmResourceProperties.linkedBackends = linkedBackends = reader.readArray(reader1 -> StaticSiteLinkedBackend.fromJson(reader1));
                    continue;
                }
                if ("databaseConnections".equals(fieldName)) {
                    List databaseConnections;
                    deserializedStaticSiteBuildArmResourceProperties.databaseConnections = databaseConnections = reader.readArray(reader1 -> DatabaseConnectionOverview.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStaticSiteBuildArmResourceProperties;
        });
    }
}

