/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.VnetValidationTestFailure;
import java.io.IOException;
import java.util.List;

public final class VnetValidationFailureDetailsProperties
implements JsonSerializable<VnetValidationFailureDetailsProperties> {
    private String message;
    private Boolean failed;
    private List<VnetValidationTestFailure> failedTests;
    private List<VnetValidationTestFailure> warnings;

    public String message() {
        return this.message;
    }

    public VnetValidationFailureDetailsProperties withMessage(String message) {
        this.message = message;
        return this;
    }

    public Boolean failed() {
        return this.failed;
    }

    public VnetValidationFailureDetailsProperties withFailed(Boolean failed) {
        this.failed = failed;
        return this;
    }

    public List<VnetValidationTestFailure> failedTests() {
        return this.failedTests;
    }

    public VnetValidationFailureDetailsProperties withFailedTests(List<VnetValidationTestFailure> failedTests) {
        this.failedTests = failedTests;
        return this;
    }

    public List<VnetValidationTestFailure> warnings() {
        return this.warnings;
    }

    public VnetValidationFailureDetailsProperties withWarnings(List<VnetValidationTestFailure> warnings) {
        this.warnings = warnings;
        return this;
    }

    public void validate() {
        if (this.failedTests() != null) {
            this.failedTests().forEach(e -> e.validate());
        }
        if (this.warnings() != null) {
            this.warnings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeBooleanField("failed", this.failed);
        jsonWriter.writeArrayField("failedTests", this.failedTests, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("warnings", this.warnings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VnetValidationFailureDetailsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VnetValidationFailureDetailsProperties)jsonReader.readObject(reader -> {
            VnetValidationFailureDetailsProperties deserializedVnetValidationFailureDetailsProperties = new VnetValidationFailureDetailsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("message".equals(fieldName)) {
                    deserializedVnetValidationFailureDetailsProperties.message = reader.getString();
                    continue;
                }
                if ("failed".equals(fieldName)) {
                    deserializedVnetValidationFailureDetailsProperties.failed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("failedTests".equals(fieldName)) {
                    List failedTests;
                    deserializedVnetValidationFailureDetailsProperties.failedTests = failedTests = reader.readArray(reader1 -> VnetValidationTestFailure.fromJson(reader1));
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings;
                    deserializedVnetValidationFailureDetailsProperties.warnings = warnings = reader.readArray(reader1 -> VnetValidationTestFailure.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVnetValidationFailureDetailsProperties;
        });
    }
}

