/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ContainerInfo;
import com.azure.resourcemanager.appservice.models.SiteRuntimeState;
import java.io.IOException;
import java.util.Map;

public final class WebSiteInstanceStatusProperties
implements JsonSerializable<WebSiteInstanceStatusProperties> {
    private SiteRuntimeState state;
    private String statusUrl;
    private String detectorUrl;
    private String consoleUrl;
    private String healthCheckUrl;
    private Map<String, ContainerInfo> containers;

    public SiteRuntimeState state() {
        return this.state;
    }

    public WebSiteInstanceStatusProperties withState(SiteRuntimeState state) {
        this.state = state;
        return this;
    }

    public String statusUrl() {
        return this.statusUrl;
    }

    public WebSiteInstanceStatusProperties withStatusUrl(String statusUrl) {
        this.statusUrl = statusUrl;
        return this;
    }

    public String detectorUrl() {
        return this.detectorUrl;
    }

    public WebSiteInstanceStatusProperties withDetectorUrl(String detectorUrl) {
        this.detectorUrl = detectorUrl;
        return this;
    }

    public String consoleUrl() {
        return this.consoleUrl;
    }

    public WebSiteInstanceStatusProperties withConsoleUrl(String consoleUrl) {
        this.consoleUrl = consoleUrl;
        return this;
    }

    public String healthCheckUrl() {
        return this.healthCheckUrl;
    }

    public WebSiteInstanceStatusProperties withHealthCheckUrl(String healthCheckUrl) {
        this.healthCheckUrl = healthCheckUrl;
        return this;
    }

    public Map<String, ContainerInfo> containers() {
        return this.containers;
    }

    public WebSiteInstanceStatusProperties withContainers(Map<String, ContainerInfo> containers) {
        this.containers = containers;
        return this;
    }

    public void validate() {
        if (this.containers() != null) {
            this.containers().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("statusUrl", this.statusUrl);
        jsonWriter.writeStringField("detectorUrl", this.detectorUrl);
        jsonWriter.writeStringField("consoleUrl", this.consoleUrl);
        jsonWriter.writeStringField("healthCheckUrl", this.healthCheckUrl);
        jsonWriter.writeMapField("containers", this.containers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static WebSiteInstanceStatusProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WebSiteInstanceStatusProperties)jsonReader.readObject(reader -> {
            WebSiteInstanceStatusProperties deserializedWebSiteInstanceStatusProperties = new WebSiteInstanceStatusProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusProperties.state = SiteRuntimeState.fromString(reader.getString());
                    continue;
                }
                if ("statusUrl".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusProperties.statusUrl = reader.getString();
                    continue;
                }
                if ("detectorUrl".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusProperties.detectorUrl = reader.getString();
                    continue;
                }
                if ("consoleUrl".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusProperties.consoleUrl = reader.getString();
                    continue;
                }
                if ("healthCheckUrl".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusProperties.healthCheckUrl = reader.getString();
                    continue;
                }
                if ("containers".equals(fieldName)) {
                    Map containers;
                    deserializedWebSiteInstanceStatusProperties.containers = containers = reader.readMap(reader1 -> ContainerInfo.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebSiteInstanceStatusProperties;
        });
    }
}

