/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class WorkflowResource
extends Resource {
    private String id;
    private String name;
    private String type;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public WorkflowResource withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public WorkflowResource withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static WorkflowResource fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowResource)((Object)jsonReader.readObject(reader -> {
            WorkflowResource deserializedWorkflowResource = new WorkflowResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkflowResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkflowResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkflowResource.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWorkflowResource.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedWorkflowResource.withTags(tags);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowResource;
        }));
    }
}

