/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@BoxResourceType(value="folder_lock")
public class BoxFolderLock
extends BoxResource {
    public static final URLTemplate DELETE_FOLDER_LOCK_URL_TEMPLATE = new URLTemplate("folder_locks/%s");

    public BoxFolderLock(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public void delete() {
        URL url = DELETE_FOLDER_LOCK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        request.send().close();
    }

    public class Info
    extends BoxResource.Info {
        private BoxFolder.Info folder;
        private BoxUser.Info createdBy;
        private Date createdAt;
        private String lockType;
        private Map<String, Boolean> lockedOperations;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxFolderLock.this;
        }

        public BoxFolder.Info getFolder() {
            return this.folder;
        }

        public BoxUser.Info getCreatedBy() {
            return this.createdBy;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public String getLockType() {
            return this.lockType;
        }

        public Map<String, Boolean> getLockedOperations() {
            return this.lockedOperations;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("folder")) {
                    BoxFolder folder;
                    JsonObject folderJSON = value.asObject();
                    String folderID = folderJSON.get("id").asString();
                    BoxFolder boxFolder = folder = new BoxFolder(BoxFolderLock.this.getAPI(), folderID);
                    boxFolder.getClass();
                    this.folder = boxFolder.new BoxFolder.Info(folderJSON);
                } else if (memberName.equals("created_by")) {
                    JsonObject userJSON = value.asObject();
                    if (this.createdBy == null) {
                        BoxUser user;
                        String userID = userJSON.get("id").asString();
                        BoxUser boxUser = user = new BoxUser(BoxFolderLock.this.getAPI(), userID);
                        boxUser.getClass();
                        this.createdBy = boxUser.new BoxUser.Info(userJSON);
                    } else {
                        this.createdBy.update(userJSON);
                    }
                } else if (memberName.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("lock_type")) {
                    this.lockType = value.asString();
                } else if (memberName.equals("locked_operations")) {
                    JsonObject lockedOperationsJSON = value.asObject();
                    HashMap<String, Boolean> operationsMap = new HashMap<String, Boolean>();
                    for (JsonObject.Member operationMember : lockedOperationsJSON) {
                        String operation = operationMember.getName();
                        Boolean operationBoolean = operationMember.getValue().asBoolean();
                        operationsMap.put(operation, operationBoolean);
                    }
                    this.lockedOperations = operationsMap;
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }
}

