/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxEnterprise;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;

@BoxResourceType(value="metadata_cascade_policy")
public class BoxMetadataCascadePolicy
extends BoxResource {
    public static final URLTemplate GET_ALL_METADATA_CASCADE_POLICIES_URL_TEMPLATE = new URLTemplate("metadata_cascade_policies");
    public static final URLTemplate METADATA_CASCADE_POLICIES_URL_TEMPLATE = new URLTemplate("metadata_cascade_policies/%s");
    public static final URLTemplate FORCE_METADATA_CASCADE_POLICIES_URL_TEMPLATE = new URLTemplate("metadata_cascade_policies/%s/apply");
    private static final int DEFAULT_LIMIT = 100;

    public BoxMetadataCascadePolicy(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Iterable<Info> getAll(BoxAPIConnection api, String folderID, String ... fields) {
        return BoxMetadataCascadePolicy.getAll(api, folderID, null, 100, fields);
    }

    public static Iterable<Info> getAll(final BoxAPIConnection api, String folderID, String ownerEnterpriseID, int limit, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        builder.appendParam("folder_id", folderID);
        if (ownerEnterpriseID != null) {
            builder.appendParam("owner_enterprise_id", ownerEnterpriseID);
        }
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new BoxResourceIterable<Info>(api, GET_ALL_METADATA_CASCADE_POLICIES_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]), limit){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxMetadataCascadePolicy cascadePolicy;
                BoxMetadataCascadePolicy boxMetadataCascadePolicy = cascadePolicy = new BoxMetadataCascadePolicy(api, jsonObject.get("id").asString());
                boxMetadataCascadePolicy.getClass();
                return boxMetadataCascadePolicy.new Info(jsonObject);
            }
        };
    }

    public static Info create(BoxAPIConnection api, String folderID, String scope, String templateKey) {
        URL url = GET_ALL_METADATA_CASCADE_POLICIES_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        JsonObject requestJSON = new JsonObject().add("folder_id", folderID).add("scope", scope).add("templateKey", templateKey);
        request.setBody(requestJSON.toString());
        try (BoxJSONResponse response = request.send();){
            BoxMetadataCascadePolicy createdMetadataCascadePolicy;
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            BoxMetadataCascadePolicy boxMetadataCascadePolicy = createdMetadataCascadePolicy = new BoxMetadataCascadePolicy(api, responseJSON.get("id").asString());
            boxMetadataCascadePolicy.getClass();
            Info info = boxMetadataCascadePolicy.new Info(responseJSON);
            return info;
        }
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = METADATA_CASCADE_POLICIES_URL_TEMPLATE.buildAlphaWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            Info info = new Info(responseJSON);
            return info;
        }
    }

    public void forceApply(String conflictResolution) {
        URL url = FORCE_METADATA_CASCADE_POLICIES_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "POST");
        JsonObject requestJSON = new JsonObject().add("conflict_resolution", conflictResolution);
        request.setBody(requestJSON.toString());
        request.send().close();
    }

    public void delete() {
        URL url = METADATA_CASCADE_POLICIES_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        request.send().close();
    }

    public class Info
    extends BoxResource.Info {
        private BoxEnterprise ownerEnterprise;
        private BoxFolder.Info parent;
        private String scope;
        private String templateKey;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        public BoxEnterprise getOwnerEnterprise() {
            return this.ownerEnterprise;
        }

        public BoxFolder.Info getParent() {
            return this.parent;
        }

        public String getScope() {
            return this.scope;
        }

        public String getTemplateKey() {
            return this.templateKey;
        }

        @Override
        public BoxMetadataCascadePolicy getResource() {
            return BoxMetadataCascadePolicy.this;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("owner_enterprise")) {
                    JsonObject jsonObject = value.asObject();
                    this.ownerEnterprise = new BoxEnterprise(jsonObject);
                } else if (memberName.equals("parent")) {
                    JsonObject parentJSON = value.asObject();
                    if (this.parent == null) {
                        BoxFolder folder;
                        String parentID = parentJSON.get("id").asString();
                        BoxFolder boxFolder = folder = new BoxFolder(BoxMetadataCascadePolicy.this.getAPI(), parentID);
                        boxFolder.getClass();
                        this.parent = boxFolder.new BoxFolder.Info(parentJSON);
                    } else {
                        this.parent.update(parentJSON);
                    }
                } else if (memberName.equals("scope")) {
                    this.scope = value.asString();
                } else if (memberName.equals("templateKey")) {
                    this.templateKey = value.asString();
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }
}

