/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxTermsOfService;
import com.box.sdk.BoxUser;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@BoxResourceType(value="terms_of_service_user_status")
public class BoxTermsOfServiceUserStatus
extends BoxResource {
    public static final URLTemplate TERMS_OF_SERVICE_USER_STATUSES_TEMPLATE = new URLTemplate("terms_of_service_user_statuses/%s");
    public static final URLTemplate ALL_TERMS_OF_SERVICE_USER_STATUSES_TEMPLATE = new URLTemplate("terms_of_service_user_statuses");

    public BoxTermsOfServiceUserStatus(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info create(BoxAPIConnection api, String termsOfServiceID, Boolean isAccepted) {
        return BoxTermsOfServiceUserStatus.create(api, termsOfServiceID, isAccepted, null);
    }

    public static Info create(BoxAPIConnection api, String termsOfServiceID, Boolean isAccepted, String userID) {
        URL url = ALL_TERMS_OF_SERVICE_USER_STATUSES_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        JsonObject requestJSON = new JsonObject().add("tos", (JsonValue)new JsonObject().add("type", "terms_of_service").add("id", termsOfServiceID)).add("is_accepted", isAccepted.booleanValue());
        if (userID != null) {
            requestJSON.add("user", (JsonValue)new JsonObject().add("type", "user").add("id", userID));
        }
        request.setBody(requestJSON.toString());
        try (BoxJSONResponse response = request.send();){
            BoxTermsOfServiceUserStatus termsOfServiceUserStatus;
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            BoxTermsOfServiceUserStatus boxTermsOfServiceUserStatus = termsOfServiceUserStatus = new BoxTermsOfServiceUserStatus(api, responseJSON.get("id").asString());
            boxTermsOfServiceUserStatus.getClass();
            Info info = boxTermsOfServiceUserStatus.new Info(responseJSON);
            return info;
        }
    }

    public static List<Info> getInfo(BoxAPIConnection api, String termsOfServiceID) {
        return BoxTermsOfServiceUserStatus.getInfo(api, termsOfServiceID, null);
    }

    public static List<Info> getInfo(BoxAPIConnection api, String termsOfServiceID, String userID) {
        QueryStringBuilder builder = new QueryStringBuilder();
        builder.appendParam("tos_id", termsOfServiceID);
        if (userID != null) {
            builder.appendParam("user_id", userID);
        }
        URL url = ALL_TERMS_OF_SERVICE_USER_STATUSES_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "GET");
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            int totalCount = responseJSON.get("total_count").asInt();
            ArrayList<Info> termsOfServiceUserStatuses = new ArrayList<Info>(totalCount);
            JsonArray entries = responseJSON.get("entries").asArray();
            for (JsonValue value : entries) {
                BoxTermsOfServiceUserStatus termsOfServiceUserStatus;
                JsonObject termsOfServiceUserStatusJSON = value.asObject();
                BoxTermsOfServiceUserStatus boxTermsOfServiceUserStatus = termsOfServiceUserStatus = new BoxTermsOfServiceUserStatus(api, termsOfServiceUserStatusJSON.get("id").asString());
                boxTermsOfServiceUserStatus.getClass();
                Info info = boxTermsOfServiceUserStatus.new Info(termsOfServiceUserStatusJSON);
                termsOfServiceUserStatuses.add(info);
            }
            ArrayList<Info> arrayList = termsOfServiceUserStatuses;
            return arrayList;
        }
    }

    public void updateInfo(Info info) {
        URL url = TERMS_OF_SERVICE_USER_STATUSES_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            info.update(responseJSON);
        }
    }

    public class Info
    extends BoxResource.Info {
        private BoxTermsOfService.Info termsOfService;
        private BoxUser.Info user;
        private String termsOfServiceUserStatusType;
        private Boolean isAccepted;
        private Date createdAt;
        private Date modifiedAt;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxTermsOfServiceUserStatus.this;
        }

        public BoxTermsOfService.Info getTermsOfService() {
            return this.termsOfService;
        }

        public BoxUser.Info getUser() {
            return this.user;
        }

        public Boolean getIsAccepted() {
            return this.isAccepted;
        }

        public void setIsAccepted(Boolean enabled) {
            this.isAccepted = enabled;
            this.addPendingChange("is_accepted", this.isAccepted);
        }

        public String getType() {
            return this.termsOfServiceUserStatusType;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("tos")) {
                    BoxTermsOfService termsOfService;
                    JsonObject tosJSON = value.asObject();
                    String termsOfServiceID = tosJSON.get("id").asString();
                    BoxTermsOfService boxTermsOfService = termsOfService = new BoxTermsOfService(BoxTermsOfServiceUserStatus.this.getAPI(), termsOfServiceID);
                    boxTermsOfService.getClass();
                    this.termsOfService = boxTermsOfService.new BoxTermsOfService.Info(tosJSON);
                } else if (memberName.equals("user")) {
                    BoxUser user;
                    JsonObject userJSON = value.asObject();
                    String userID = userJSON.get("id").asString();
                    BoxUser boxUser = user = new BoxUser(BoxTermsOfServiceUserStatus.this.getAPI(), userID);
                    boxUser.getClass();
                    this.user = boxUser.new BoxUser.Info(userJSON);
                } else if (memberName.equals("is_accepted")) {
                    this.isAccepted = value.asBoolean();
                } else if (memberName.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("modified_at")) {
                    this.modifiedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("type")) {
                    this.termsOfServiceUserStatusType = value.asString();
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }
}

