/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.apache.hc.core5.reactor;

import com.clickhouse.client.internal.org.apache.hc.core5.concurrent.FutureCallback;
import com.clickhouse.client.internal.org.apache.hc.core5.function.Callback;
import com.clickhouse.client.internal.org.apache.hc.core5.function.Decorator;
import com.clickhouse.client.internal.org.apache.hc.core5.io.CloseMode;
import com.clickhouse.client.internal.org.apache.hc.core5.io.Closer;
import com.clickhouse.client.internal.org.apache.hc.core5.io.SocketSupport;
import com.clickhouse.client.internal.org.apache.hc.core5.net.NamedEndpoint;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.AbstractSingleCoreIOReactor;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.ChannelEntry;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.ConnectionInitiator;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.IOReactorConfig;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.IOReactorShutdownException;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.IOReactorStatus;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.IOSession;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.IOSessionImpl;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.IOSessionListener;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.IOSessionRequest;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.InternalChannel;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.InternalConnectChannel;
import com.clickhouse.client.internal.org.apache.hc.core5.reactor.InternalDataChannel;
import com.clickhouse.client.internal.org.apache.hc.core5.util.Args;
import com.clickhouse.client.internal.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

class SingleCoreIOReactor
extends AbstractSingleCoreIOReactor
implements ConnectionInitiator {
    private static final int MAX_CHANNEL_REQUESTS = 10000;
    private final IOEventHandlerFactory eventHandlerFactory;
    private final IOReactorConfig reactorConfig;
    private final Decorator<IOSession> ioSessionDecorator;
    private final IOSessionListener sessionListener;
    private final Callback<IOSession> sessionShutdownCallback;
    private final Queue<InternalDataChannel> closedSessions;
    private final Queue<ChannelEntry> channelQueue;
    private final Queue<IOSessionRequest> requestQueue;
    private final AtomicBoolean shutdownInitiated;
    private final long selectTimeoutMillis;
    private volatile long lastTimeoutCheckMillis;

    SingleCoreIOReactor(Callback<Exception> exceptionCallback, IOEventHandlerFactory eventHandlerFactory, IOReactorConfig reactorConfig, Decorator<IOSession> ioSessionDecorator, IOSessionListener sessionListener, Callback<IOSession> sessionShutdownCallback) {
        super(exceptionCallback);
        this.eventHandlerFactory = Args.notNull(eventHandlerFactory, "Event handler factory");
        this.reactorConfig = Args.notNull(reactorConfig, "I/O reactor config");
        this.ioSessionDecorator = ioSessionDecorator;
        this.sessionListener = sessionListener;
        this.sessionShutdownCallback = sessionShutdownCallback;
        this.shutdownInitiated = new AtomicBoolean();
        this.closedSessions = new ConcurrentLinkedQueue<InternalDataChannel>();
        this.channelQueue = new ConcurrentLinkedQueue<ChannelEntry>();
        this.requestQueue = new ConcurrentLinkedQueue<IOSessionRequest>();
        this.selectTimeoutMillis = this.reactorConfig.getSelectInterval().toMilliseconds();
    }

    void enqueueChannel(ChannelEntry entry) throws IOReactorShutdownException {
        if (this.getStatus().compareTo(IOReactorStatus.ACTIVE) > 0) {
            throw new IOReactorShutdownException("I/O reactor has been shut down");
        }
        this.channelQueue.add(entry);
        this.selector.wakeup();
    }

    @Override
    void doTerminate() {
        this.closePendingChannels();
        this.closePendingConnectionRequests();
        this.processClosedSessions();
    }

    @Override
    void doExecute() throws IOException {
        while (!Thread.currentThread().isInterrupted()) {
            int readyCount = this.selector.select(this.selectTimeoutMillis);
            if (this.getStatus().compareTo(IOReactorStatus.SHUTTING_DOWN) >= 0) {
                if (this.shutdownInitiated.compareAndSet(false, true)) {
                    this.initiateSessionShutdown();
                }
                this.closePendingChannels();
            }
            if (this.getStatus() == IOReactorStatus.SHUT_DOWN) break;
            if (readyCount > 0) {
                this.processEvents(this.selector.selectedKeys());
            }
            this.validateActiveChannels();
            this.processClosedSessions();
            if (this.getStatus() == IOReactorStatus.ACTIVE) {
                this.processPendingChannels();
                this.processPendingConnectionRequests();
            }
            if ((this.getStatus() != IOReactorStatus.SHUTTING_DOWN || !this.selector.keys().isEmpty()) && this.getStatus() != IOReactorStatus.SHUT_DOWN) continue;
            break;
        }
    }

    private void initiateSessionShutdown() {
        if (this.sessionShutdownCallback != null) {
            Set<SelectionKey> keys = this.selector.keys();
            for (SelectionKey key : keys) {
                InternalChannel channel = (InternalChannel)key.attachment();
                if (!(channel instanceof InternalDataChannel)) continue;
                this.sessionShutdownCallback.execute((InternalDataChannel)channel);
            }
        }
    }

    private void validateActiveChannels() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastTimeoutCheckMillis >= this.selectTimeoutMillis) {
            this.lastTimeoutCheckMillis = currentTimeMillis;
            for (SelectionKey key : this.selector.keys()) {
                this.checkTimeout(key, currentTimeMillis);
            }
        }
    }

    private void processEvents(Set<SelectionKey> selectedKeys) {
        for (SelectionKey key : selectedKeys) {
            InternalChannel channel = (InternalChannel)key.attachment();
            if (channel == null) continue;
            try {
                channel.handleIOEvent(key.readyOps());
            }
            catch (CancelledKeyException ex) {
                channel.close(CloseMode.GRACEFUL);
            }
        }
        selectedKeys.clear();
    }

    private void processPendingChannels() throws IOException {
        ChannelEntry entry;
        for (int i = 0; i < 10000 && (entry = this.channelQueue.poll()) != null; ++i) {
            SelectionKey key;
            SocketChannel socketChannel = entry.channel;
            Object attachment = entry.attachment;
            try {
                this.prepareSocket(socketChannel);
                socketChannel.configureBlocking(false);
            }
            catch (IOException ex) {
                this.logException(ex);
                try {
                    socketChannel.close();
                }
                catch (IOException ex2) {
                    this.logException(ex2);
                }
                throw ex;
            }
            try {
                key = socketChannel.register(this.selector, 1);
            }
            catch (ClosedChannelException ex) {
                return;
            }
            IOSessionImpl ioSession = new IOSessionImpl("a", key, socketChannel);
            InternalDataChannel dataChannel = new InternalDataChannel(ioSession, null, this.ioSessionDecorator, this.sessionListener, this.closedSessions);
            dataChannel.setSocketTimeout(this.reactorConfig.getSoTimeout());
            dataChannel.upgrade(this.eventHandlerFactory.createHandler(dataChannel, attachment));
            key.attach(dataChannel);
            dataChannel.handleIOEvent(8);
        }
    }

    private void processClosedSessions() {
        InternalDataChannel dataChannel;
        while ((dataChannel = this.closedSessions.poll()) != null) {
            try {
                dataChannel.disconnected();
            }
            catch (CancelledKeyException cancelledKeyException) {}
        }
    }

    private void checkTimeout(SelectionKey key, long nowMillis) {
        InternalChannel channel = (InternalChannel)key.attachment();
        if (channel != null) {
            channel.checkTimeout(nowMillis);
        }
    }

    @Override
    public Future<IOSession> connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, Timeout timeout, Object attachment, FutureCallback<IOSession> callback) throws IOReactorShutdownException {
        Args.notNull(remoteEndpoint, "Remote endpoint");
        IOSessionRequest sessionRequest = new IOSessionRequest(remoteEndpoint, remoteAddress != null ? remoteAddress : new InetSocketAddress(remoteEndpoint.getHostName(), remoteEndpoint.getPort()), localAddress, timeout, attachment, callback);
        this.requestQueue.add(sessionRequest);
        this.selector.wakeup();
        return sessionRequest;
    }

    private void prepareSocket(SocketChannel socketChannel) throws IOException {
        int linger;
        Socket socket = socketChannel.socket();
        socket.setTcpNoDelay(this.reactorConfig.isTcpNoDelay());
        socket.setKeepAlive(this.reactorConfig.isSoKeepAlive());
        if (this.reactorConfig.getSndBufSize() > 0) {
            socket.setSendBufferSize(this.reactorConfig.getSndBufSize());
        }
        if (this.reactorConfig.getRcvBufSize() > 0) {
            socket.setReceiveBufferSize(this.reactorConfig.getRcvBufSize());
        }
        if (this.reactorConfig.getTrafficClass() > 0) {
            socket.setTrafficClass(this.reactorConfig.getTrafficClass());
        }
        if ((linger = this.reactorConfig.getSoLinger().toSecondsIntBound()) >= 0) {
            socket.setSoLinger(true, linger);
        }
        if (this.reactorConfig.getTcpKeepIdle() > 0) {
            this.setExtendedSocketOption(socketChannel, "TCP_KEEPIDLE", this.reactorConfig.getTcpKeepIdle());
        }
        if (this.reactorConfig.getTcpKeepInterval() > 0) {
            this.setExtendedSocketOption(socketChannel, "TCP_KEEPINTERVAL", this.reactorConfig.getTcpKeepInterval());
        }
        if (this.reactorConfig.getTcpKeepInterval() > 0) {
            this.setExtendedSocketOption(socketChannel, "TCP_KEEPCOUNT", this.reactorConfig.getTcpKeepCount());
        }
    }

    <T> void setExtendedSocketOption(SocketChannel socketChannel, String optionName, T value) throws IOException {
        SocketOption socketOption = SocketSupport.getExtendedSocketOptionOrNull(optionName);
        if (socketOption == null) {
            throw new UnsupportedOperationException(optionName + " is not supported in the current jdk");
        }
        socketChannel.setOption(socketOption, (Object)value);
    }

    private void validateAddress(SocketAddress address) throws UnknownHostException {
        InetSocketAddress endpoint;
        if (address instanceof InetSocketAddress && (endpoint = (InetSocketAddress)address).isUnresolved()) {
            throw new UnknownHostException(endpoint.getHostName());
        }
    }

    private void processPendingConnectionRequests() {
        IOSessionRequest sessionRequest;
        for (int i = 0; i < 10000 && (sessionRequest = this.requestQueue.poll()) != null; ++i) {
            SocketChannel socketChannel;
            if (sessionRequest.isCancelled()) continue;
            try {
                socketChannel = SocketChannel.open();
            }
            catch (IOException ex) {
                sessionRequest.failed(ex);
                return;
            }
            try {
                this.processConnectionRequest(socketChannel, sessionRequest);
                continue;
            }
            catch (IOException | RuntimeException ex) {
                Closer.closeQuietly(socketChannel);
                sessionRequest.failed(ex);
            }
        }
    }

    private void processConnectionRequest(SocketChannel socketChannel, IOSessionRequest sessionRequest) throws IOException {
        SocketAddress socksProxyAddress;
        socketChannel.configureBlocking(false);
        this.prepareSocket(socketChannel);
        this.validateAddress(sessionRequest.localAddress);
        if (sessionRequest.localAddress != null) {
            Socket sock = socketChannel.socket();
            sock.setReuseAddress(this.reactorConfig.isSoReuseAddress());
            sock.bind(sessionRequest.localAddress);
        }
        SocketAddress remoteAddress = (socksProxyAddress = this.reactorConfig.getSocksProxyAddress()) != null ? socksProxyAddress : sessionRequest.remoteAddress;
        this.validateAddress(remoteAddress);
        boolean connected = socketChannel.connect(remoteAddress);
        SelectionKey key = socketChannel.register(this.selector, 9);
        IOSessionImpl ioSession = new IOSessionImpl("c", key, socketChannel);
        InternalDataChannel dataChannel = new InternalDataChannel(ioSession, sessionRequest.remoteEndpoint, this.ioSessionDecorator, this.sessionListener, this.closedSessions);
        dataChannel.setSocketTimeout(this.reactorConfig.getSoTimeout());
        InternalConnectChannel connectChannel = new InternalConnectChannel(key, socketChannel, sessionRequest, dataChannel, this.eventHandlerFactory, this.reactorConfig);
        if (connected) {
            connectChannel.handleIOEvent(8);
        } else {
            key.attach(connectChannel);
            sessionRequest.assign(connectChannel);
        }
    }

    private void closePendingChannels() {
        ChannelEntry entry;
        while ((entry = this.channelQueue.poll()) != null) {
            SocketChannel socketChannel = entry.channel;
            try {
                socketChannel.close();
            }
            catch (IOException ex) {
                this.logException(ex);
            }
        }
    }

    private void closePendingConnectionRequests() {
        IOSessionRequest sessionRequest;
        while ((sessionRequest = this.requestQueue.poll()) != null) {
            sessionRequest.cancel();
        }
    }
}

