/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.validation;

import com.daml.api.util.DurationConversion$;
import com.daml.api.util.TimestampConversion$;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.ErrorCodesVersionSwitcher;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.domain$;
import com.daml.ledger.api.v1.commands.Command;
import com.daml.ledger.api.v1.value.Identifier;
import com.daml.ledger.api.v1.value.RecordField;
import com.daml.ledger.api.v1.value.Value;
import com.daml.ledger.api.validation.CommandsValidator$;
import com.daml.ledger.api.validation.ValueValidator;
import com.daml.lf.command.ApiCommand;
import com.daml.lf.command.Commands;
import com.daml.lf.command.CreateAndExerciseCommand;
import com.daml.lf.command.CreateCommand;
import com.daml.lf.command.ExerciseByKeyCommand;
import com.daml.lf.command.ExerciseCommand;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.ImmArray$;
import com.daml.lf.data.Time;
import com.daml.lf.value.Value;
import com.daml.platform.server.api.validation.ErrorFactories;
import com.daml.platform.server.api.validation.ErrorFactories$;
import com.daml.platform.server.api.validation.FieldValidations;
import com.daml.platform.server.api.validation.FieldValidations$;
import com.google.protobuf.duration.Duration;
import com.google.protobuf.timestamp.Timestamp;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scalaz.syntax.TagOps$;

@ScalaSignature(bytes="\u0006\u0001\r}a\u0001B\u00181\u0005mB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t+\u0002\u0011\t\u0011)A\u0005-\")A\f\u0001C\u0001;\"9!\r\u0001b\u0001\n\u0013\u0019\u0007B\u00028\u0001A\u0003%A\rC\u0004p\u0001\t\u0007I\u0011\u00029\t\rQ\u0004\u0001\u0015!\u0003r\u0011\u001d)\bA1A\u0005\nYDaA\u001f\u0001!\u0002\u00139\b\"B>\u0001\t\u0003a\bbBA6\u0001\u0011%\u0011Q\u000e\u0005\b\u0003w\u0002A\u0011BA?\u0011\u001d\t\t\f\u0001C\u0005\u0003gCq!!3\u0001\t\u0013\tYmB\u0004\u0002ZBB\t!a7\u0007\r=\u0002\u0004\u0012AAo\u0011\u0019a\u0006\u0003\"\u0001\u0002`\u001a1\u0011\u0011\u001d\tA\u0003GD!\"a=\u0013\u0005+\u0007I\u0011AA{\u0011)\u0011iB\u0005B\tB\u0003%\u0011q\u001f\u0005\u000b\u0005?\u0011\"Q3A\u0005\u0002\u0005U\bB\u0003B\u0011%\tE\t\u0015!\u0003\u0002x\"1AL\u0005C\u0001\u0005GA\u0011B!\f\u0013\u0003\u0003%\tAa\f\t\u0013\t}\"#%A\u0005\u0002\t\u0005\u0003\"\u0003B.%E\u0005I\u0011\u0001B/\u0011%\u0011\tGEA\u0001\n\u0003\u0012\u0019\u0007C\u0005\u0003rI\t\t\u0011\"\u0001\u0003t!I!1\u0010\n\u0002\u0002\u0013\u0005!Q\u0010\u0005\n\u0005\u0007\u0013\u0012\u0011!C!\u0005\u000bC\u0011Ba$\u0013\u0003\u0003%\tA!%\t\u0013\tm%#!A\u0005B\tu\u0005\"\u0003BP%\u0005\u0005I\u0011\tBQ\u0011%\u0011\u0019KEA\u0001\n\u0003\u0012)kB\u0005\u0003*B\t\t\u0011#\u0001\u0003,\u001aI\u0011\u0011\u001d\t\u0002\u0002#\u0005!Q\u0016\u0005\u00079\u0012\"\tAa,\t\u0013\t}E%!A\u0005F\t\u0005\u0006\"\u0003BYI\u0005\u0005I\u0011\u0011BZ\u0011%\u0011\u0019\rJA\u0001\n\u0003\u0013)\rC\u0005\u0003^\u0012\n\t\u0011\"\u0003\u0003`\"9!q\u001d\t\u0005\u0002\t%\bb\u0002Bt!\u0011\u0005!Q\u001f\u0005\b\u0005s\u0004B\u0011\u0001B~\u0011%\u0019\t\u0001\u0005b\u0001\n\u0003\u0019\u0019\u0001\u0003\u0005\u0004\u0006A\u0001\u000b\u0011\u0002Bv\u0005E\u0019u.\\7b]\u0012\u001ch+\u00197jI\u0006$xN\u001d\u0006\u0003cI\n!B^1mS\u0012\fG/[8o\u0015\t\u0019D'A\u0002ba&T!!\u000e\u001c\u0002\r1,GmZ3s\u0015\t9\u0004(\u0001\u0003eC6d'\"A\u001d\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001a\u0004CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$AB!osJ+g-\u0001\u0005mK\u0012<WM]%e!\t!%K\u0004\u0002F!:\u0011ai\u0014\b\u0003\u000f:s!\u0001S'\u000f\u0005%cU\"\u0001&\u000b\u0005-S\u0014A\u0002\u001fs_>$h(C\u0001:\u0013\t9\u0004(\u0003\u00026m%\u00111\u0007N\u0005\u0003#J\na\u0001Z8nC&t\u0017BA*U\u0005!aU\rZ4fe&#'BA)3\u0003e)'O]8s\u0007>$Wm\u001d,feNLwN\\*xSR\u001c\u0007.\u001a:\u0011\u0005]SV\"\u0001-\u000b\u0005e3\u0014!B3se>\u0014\u0018BA.Y\u0005e)%O]8s\u0007>$Wm\u001d,feNLwN\\*xSR\u001c\u0007.\u001a:\u0002\rqJg.\u001b;?)\rq\u0006-\u0019\t\u0003?\u0002i\u0011\u0001\r\u0005\u0006\u0005\u000e\u0001\ra\u0011\u0005\u0006+\u000e\u0001\rAV\u0001\u000fKJ\u0014xN\u001d$bGR|'/[3t+\u0005!\u0007CA3m\u001b\u00051'BA\u0019h\u0015\t\u0019\u0004N\u0003\u0002jU\u000611/\u001a:wKJT!a\u001b\u001c\u0002\u0011Ad\u0017\r\u001e4pe6L!!\u001c4\u0003\u001d\u0015\u0013(o\u001c:GC\u000e$xN]5fg\u0006yQM\u001d:pe\u001a\u000b7\r^8sS\u0016\u001c\b%\u0001\tgS\u0016dGMV1mS\u0012\fG/[8ogV\t\u0011\u000f\u0005\u0002fe&\u00111O\u001a\u0002\u0011\r&,G\u000e\u001a,bY&$\u0017\r^5p]N\f\u0011CZ5fY\u00124\u0016\r\\5eCRLwN\\:!\u000391\u0018\r\\;f-\u0006d\u0017\u000eZ1u_J,\u0012a\u001e\t\u0003?bL!!\u001f\u0019\u0003\u001dY\u000bG.^3WC2LG-\u0019;pe\u0006ya/\u00197vKZ\u000bG.\u001b3bi>\u0014\b%\u0001\twC2LG-\u0019;f\u0007>lW.\u00198egRIQ0a\r\u0002D\u0005]\u00131\f\u000b\u0004}\u0006%\u0002cB@\u0002\n\u0005=\u0011q\u0004\b\u0005\u0003\u0003\t)AD\u0002J\u0003\u0007I\u0011aP\u0005\u0004\u0003\u000fq\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\tiA\u0001\u0004FSRDWM\u001d\u0006\u0004\u0003\u000fq\u0004\u0003BA\t\u00037i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u0005OJ\u00048M\u0003\u0002\u0002\u001a\u0005\u0011\u0011n\\\u0005\u0005\u0003;\t\u0019B\u0001\fTi\u0006$Xo\u001d*v]RLW.Z#yG\u0016\u0004H/[8o!\u0011\t\t#!\n\u000f\u0007\u0005\r\u0002+D\u00013\u0013\r\t9\u0003\u0016\u0002\t\u0007>lW.\u00198eg\"9\u00111\u0006\u0006A\u0004\u00055\u0012!G2p]R,\u0007\u0010^;bY&TX\rZ#se>\u0014Hj\\4hKJ\u00042aVA\u0018\u0013\r\t\t\u0004\u0017\u0002\u001a\u0007>tG/\u001a=uk\u0006d\u0017N_3e\u000bJ\u0014xN\u001d'pO\u001e,'\u000fC\u0004\u00026)\u0001\r!a\u000e\u0002\u0011\r|W.\\1oIN\u0004B!!\u000f\u0002B5\u0011\u00111\b\u0006\u0005\u0003k\tiDC\u0002\u0002@I\n!A^\u0019\n\t\u0005\u001d\u00121\b\u0005\b\u0003\u000bR\u0001\u0019AA$\u0003E\u0019WO\u001d:f]RdU\rZ4feRKW.\u001a\t\u0005\u0003\u0013\n\u0019&\u0004\u0002\u0002L)!\u0011QJA(\u0003\u0011!\u0018.\\3\u000b\u0005\u0005E\u0013\u0001\u00026bm\u0006LA!!\u0016\u0002L\t9\u0011J\\:uC:$\bbBA-\u0015\u0001\u0007\u0011qI\u0001\u000fGV\u0014(/\u001a8u+R\u001cG+[7f\u0011\u001d\tiF\u0003a\u0001\u0003?\nA#\\1y\t\u0016$W\u000f\u001d7jG\u0006$\u0018n\u001c8US6,\u0007#B\u001f\u0002b\u0005\u0015\u0014bAA2}\t1q\n\u001d;j_:\u0004B!!\u0013\u0002h%!\u0011\u0011NA&\u0005!!UO]1uS>t\u0017A\u0005<bY&$\u0017\r^3MK\u0012<WM\u001d+j[\u0016$b!a\u001c\u0002v\u0005eD\u0003BA9\u0003g\u0002ra`A\u0005\u0003\u001f\t9\u0005C\u0004\u0002,-\u0001\u001d!!\f\t\u000f\u0005]4\u00021\u0001\u0002H\u0005Y1-\u001e:sK:$H+[7f\u0011\u001d\t)d\u0003a\u0001\u0003o\tQC^1mS\u0012\fG/Z%o]\u0016\u00148i\\7nC:$7\u000f\u0006\u0003\u0002\u0000\u0005\u0015F\u0003BAA\u0003G\u0003ra`A\u0005\u0003\u001f\t\u0019\t\u0005\u0004\u0002\u0006\u0006=\u00151S\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u001bs\u0014AC2pY2,7\r^5p]&!\u0011\u0011SAD\u0005\r\u0019V-\u001d\t\u0005\u0003+\u000by*\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003\u001d\u0019w.\\7b]\u0012T1!!(7\u0003\tag-\u0003\u0003\u0002\"\u0006]%AC!qS\u000e{W.\\1oI\"9\u00111\u0006\u0007A\u0004\u00055\u0002bBA\u001b\u0019\u0001\u0007\u0011q\u0015\t\u0006\u007f\u0006%\u00161V\u0005\u0005\u0003#\u000bi\u0001\u0005\u0003\u0002:\u00055\u0016\u0002BAX\u0003w\u0011qaQ8n[\u0006tG-\u0001\u000bwC2LG-\u0019;f\u0013:tWM]\"p[6\fg\u000e\u001a\u000b\u0005\u0003k\u000bY\f\u0006\u0003\u00028\u0006e\u0006cB@\u0002\n\u0005=\u00111\u0013\u0005\b\u0003Wi\u00019AA\u0017\u0011\u001d\tI*\u0004a\u0001\u0003{\u0003B!a0\u0002F:!\u0011\u0011HAa\u0013\u0011\t\u0019-a\u000f\u0002\u000f\r{W.\\1oI&!\u0011qVAd\u0015\u0011\t\u0019-a\u000f\u0002%Y\fG.\u001b3bi\u0016\u001cVOY7jiR,'o\u001d\u000b\u0005\u0003\u001b\u001ci\u0002\u0006\u0003\u0002P\u000em\u0001cB@\u0002\n\u0005=\u0011\u0011\u001b\t\u0006\u0003'\u00142q\u0001\b\u0004\u0003+|abA#\u0002X&\u0011\u0011GM\u0001\u0012\u0007>lW.\u00198egZ\u000bG.\u001b3bi>\u0014\bCA0\u0011'\t\u0001B\b\u0006\u0002\u0002\\\nQ1+\u001e2nSR$XM]:\u0016\t\u0005\u0015(1B\n\u0007%q\n9/!<\u0011\u0007u\nI/C\u0002\u0002lz\u0012q\u0001\u0015:pIV\u001cG\u000fE\u0002>\u0003_L1!!=?\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\t7\r^!t+\t\t9\u0010\u0005\u0004\u0002z\n\u0005!q\u0001\b\u0005\u0003w\fi\u0010\u0005\u0002J}%\u0019\u0011q  \u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\u0019A!\u0002\u0003\u0007M+GOC\u0002\u0002\u0000z\u0002BA!\u0003\u0003\f1\u0001Aa\u0002B\u0007%\t\u0007!q\u0002\u0002\u0002)F!!\u0011\u0003B\f!\ri$1C\u0005\u0004\u0005+q$a\u0002(pi\"Lgn\u001a\t\u0004{\te\u0011b\u0001B\u000e}\t\u0019\u0011I\\=\u0002\r\u0005\u001cG/Q:!\u0003\u0019\u0011X-\u00193Bg\u00069!/Z1e\u0003N\u0004CC\u0002B\u0013\u0005S\u0011Y\u0003E\u0003\u0003(I\u00119!D\u0001\u0011\u0011\u001d\t\u0019p\u0006a\u0001\u0003oDqAa\b\u0018\u0001\u0004\t90\u0001\u0003d_BLX\u0003\u0002B\u0019\u0005o!bAa\r\u0003:\tu\u0002#\u0002B\u0014%\tU\u0002\u0003\u0002B\u0005\u0005o!qA!\u0004\u0019\u0005\u0004\u0011y\u0001C\u0005\u0002tb\u0001\n\u00111\u0001\u0003<A1\u0011\u0011 B\u0001\u0005kA\u0011Ba\b\u0019!\u0003\u0005\rAa\u000f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!!1\tB-+\t\u0011)E\u000b\u0003\u0002x\n\u001d3F\u0001B%!\u0011\u0011YE!\u0016\u000e\u0005\t5#\u0002\u0002B(\u0005#\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tMc(\u0001\u0006b]:|G/\u0019;j_:LAAa\u0016\u0003N\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\t5\u0011D1\u0001\u0003\u0010\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002B\"\u0005?\"qA!\u0004\u001b\u0005\u0004\u0011y!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005K\u0002BAa\u001a\u0003n5\u0011!\u0011\u000e\u0006\u0005\u0005W\ny%\u0001\u0003mC:<\u0017\u0002\u0002B8\u0005S\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B;!\ri$qO\u0005\u0004\u0005sr$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\f\u0005\u007fB\u0011B!!\u001e\u0003\u0003\u0005\rA!\u001e\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\t\u0005\u0004\u0003\n\n-%qC\u0007\u0003\u0003\u0017KAA!$\u0002\f\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\u0019J!'\u0011\u0007u\u0012)*C\u0002\u0003\u0018z\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0003\u0002~\t\t\u00111\u0001\u0003\u0018\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003v\u0005AAo\\*ue&tw\r\u0006\u0002\u0003f\u00051Q-];bYN$BAa%\u0003(\"I!\u0011\u0011\u0012\u0002\u0002\u0003\u0007!qC\u0001\u000b'V\u0014W.\u001b;uKJ\u001c\bc\u0001B\u0014IM!A\u0005PAw)\t\u0011Y+A\u0003baBd\u00170\u0006\u0003\u00036\nmFC\u0002B\\\u0005{\u0013\t\rE\u0003\u0003(I\u0011I\f\u0005\u0003\u0003\n\tmFa\u0002B\u0007O\t\u0007!q\u0002\u0005\b\u0003g<\u0003\u0019\u0001B`!\u0019\tIP!\u0001\u0003:\"9!qD\u0014A\u0002\t}\u0016aB;oCB\u0004H._\u000b\u0005\u0005\u000f\u0014)\u000e\u0006\u0003\u0003J\n]\u0007#B\u001f\u0002b\t-\u0007cB\u001f\u0003N\nE'\u0011[\u0005\u0004\u0005\u001ft$A\u0002+va2,'\u0007\u0005\u0004\u0002z\n\u0005!1\u001b\t\u0005\u0005\u0013\u0011)\u000eB\u0004\u0003\u000e!\u0012\rAa\u0004\t\u0013\te\u0007&!AA\u0002\tm\u0017a\u0001=%aA)!q\u0005\n\u0003T\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u000f\u0005\u0003\u0003h\t\r\u0018\u0002\u0002Bs\u0005S\u0012aa\u00142kK\u000e$\u0018aE3gM\u0016\u001cG/\u001b<f'V\u0014W.\u001b;uKJ\u001cH\u0003\u0002Bv\u0005c\u0004RAa\n\u0013\u0005[\u0004B!!?\u0003p&!!q\u000eB\u0003\u0011\u001d\t)D\u000ba\u0001\u0005g\u0004R!PA1\u0003o!BAa;\u0003x\"9\u0011QG\u0016A\u0002\u0005]\u0012AD3gM\u0016\u001cG/\u001b<f\u0003\u000e$\u0018i\u001d\u000b\u0005\u0005{\u0014y\u0010\u0005\u0004\u0002z\n\u0005!Q\u001e\u0005\b\u0003ka\u0003\u0019AA\u001c\u00031qwnU;c[&$H/\u001a:t+\t\u0011Y/A\u0007o_N+(-\\5ui\u0016\u00148\u000f\t\t\u0005\u0007\u0013\u0019)B\u0004\u0003\u0004\f\rEQBAB\u0007\u0015\u0011\u0019y!a'\u0002\t\u0011\fG/Y\u0005\u0005\u0007'\u0019i!A\u0002SK\u001aLAaa\u0006\u0004\u001a\t)\u0001+\u0019:us*!11CB\u0007\u0011\u001d\tYC\u0004a\u0002\u0003[Aq!!\u000e\u000f\u0001\u0004\t9\u0004")
public final class CommandsValidator {
    private final Object ledgerId;
    private final ErrorFactories errorFactories;
    private final FieldValidations fieldValidations;
    private final ValueValidator valueValidator;

    public static Submitters<String> noSubmitters() {
        return CommandsValidator$.MODULE$.noSubmitters();
    }

    public static Set<String> effectiveActAs(com.daml.ledger.api.v1.commands.Commands commands) {
        return CommandsValidator$.MODULE$.effectiveActAs(commands);
    }

    public static Submitters<String> effectiveSubmitters(com.daml.ledger.api.v1.commands.Commands commands) {
        return CommandsValidator$.MODULE$.effectiveSubmitters(commands);
    }

    public static Submitters<String> effectiveSubmitters(Option<com.daml.ledger.api.v1.commands.Commands> option) {
        return CommandsValidator$.MODULE$.effectiveSubmitters(option);
    }

    private ErrorFactories errorFactories() {
        return this.errorFactories;
    }

    private FieldValidations fieldValidations() {
        return this.fieldValidations;
    }

    private ValueValidator valueValidator() {
        return this.valueValidator;
    }

    public Either<StatusRuntimeException, domain.Commands> validateCommands(com.daml.ledger.api.v1.commands.Commands commands, Instant currentLedgerTime, Instant currentUtcTime, Option<java.time.Duration> maxDeduplicationTime, ContextualizedErrorLogger contextualizedErrorLogger) {
        return this.fieldValidations().requireLedgerString(commands.ledgerId(), "ledger_id", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)cmdLegerId -> this.fieldValidations().matchLedgerId($this.ledgerId, domain$.MODULE$.LedgerId().apply(cmdLegerId), contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)ledgerId -> (commands.workflowId().isEmpty() ? package$.MODULE$.Right().apply((Object)None$.MODULE$) : this.fieldValidations().requireLedgerString(commands.workflowId(), contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)x -> new Some(domain$.MODULE$.WorkflowId().apply(x)))).flatMap((Function1 & Serializable & scala.Serializable)workflowId -> this.fieldValidations().requireLedgerString(commands.applicationId(), "application_id", contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)x$1 -> domain$.MODULE$.ApplicationId().apply(x$1)).flatMap((Function1 & Serializable & scala.Serializable)appId -> this.fieldValidations().requireLedgerString(commands.commandId(), "command_id", contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)x$2 -> domain$.MODULE$.CommandId().apply(x$2)).flatMap((Function1 & Serializable & scala.Serializable)commandId -> this.fieldValidations().validateSubmissionId(commands.submissionId(), contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)submissionId -> this.validateSubmitters(commands, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)submitters -> this.fieldValidations().requireNonEmpty(commands.commands(), "commands", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)commandz -> this.validateInnerCommands((Seq<Command>)commandz, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)validatedCommands -> this.validateLedgerTime(currentLedgerTime, commands, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)ledgerEffectiveTime -> Time.Timestamp$.MODULE$.fromInstant(ledgerEffectiveTime).left().map((Function1 & Serializable & scala.Serializable)x$3 -> this.errorFactories().invalidArgument((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), new StringBuilder(58).append("Can not represent command ledger time ").append(ledgerEffectiveTime).append(" as a Daml timestamp").toString(), contextualizedErrorLogger)).flatMap((Function1 & Serializable & scala.Serializable)ledgerEffectiveTimestamp -> this.fieldValidations().validateDeduplicationPeriod(commands.deduplicationPeriod(), maxDeduplicationTime, "deduplication_period", contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)deduplicationPeriod -> new domain.Commands(ledgerId, workflowId, appId, commandId, submissionId, submitters.actAs(), submitters.readAs(), Time.Timestamp$.MODULE$.assertFromInstant(currentUtcTime), deduplicationPeriod, new Commands((ImmArray)validatedCommands.to(ImmArray$.MODULE$.IS$u0020companion$u0020to$u0020CBF(ImmArray$.MODULE$)), ledgerEffectiveTimestamp, (String)workflowId.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$4 -> (String)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(x$4)))))))))))))))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<StatusRuntimeException, Instant> validateLedgerTime(Instant currentTime, com.daml.ledger.api.v1.commands.Commands commands, ContextualizedErrorLogger contextualizedErrorLogger) {
        Option minLedgerTimeRel;
        Option minLedgerTimeAbs = commands.minLedgerTimeAbs();
        Tuple2 tuple2 = new Tuple2((Object)minLedgerTimeAbs, (Object)(minLedgerTimeRel = commands.minLedgerTimeRel()));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                return package$.MODULE$.Right().apply((Object)currentTime);
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Timestamp minAbs = (Timestamp)some.value();
                if (None$.MODULE$.equals(option3)) {
                    return package$.MODULE$.Right().apply(Ordering.Implicits$.MODULE$.infixOrderingOps((Object)currentTime, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).max((Object)TimestampConversion$.MODULE$.toInstant(minAbs)));
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option4 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                Some some = (Some)option4;
                Duration minRel = (Duration)some.value();
                return package$.MODULE$.Right().apply((Object)currentTime.plus(DurationConversion$.MODULE$.fromProto(minRel)));
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option = (Option)tuple2._1();
        Option option5 = (Option)tuple2._2();
        if (!(option instanceof Some)) throw new MatchError((Object)tuple2);
        if (!(option5 instanceof Some)) throw new MatchError((Object)tuple2);
        return package$.MODULE$.Left().apply((Object)this.errorFactories().invalidArgument((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), "min_ledger_time_abs cannot be specified at the same time as min_ledger_time_rel", contextualizedErrorLogger));
    }

    private Either<StatusRuntimeException, scala.collection.immutable.Seq<ApiCommand>> validateInnerCommands(Seq<Command> commands, ContextualizedErrorLogger contextualizedErrorLogger) {
        return (Either)commands.foldLeft((Object)package$.MODULE$.Right().apply((Object)package$.MODULE$.Vector().empty()), (Function2 & Serializable & scala.Serializable)(commandz, command) -> commandz.flatMap((Function1 & Serializable & scala.Serializable)validatedInnerCommands -> this.validateInnerCommand(command.command(), contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)validatedInnerCommand -> (Vector)validatedInnerCommands.$colon$plus(validatedInnerCommand, Vector$.MODULE$.canBuildFrom()))));
    }

    private Either<StatusRuntimeException, ApiCommand> validateInnerCommand(Command.Command command, ContextualizedErrorLogger contextualizedErrorLogger) {
        Either either;
        Command.Command command2 = command;
        if (command2 instanceof Command.Command.Create) {
            Command.Command.Create create = (Command.Command.Create)command2;
            either = this.fieldValidations().requirePresence(create.value().templateId(), "template_id", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)templateId -> this.fieldValidations().validateIdentifier((Identifier)templateId, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)validatedTemplateId -> this.fieldValidations().requirePresence(create.value().createArguments(), "create_arguments", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)createArguments -> this.valueValidator().validateOptionalIdentifier((Option<Identifier>)createArguments.recordId(), contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)recordId -> this.valueValidator().validateRecordFields((Seq<RecordField>)createArguments.fields(), contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)validatedRecordField -> new CreateCommand(validatedTemplateId, (com.daml.lf.value.Value)new Value.ValueRecord(recordId, validatedRecordField)))))));
        } else if (command2 instanceof Command.Command.Exercise) {
            Command.Command.Exercise exercise = (Command.Command.Exercise)command2;
            either = this.fieldValidations().requirePresence(exercise.value().templateId(), "template_id", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)templateId -> this.fieldValidations().validateIdentifier((Identifier)templateId, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)validatedTemplateId -> this.fieldValidations().requireContractId(exercise.value().contractId(), "contract_id", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)contractId -> this.fieldValidations().requireName(exercise.value().choice(), "choice", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)choice -> this.fieldValidations().requirePresence(exercise.value().choiceArgument(), "value", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)value -> this.valueValidator().validateValue((Value)value, contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)validatedValue -> new ExerciseCommand(validatedTemplateId, contractId, choice, validatedValue)))))));
        } else if (command2 instanceof Command.Command.ExerciseByKey) {
            Command.Command.ExerciseByKey exerciseByKey = (Command.Command.ExerciseByKey)command2;
            either = this.fieldValidations().requirePresence(exerciseByKey.value().templateId(), "template_id", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)templateId -> this.fieldValidations().validateIdentifier((Identifier)templateId, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)validatedTemplateId -> this.fieldValidations().requirePresence(exerciseByKey.value().contractKey(), "contract_key", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)contractKey -> this.valueValidator().validateValue((Value)contractKey, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)validatedContractKey -> this.fieldValidations().requireName(exerciseByKey.value().choice(), "choice", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)choice -> this.fieldValidations().requirePresence(exerciseByKey.value().choiceArgument(), "value", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)value -> this.valueValidator().validateValue((Value)value, contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)validatedValue -> new ExerciseByKeyCommand(validatedTemplateId, validatedContractKey, choice, validatedValue))))))));
        } else if (command2 instanceof Command.Command.CreateAndExercise) {
            Command.Command.CreateAndExercise createAndExercise = (Command.Command.CreateAndExercise)command2;
            either = this.fieldValidations().requirePresence(createAndExercise.value().templateId(), "template_id", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)templateId -> this.fieldValidations().validateIdentifier((Identifier)templateId, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)validatedTemplateId -> this.fieldValidations().requirePresence(createAndExercise.value().createArguments(), "create_arguments", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)createArguments -> this.valueValidator().validateOptionalIdentifier((Option<Identifier>)createArguments.recordId(), contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)recordId -> this.valueValidator().validateRecordFields((Seq<RecordField>)createArguments.fields(), contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)validatedRecordField -> this.fieldValidations().requireName(createAndExercise.value().choice(), "choice", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)choice -> this.fieldValidations().requirePresence(createAndExercise.value().choiceArgument(), "value", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)value -> this.valueValidator().validateValue((Value)value, contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)validatedChoiceArgument -> new CreateAndExerciseCommand(validatedTemplateId, (com.daml.lf.value.Value)new Value.ValueRecord(recordId, validatedRecordField), choice, validatedChoiceArgument)))))))));
        } else if (Command.Command$.Empty$.MODULE$.equals(command2)) {
            either = package$.MODULE$.Left().apply((Object)this.errorFactories().missingField("command", (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger));
        } else {
            throw new MatchError((Object)command2);
        }
        return either;
    }

    private Either<StatusRuntimeException, Submitters<String>> validateSubmitters(com.daml.ledger.api.v1.commands.Commands commands, ContextualizedErrorLogger contextualizedErrorLogger) {
        Submitters<String> submitters = CommandsValidator$.MODULE$.effectiveSubmitters(commands);
        return this.fieldValidations().requireParties(submitters.actAs(), contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)actAs -> this.fieldValidations().requireParties(submitters.readAs(), contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)readAs -> this.actAsMustNotBeEmpty$1((Set)actAs, contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)_ -> new Submitters(actAs, readAs))));
    }

    private final Either actAsMustNotBeEmpty$1(Set effectiveActAs, ContextualizedErrorLogger contextualizedErrorLogger$4) {
        return package$.MODULE$.Either().cond(effectiveActAs.nonEmpty(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, (Function0 & Serializable & scala.Serializable)() -> this.errorFactories().missingField("party or act_as", (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger$4));
    }

    public CommandsValidator(Object ledgerId, ErrorCodesVersionSwitcher errorCodesVersionSwitcher) {
        this.ledgerId = ledgerId;
        this.errorFactories = ErrorFactories$.MODULE$.apply(errorCodesVersionSwitcher);
        this.fieldValidations = FieldValidations$.MODULE$.apply(this.errorFactories());
        this.valueValidator = new ValueValidator(this.errorFactories(), this.fieldValidations());
    }

    public static class Submitters<T>
    implements Product,
    scala.Serializable {
        private final Set<T> actAs;
        private final Set<T> readAs;

        public Set<T> actAs() {
            return this.actAs;
        }

        public Set<T> readAs() {
            return this.readAs;
        }

        public <T> Submitters<T> copy(Set<T> actAs, Set<T> readAs) {
            return new Submitters<T>(actAs, readAs);
        }

        public <T> Set<T> copy$default$1() {
            return this.actAs();
        }

        public <T> Set<T> copy$default$2() {
            return this.readAs();
        }

        public String productPrefix() {
            return "Submitters";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Set<T> set;
            int n = x$1;
            switch (n) {
                case 0: {
                    set = this.actAs();
                    break;
                }
                case 1: {
                    set = this.readAs();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return set;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Submitters;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Submitters)) return false;
            boolean bl = true;
            if (!bl) return false;
            Submitters submitters = (Submitters)x$1;
            Set<T> set = this.actAs();
            Set<T> set2 = submitters.actAs();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<T> set3 = this.readAs();
            Set<T> set4 = submitters.readAs();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            if (!submitters.canEqual(this)) return false;
            return true;
        }

        public Submitters(Set<T> actAs, Set<T> readAs) {
            this.actAs = actAs;
            this.readAs = readAs;
            Product.$init$((Product)this);
        }
    }
}

