/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.validation;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.ErrorCodesVersionSwitcher;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.domain$;
import com.daml.ledger.api.v1.command_completion_service.CompletionEndRequest;
import com.daml.ledger.api.v1.command_completion_service.CompletionStreamRequest;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset;
import com.daml.ledger.api.validation.LedgerOffsetValidator;
import com.daml.ledger.api.validation.PartyNameChecker;
import com.daml.ledger.api.validation.PartyValidator;
import com.daml.lf.data.Ref$;
import com.daml.platform.server.api.validation.ErrorFactories;
import com.daml.platform.server.api.validation.ErrorFactories$;
import com.daml.platform.server.api.validation.FieldValidations;
import com.daml.platform.server.api.validation.FieldValidations$;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\b\u0011\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A!\b\u0001B\u0001B\u0003%1\bC\u0003B\u0001\u0011\u0005!\tC\u0004H\u0001\t\u0007I\u0011\u0002%\t\rM\u0003\u0001\u0015!\u0003J\u0011\u001d!\u0006A1A\u0005\nUCa!\u0017\u0001!\u0002\u00131\u0006b\u0002.\u0001\u0005\u0004%Ia\u0017\u0005\u0007?\u0002\u0001\u000b\u0011\u0002/\t\u000f\u0001\u0004!\u0019!C\u0005C\"1Q\r\u0001Q\u0001\n\tDQA\u001a\u0001\u0005\u0002\u001dDq!a\u000e\u0001\t\u0003\tIDA\u0011D_6\u0004H.\u001a;j_:\u001cVM\u001d<jG\u0016\u0014V-];fgR4\u0016\r\\5eCR|'O\u0003\u0002\u0012%\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005M!\u0012aA1qS*\u0011QCF\u0001\u0007Y\u0016$w-\u001a:\u000b\u0005]A\u0012\u0001\u00023b[2T\u0011!G\u0001\u0004G>l7\u0001A\n\u0003\u0001q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0017\u0001\u00037fI\u001e,'/\u00133\u0011\u0005\u0011\u0012dBA\u00131\u001d\t1sF\u0004\u0002(]9\u0011\u0001&\f\b\u0003S1j\u0011A\u000b\u0006\u0003Wi\ta\u0001\u0010:p_Rt\u0014\"A\r\n\u0005]A\u0012BA\u000b\u0017\u0013\t\u0019B#\u0003\u00022%\u00051Am\\7bS:L!a\r\u001b\u0003\u00111+GmZ3s\u0013\u0012T!!\r\n\u0002!A\f'\u000f^=OC6,7\t[3dW\u0016\u0014\bCA\u001c9\u001b\u0005\u0001\u0012BA\u001d\u0011\u0005A\u0001\u0016M\u001d;z\u001d\u0006lWm\u00115fG.,'/A\rfeJ|'oQ8eKN4VM]:j_:\u001cv/\u001b;dQ\u0016\u0014\bC\u0001\u001f@\u001b\u0005i$B\u0001 \u0017\u0003\u0015)'O]8s\u0013\t\u0001UHA\rFeJ|'oQ8eKN4VM]:j_:\u001cv/\u001b;dQ\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003D\t\u00163\u0005CA\u001c\u0001\u0011\u0015\u0011C\u00011\u0001$\u0011\u0015)D\u00011\u00017\u0011\u0015QD\u00011\u0001<\u00039)'O]8s\r\u0006\u001cGo\u001c:jKN,\u0012!\u0013\t\u0003\u0015Fk\u0011a\u0013\u0006\u0003#1S!aE'\u000b\u00059{\u0015AB:feZ,'O\u0003\u0002Q-\u0005A\u0001\u000f\\1uM>\u0014X.\u0003\u0002S\u0017\nqQI\u001d:pe\u001a\u000b7\r^8sS\u0016\u001c\u0018aD3se>\u0014h)Y2u_JLWm\u001d\u0011\u0002!\u0019LW\r\u001c3WC2LG-\u0019;j_:\u001cX#\u0001,\u0011\u0005);\u0016B\u0001-L\u0005A1\u0015.\u001a7e-\u0006d\u0017\u000eZ1uS>t7/A\tgS\u0016dGMV1mS\u0012\fG/[8og\u0002\na\u0002]1sif4\u0016\r\\5eCR|'/F\u0001]!\t9T,\u0003\u0002_!\tq\u0001+\u0019:usZ\u000bG.\u001b3bi>\u0014\u0018a\u00049beRLh+\u00197jI\u0006$xN\u001d\u0011\u0002+1,GmZ3s\u001f\u001a47/\u001a;WC2LG-\u0019;peV\t!\r\u0005\u00028G&\u0011A\r\u0005\u0002\u0016\u0019\u0016$w-\u001a:PM\u001a\u001cX\r\u001e,bY&$\u0017\r^8s\u0003YaW\rZ4fe>3gm]3u-\u0006d\u0017\u000eZ1u_J\u0004\u0013a\b<bY&$\u0017\r^3D_6\u0004H.\u001a;j_:\u001cFO]3b[J+\u0017/^3tiR)\u0001.a\u0005\u0002&Q\u0019\u0011.!\u0003\u0011\t)|'O\u001f\b\u0003W6t!!\u000b7\n\u0003}I!A\u001c\u0010\u0002\u000fA\f7m[1hK&\u0011\u0001/\u001d\u0002\u0007\u000b&$\b.\u001a:\u000b\u00059t\u0002CA:y\u001b\u0005!(BA;w\u0003\u00119'\u000f]2\u000b\u0003]\f!![8\n\u0005e$(AF*uCR,8OU;oi&lW-\u0012=dKB$\u0018n\u001c8\u0011\u0007m\f)!D\u0001}\u0015\tih0\u0001\u0006d_6\u0004H.\u001a;j_:T1a`A\u0001\u0003\u001d\u0019w.\\7b]\u0012T1!a\u0001\u0013\u0003!iWm]:bO\u0016\u001c\u0018bAA\u0004y\n92i\\7qY\u0016$\u0018n\u001c8TiJ,\u0017-\u001c*fcV,7\u000f\u001e\u0005\b\u0003\u0017i\u00019AA\u0007\u0003e\u0019wN\u001c;fqR,\u0018\r\\5{K\u0012,%O]8s\u0019><w-\u001a:\u0011\u0007q\ny!C\u0002\u0002\u0012u\u0012\u0011dQ8oi\u0016DH/^1mSj,G-\u0012:s_JdunZ4fe\"9\u0011QC\u0007A\u0002\u0005]\u0011a\u0002:fcV,7\u000f\u001e\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003i\u0019w.\\7b]\u0012|6m\\7qY\u0016$\u0018n\u001c8`g\u0016\u0014h/[2f\u0015\r\t\tCE\u0001\u0003mFJA!a\u0002\u0002\u001c!9\u0011qE\u0007A\u0002\u0005%\u0012!\u00037fI\u001e,'/\u00128e!\u0011\tY#!\r\u000f\u0007\u0011\ni#C\u0002\u00020Q\nA\u0002T3eO\u0016\u0014xJ\u001a4tKRLA!a\r\u00026\tA\u0011IY:pYV$XMC\u0002\u00020Q\nAD^1mS\u0012\fG/Z\"p[BdW\r^5p]\u0016sGMU3rk\u0016\u001cH\u000f\u0006\u0003\u0002<\u0005\u001dC\u0003BA\u001f\u0003\u000b\u0002RA[8s\u0003\u007f\u00012a_A!\u0013\r\t\u0019\u0005 \u0002\u0015\u0007>l\u0007\u000f\\3uS>tWI\u001c3SKF,Xm\u001d;\t\u000f\u0005-a\u0002q\u0001\u0002\u000e!9\u0011\u0011\n\bA\u0002\u0005-\u0013a\u0001:fcB!\u0011\u0011DA'\u0013\u0011\t\u0019%a\u0007")
public class CompletionServiceRequestValidator {
    private final Object ledgerId;
    private final ErrorFactories errorFactories;
    private final FieldValidations fieldValidations;
    private final PartyValidator partyValidator;
    private final LedgerOffsetValidator ledgerOffsetValidator;

    private ErrorFactories errorFactories() {
        return this.errorFactories;
    }

    private FieldValidations fieldValidations() {
        return this.fieldValidations;
    }

    private PartyValidator partyValidator() {
        return this.partyValidator;
    }

    private LedgerOffsetValidator ledgerOffsetValidator() {
        return this.ledgerOffsetValidator;
    }

    public Either<StatusRuntimeException, com.daml.ledger.api.messages.command.completion.CompletionStreamRequest> validateCompletionStreamRequest(CompletionStreamRequest request, domain.LedgerOffset.Absolute ledgerEnd, ContextualizedErrorLogger contextualizedErrorLogger) {
        return this.fieldValidations().matchLedgerId(this.ledgerId, domain$.MODULE$.LedgerId().apply((Object)request.ledgerId()), contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.fieldValidations().requireNonEmptyString(request.applicationId(), "application_id", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)nonEmptyAppId -> Ref$.MODULE$.LedgerString().fromString(nonEmptyAppId).left().map((Function1 & Serializable & scala.Serializable)x$1 -> this.errorFactories().invalidField("application_id", (String)x$1, (Option<Object>)None$.MODULE$, contextualizedErrorLogger)).flatMap((Function1 & Serializable & scala.Serializable)appId -> this.fieldValidations().requireNonEmpty(request.parties(), "parties", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)nonEmptyParties -> this.partyValidator().requireKnownParties((Iterable<String>)nonEmptyParties, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)knownParties -> this.ledgerOffsetValidator().validateOptional((Option<LedgerOffset>)request.offset(), "offset", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)convertedOffset -> this.ledgerOffsetValidator().offsetIsBeforeEndIfAbsolute("Begin", (Option<domain.LedgerOffset>)convertedOffset, ledgerEnd, contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)_ -> new com.daml.ledger.api.messages.command.completion.CompletionStreamRequest($this.ledgerId, domain$.MODULE$.ApplicationId().apply(appId), knownParties, convertedOffset))))))));
    }

    public Either<StatusRuntimeException, com.daml.ledger.api.messages.command.completion.CompletionEndRequest> validateCompletionEndRequest(CompletionEndRequest req, ContextualizedErrorLogger contextualizedErrorLogger) {
        return this.fieldValidations().matchLedgerId(this.ledgerId, domain$.MODULE$.LedgerId().apply((Object)req.ledgerId()), contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)ledgerId -> new com.daml.ledger.api.messages.command.completion.CompletionEndRequest(ledgerId));
    }

    public CompletionServiceRequestValidator(Object ledgerId, PartyNameChecker partyNameChecker, ErrorCodesVersionSwitcher errorCodesVersionSwitcher) {
        this.ledgerId = ledgerId;
        this.errorFactories = ErrorFactories$.MODULE$.apply(errorCodesVersionSwitcher);
        this.fieldValidations = FieldValidations$.MODULE$.apply(this.errorFactories());
        this.partyValidator = new PartyValidator(partyNameChecker, this.errorFactories(), this.fieldValidations());
        this.ledgerOffsetValidator = new LedgerOffsetValidator(this.errorFactories());
    }
}

