/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.validation;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.domain$;
import com.daml.ledger.api.messages.transaction.GetLedgerEndRequest;
import com.daml.ledger.api.messages.transaction.GetTransactionByEventIdRequest;
import com.daml.ledger.api.messages.transaction.GetTransactionByIdRequest;
import com.daml.ledger.api.messages.transaction.GetTransactionTreesRequest;
import com.daml.ledger.api.messages.transaction.GetTransactionsRequest;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset;
import com.daml.ledger.api.v1.transaction_filter.Filters;
import com.daml.ledger.api.v1.transaction_filter.InclusiveFilters;
import com.daml.ledger.api.v1.transaction_filter.TransactionFilter;
import com.daml.ledger.api.validation.LedgerOffsetValidator;
import com.daml.ledger.api.validation.PartyNameChecker;
import com.daml.ledger.api.validation.PartyValidator;
import com.daml.ledger.api.validation.TransactionFilterValidator;
import com.daml.ledger.api.validation.TransactionServiceRequestValidator$PartialValidation$;
import com.daml.platform.server.api.validation.ErrorFactories;
import com.daml.platform.server.api.validation.FieldValidations;
import com.daml.platform.server.api.validation.FieldValidations$;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\rut!B\u001d;\u0011\u0003)e!B$;\u0011\u0003A\u0005\"B(\u0002\t\u0003\u0001V\u0001B)\u0002\u0001I3Aa\u0012\u001e\u0001e\"A1\u000f\u0002B\u0001B\u0003%A\u000f\u0003\u0006\u0002\b\u0011\u0011\t\u0011)A\u0005\u0003\u0013A!\"a\u0004\u0005\u0005\u0003\u0005\u000b\u0011BA\t\u0011\u0019yE\u0001\"\u0001\u0002&!I\u0011q\u0006\u0003C\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003s!\u0001\u0015!\u0003\u00024!I\u00111\b\u0003C\u0002\u0013%\u0011Q\b\u0005\t\u0003\u000b\"\u0001\u0015!\u0003\u0002@!I\u0011q\t\u0003C\u0002\u0013%\u0011\u0011\n\u0005\t\u0003#\"\u0001\u0015!\u0003\u0002L!I\u00111\u000b\u0003C\u0002\u0013%\u0011Q\u000b\u0005\t\u0003;\"\u0001\u0015!\u0003\u0002X!9\u0011q\f\u0003\u0005\n\u0005\u0005dABA?\t\u0001\u000by\bC\u0005t%\tU\r\u0011\"\u0001\u0002\u000e\"Q\u0011Q\u0013\n\u0003\u0012\u0003\u0006I!a$\t\u0015\u0005]%C!f\u0001\n\u0003\tI\n\u0003\u0006\u0002,J\u0011\t\u0012)A\u0005\u00037C!\"!,\u0013\u0005+\u0007I\u0011AAX\u0011)\t9L\u0005B\tB\u0003%\u0011\u0011\u0017\u0005\u000b\u0003s\u0013\"Q3A\u0005\u0002\u0005m\u0006BCAb%\tE\t\u0015!\u0003\u0002>\"Q\u0011Q\u0019\n\u0003\u0016\u0004%\t!a2\t\u0015\u0005E(C!E!\u0002\u0013\tI\r\u0003\u0004P%\u0011\u0005\u00111\u001f\u0005\n\u0005\u0007\u0011\u0012\u0011!C\u0001\u0005\u000bA\u0011B!\u0005\u0013#\u0003%\tAa\u0005\t\u0013\t%\"#%A\u0005\u0002\t-\u0002\"\u0003B\u0018%E\u0005I\u0011\u0001B\u0019\u0011%\u0011)DEI\u0001\n\u0003\u00119\u0004C\u0005\u0003<I\t\n\u0011\"\u0001\u0003>!I!\u0011\t\n\u0002\u0002\u0013\u0005#1\t\u0005\n\u0005+\u0012\u0012\u0011!C\u0001\u0005/B\u0011Ba\u0018\u0013\u0003\u0003%\tA!\u0019\t\u0013\t\u001d$#!A\u0005B\t%\u0004\"\u0003B<%\u0005\u0005I\u0011\u0001B=\u0011%\u0011\u0019IEA\u0001\n\u0003\u0012)\tC\u0005\u0003\bJ\t\t\u0011\"\u0011\u0003\n\"I!1\u0012\n\u0002\u0002\u0013\u0005#QR\u0004\n\u0005##\u0011\u0011!E\u0001\u0005'3\u0011\"! \u0005\u0003\u0003E\tA!&\t\r=kC\u0011\u0001BR\u0011%\u00119)LA\u0001\n\u000b\u0012I\tC\u0005\u0003&6\n\t\u0011\"!\u0003(\"I!1W\u0017\u0002\u0002\u0013\u0005%Q\u0017\u0005\b\u0005\u0007$A\u0011\u0002Bc\u0011\u001d\u0011i\u000e\u0002C\u0001\u0005?Dqa!\u0003\u0005\t\u0003\u0019Y\u0001C\u0004\u0004\u001e\u0011!\taa\b\t\u000f\rMB\u0001\"\u0001\u00046!91\u0011\n\u0003\u0005\u0002\r-\u0003bBB0\t\u0011%1\u0011M\u0001#)J\fgn]1di&|gnU3sm&\u001cWMU3rk\u0016\u001cHOV1mS\u0012\fGo\u001c:\u000b\u0005mb\u0014A\u0003<bY&$\u0017\r^5p]*\u0011QHP\u0001\u0004CBL'BA A\u0003\u0019aW\rZ4fe*\u0011\u0011IQ\u0001\u0005I\u0006lGNC\u0001D\u0003\r\u0019w.\\\u0002\u0001!\t1\u0015!D\u0001;\u0005\t\"&/\u00198tC\u000e$\u0018n\u001c8TKJ4\u0018nY3SKF,Xm\u001d;WC2LG-\u0019;peN\u0011\u0011!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0002\u0019\u0006)1oY1mC&\u0011aj\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)%A\u0002*fgVdG/\u0006\u0002TSB!A\u000bX0h\u001d\t)&L\u0004\u0002W36\tqK\u0003\u0002Y\t\u00061AH]8pizJ\u0011\u0001T\u0005\u00037.\u000bq\u0001]1dW\u0006<W-\u0003\u0002^=\n1Q)\u001b;iKJT!aW&\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001B4sa\u000eT\u0011\u0001Z\u0001\u0003S>L!AZ1\u0003-M#\u0018\r^;t%VtG/[7f\u000bb\u001cW\r\u001d;j_:\u0004\"\u0001[5\r\u0001\u0011)!n\u0001b\u0001W\n\t\u0001,\u0005\u0002m_B\u0011!*\\\u0005\u0003].\u0013qAT8uQ&tw\r\u0005\u0002Ka&\u0011\u0011o\u0013\u0002\u0004\u0003:L8C\u0001\u0003J\u0003!aW\rZ4fe&#\u0007cA;\u0002\u00029\u0011aO \b\u0003ovt!\u0001\u001f?\u000f\u0005e\\hB\u0001,{\u0013\u0005\u0019\u0015BA!C\u0013\ty\u0004)\u0003\u0002>}%\u0011q\u0010P\u0001\u0007I>l\u0017-\u001b8\n\t\u0005\r\u0011Q\u0001\u0002\t\u0019\u0016$w-\u001a:JI*\u0011q\u0010P\u0001\u0011a\u0006\u0014H/\u001f(b[\u0016\u001c\u0005.Z2lKJ\u00042ARA\u0006\u0013\r\tiA\u000f\u0002\u0011!\u0006\u0014H/\u001f(b[\u0016\u001c\u0005.Z2lKJ\fa\"\u001a:s_J4\u0015m\u0019;pe&,7\u000f\u0005\u0003\u0002\u0014\u0005\u0005RBAA\u000b\u0015\rY\u0014q\u0003\u0006\u0004{\u0005e!\u0002BA\u000e\u0003;\taa]3sm\u0016\u0014(bAA\u0010\u0001\u0006A\u0001\u000f\\1uM>\u0014X.\u0003\u0003\u0002$\u0005U!AD#se>\u0014h)Y2u_JLWm\u001d\u000b\t\u0003O\tI#a\u000b\u0002.A\u0011a\t\u0002\u0005\u0006g\"\u0001\r\u0001\u001e\u0005\b\u0003\u000fA\u0001\u0019AA\u0005\u0011\u001d\ty\u0001\u0003a\u0001\u0003#\t\u0001CZ5fY\u00124\u0016\r\\5eCRLwN\\:\u0016\u0005\u0005M\u0002\u0003BA\n\u0003kIA!a\u000e\u0002\u0016\t\u0001b)[3mIZ\u000bG.\u001b3bi&|gn]\u0001\u0012M&,G\u000e\u001a,bY&$\u0017\r^5p]N\u0004\u0013A\u00049beRLh+\u00197jI\u0006$xN]\u000b\u0003\u0003\u007f\u00012ARA!\u0013\r\t\u0019E\u000f\u0002\u000f!\u0006\u0014H/\u001f,bY&$\u0017\r^8s\u0003=\u0001\u0018M\u001d;z-\u0006d\u0017\u000eZ1u_J\u0004\u0013!\u00067fI\u001e,'o\u00144gg\u0016$h+\u00197jI\u0006$xN]\u000b\u0003\u0003\u0017\u00022ARA'\u0013\r\tyE\u000f\u0002\u0016\u0019\u0016$w-\u001a:PM\u001a\u001cX\r\u001e,bY&$\u0017\r^8s\u0003YaW\rZ4fe>3gm]3u-\u0006d\u0017\u000eZ1u_J\u0004\u0013A\u0007;sC:\u001c\u0018m\u0019;j_:4\u0015\u000e\u001c;feZ\u000bG.\u001b3bi>\u0014XCAA,!\r1\u0015\u0011L\u0005\u0004\u00037R$A\u0007+sC:\u001c\u0018m\u0019;j_:4\u0015\u000e\u001c;feZ\u000bG.\u001b3bi>\u0014\u0018a\u0007;sC:\u001c\u0018m\u0019;j_:4\u0015\u000e\u001c;feZ\u000bG.\u001b3bi>\u0014\b%A\u0004nCR\u001c\u0007.\u00133\u0015\t\u0005\r\u0014\u0011\u0010\u000b\u0005\u0003K\nI\u0007\u0005\u0003\u0002h\r!hB\u0001$\u0001\u0011\u001d\tY'\u0005a\u0002\u0003[\n\u0011dY8oi\u0016DH/^1mSj,G-\u0012:s_JdunZ4feB!\u0011qNA;\u001b\t\t\tHC\u0002\u0002t\u0001\u000bQ!\u001a:s_JLA!a\u001e\u0002r\tI2i\u001c8uKb$X/\u00197ju\u0016$WI\u001d:pe2{wmZ3s\u0011\u0019\tY(\u0005a\u0001i\u0006)\u0011N\u001c9vi\n\t\u0002+\u0019:uS\u0006dg+\u00197jI\u0006$\u0018n\u001c8\u0014\rII\u0015\u0011QAD!\rQ\u00151Q\u0005\u0004\u0003\u000b[%a\u0002)s_\u0012,8\r\u001e\t\u0004\u0015\u0006%\u0015bAAF\u0017\na1+\u001a:jC2L'0\u00192mKV\u0011\u0011q\u0012\t\u0005\u0003#\u000b\tAD\u0002\u0002\u0014zl\u0011\u0001P\u0001\nY\u0016$w-\u001a:JI\u0002\n\u0011\u0003\u001e:b]N\f7\r^5p]\u001aKG\u000e^3s+\t\tY\n\u0005\u0003\u0002\u001e\u0006\u001dVBAAP\u0015\u0011\t\t+a)\u0002%Q\u0014\u0018M\\:bGRLwN\\0gS2$XM\u001d\u0006\u0004\u0003Kc\u0014A\u0001<2\u0013\u0011\tI+a(\u0003#Q\u0013\u0018M\\:bGRLwN\u001c$jYR,'/\u0001\nue\u0006t7/Y2uS>tg)\u001b7uKJ\u0004\u0013!\u00022fO&tWCAAY!\u0011\t\t*a-\n\t\u0005U\u0016Q\u0001\u0002\r\u0019\u0016$w-\u001a:PM\u001a\u001cX\r^\u0001\u0007E\u0016<\u0017N\u001c\u0011\u0002\u0007\u0015tG-\u0006\u0002\u0002>B)!*a0\u00022&\u0019\u0011\u0011Y&\u0003\r=\u0003H/[8o\u0003\u0011)g\u000e\u001a\u0011\u0002\u0019-twn\u001e8QCJ$\u0018.Z:\u0016\u0005\u0005%\u0007CBAf\u0003'\fIN\u0004\u0003\u0002N\u0006=\u0007C\u0001,L\u0013\r\t\tnS\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0017q\u001b\u0002\u0004'\u0016$(bAAi\u0017B!\u00111\\Av\u001d\u0011\ti.a:\u000e\u0005\u0005}'\u0002BAq\u0003G\fA\u0001Z1uC*\u0019\u0011Q\u001d!\u0002\u000514\u0017\u0002BAu\u0003?\f1AU3g\u0013\u0011\ti/a<\u0003\u000bA\u000b'\u000f^=\u000b\t\u0005%\u0018q\\\u0001\u000eW:|wO\u001c)beRLWm\u001d\u0011\u0015\u0019\u0005U\u0018\u0011`A~\u0003{\fyP!\u0001\u0011\u0007\u0005](#D\u0001\u0005\u0011\u0019\u0019X\u00041\u0001\u0002\u0010\"9\u0011qS\u000fA\u0002\u0005m\u0005bBAW;\u0001\u0007\u0011\u0011\u0017\u0005\b\u0003sk\u0002\u0019AA_\u0011\u001d\t)-\ba\u0001\u0003\u0013\fAaY8qsRa\u0011Q\u001fB\u0004\u0005\u0013\u0011YA!\u0004\u0003\u0010!A1O\bI\u0001\u0002\u0004\ty\tC\u0005\u0002\u0018z\u0001\n\u00111\u0001\u0002\u001c\"I\u0011Q\u0016\u0010\u0011\u0002\u0003\u0007\u0011\u0011\u0017\u0005\n\u0003ss\u0002\u0013!a\u0001\u0003{C\u0011\"!2\u001f!\u0003\u0005\r!!3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u0003\u0016\u0005\u0003\u001f\u00139b\u000b\u0002\u0003\u001aA!!1\u0004B\u0013\u001b\t\u0011iB\u0003\u0003\u0003 \t\u0005\u0012!C;oG\",7m[3e\u0015\r\u0011\u0019cS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0014\u0005;\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\f+\t\u0005m%qC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\u0019D\u000b\u0003\u00022\n]\u0011AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005sQC!!0\u0003\u0018\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TC\u0001B U\u0011\tIMa\u0006\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011)\u0005\u0005\u0003\u0003H\tESB\u0001B%\u0015\u0011\u0011YE!\u0014\u0002\t1\fgn\u001a\u0006\u0003\u0005\u001f\nAA[1wC&!!1\u000bB%\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!\u0011\f\t\u0004\u0015\nm\u0013b\u0001B/\u0017\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019qNa\u0019\t\u0013\t\u0015d%!AA\u0002\te\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003lA)!Q\u000eB:_6\u0011!q\u000e\u0006\u0004\u0005cZ\u0015AC2pY2,7\r^5p]&!!Q\u000fB8\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\tm$\u0011\u0011\t\u0004\u0015\nu\u0014b\u0001B@\u0017\n9!i\\8mK\u0006t\u0007\u0002\u0003B3Q\u0005\u0005\t\u0019A8\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\u0017\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u0012\u0002\r\u0015\fX/\u00197t)\u0011\u0011YHa$\t\u0011\t\u00154&!AA\u0002=\f\u0011\u0003U1si&\fGNV1mS\u0012\fG/[8o!\r\t90L\n\u0006[\t]\u0015q\u0011\t\u0011\u00053\u0013y*a$\u0002\u001c\u0006E\u0016QXAe\u0003kl!Aa'\u000b\u0007\tu5*A\u0004sk:$\u0018.\\3\n\t\t\u0005&1\u0014\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:,DC\u0001BJ\u0003\u0015\t\u0007\u000f\u001d7z)1\t)P!+\u0003,\n5&q\u0016BY\u0011\u0019\u0019\b\u00071\u0001\u0002\u0010\"9\u0011q\u0013\u0019A\u0002\u0005m\u0005bBAWa\u0001\u0007\u0011\u0011\u0017\u0005\b\u0003s\u0003\u0004\u0019AA_\u0011\u001d\t)\r\ra\u0001\u0003\u0013\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u00038\n}\u0006#\u0002&\u0002@\ne\u0006#\u0004&\u0003<\u0006=\u00151TAY\u0003{\u000bI-C\u0002\u0003>.\u0013a\u0001V;qY\u0016,\u0004\"\u0003Bac\u0005\u0005\t\u0019AA{\u0003\rAH\u0005M\u0001\u0012G>lWn\u001c8WC2LG-\u0019;j_:\u001cH\u0003\u0002Bd\u0005\u001b$BA!3\u0003LB)\u0011qM\u0002\u0002v\"9\u00111\u000e\u001aA\u0004\u00055\u0004b\u0002Bhe\u0001\u0007!\u0011[\u0001\u0004e\u0016\f\b\u0003\u0002Bj\u00053l!A!6\u000b\t\t]\u00171U\u0001\u0014iJ\fgn]1di&|gnX:feZL7-Z\u0005\u0005\u00057\u0014)N\u0001\fHKR$&/\u00198tC\u000e$\u0018n\u001c8t%\u0016\fX/Z:u\u0003!1\u0018\r\\5eCR,GC\u0002Bq\u0005k\u00149\u0010\u0006\u0003\u0003d\nM\b#BA4\u0007\t\u0015\b\u0003\u0002Bt\u0005cl!A!;\u000b\t\t-(Q^\u0001\fiJ\fgn]1di&|gNC\u0002\u0003pr\n\u0001\"\\3tg\u0006<Wm]\u0005\u0005\u00057\u0014I\u000fC\u0004\u0002lM\u0002\u001d!!\u001c\t\u000f\t=7\u00071\u0001\u0003R\"9!\u0011`\u001aA\u0002\tm\u0018!\u00037fI\u001e,'/\u00128e!\u0011\u0011ipa\u0001\u000f\u0007U\u0014y0\u0003\u0003\u0004\u0002\u0005\u0015\u0011\u0001\u0004'fI\u001e,'o\u00144gg\u0016$\u0018\u0002BB\u0003\u0007\u000f\u0011\u0001\"\u00112t_2,H/\u001a\u0006\u0005\u0007\u0003\t)!\u0001\u0007wC2LG-\u0019;f)J,W\r\u0006\u0004\u0004\u000e\re11\u0004\u000b\u0005\u0007\u001f\u00199\u0002E\u0003\u0002h\r\u0019\t\u0002\u0005\u0003\u0003h\u000eM\u0011\u0002BB\u000b\u0005S\u0014!dR3u)J\fgn]1di&|g\u000e\u0016:fKN\u0014V-];fgRDq!a\u001b5\u0001\b\ti\u0007C\u0004\u0003PR\u0002\rA!5\t\u000f\teH\u00071\u0001\u0003|\u0006\tb/\u00197jI\u0006$X\rT3eO\u0016\u0014XI\u001c3\u0015\t\r\u00052Q\u0006\u000b\u0005\u0007G\u0019Y\u0003E\u0003\u0002h\r\u0019)\u0003\u0005\u0003\u0003h\u000e\u001d\u0012\u0002BB\u0015\u0005S\u00141cR3u\u0019\u0016$w-\u001a:F]\u0012\u0014V-];fgRDq!a\u001b6\u0001\b\ti\u0007C\u0004\u0003PV\u0002\raa\f\u0011\t\tM7\u0011G\u0005\u0005\u0007S\u0011).A\fwC2LG-\u0019;f)J\fgn]1di&|gNQ=JIR!1qGB\")\u0011\u0019Id!\u0011\u0011\u000b\u0005\u001d4aa\u000f\u0011\t\t\u001d8QH\u0005\u0005\u0007\u007f\u0011IOA\rHKR$&/\u00198tC\u000e$\u0018n\u001c8Cs&#'+Z9vKN$\bbBA6m\u0001\u000f\u0011Q\u000e\u0005\b\u0005\u001f4\u0004\u0019AB#!\u0011\u0011\u0019na\u0012\n\t\r}\"Q[\u0001\u001dm\u0006d\u0017\u000eZ1uKR\u0013\u0018M\\:bGRLwN\u001c\"z\u000bZ,g\u000e^%e)\u0011\u0019ie!\u0017\u0015\t\r=3q\u000b\t\u0006\u0003O\u001a1\u0011\u000b\t\u0005\u0005O\u001c\u0019&\u0003\u0003\u0004V\t%(AH$fiR\u0013\u0018M\\:bGRLwN\u001c\"z\u000bZ,g\u000e^%e%\u0016\fX/Z:u\u0011\u001d\tYg\u000ea\u0002\u0003[BqAa48\u0001\u0004\u0019Y\u0006\u0005\u0003\u0003T\u000eu\u0013\u0002BB+\u0005+\f1\u0004\u001e:b]N\f7\r^5p]\u001aKG\u000e^3s)>\u0004\u0016M\u001d;z'\u0016$H\u0003BB2\u0007w\"Ba!\u001a\u0004zA11qMB5\u0007Wr1!a>\f\u0013\r\t\u0016\u0011\t\t\u0007\u0003\u0017\f\u0019n!\u001c\u0011\t\r=\u00141\u001e\b\u0005\u0007c\n9O\u0004\u0003\u0004t\r]db\u0001=\u0004v%\u0019\u0011Q\u001d!\n\t\u0005\u0005\u00181\u001d\u0005\b\u0003WB\u00049AA7\u0011\u001d\t9\n\u000fa\u0001\u00037\u0003")
public class TransactionServiceRequestValidator {
    private volatile TransactionServiceRequestValidator$PartialValidation$ PartialValidation$module;
    private final Object ledgerId;
    public final ErrorFactories com$daml$ledger$api$validation$TransactionServiceRequestValidator$$errorFactories;
    private final FieldValidations fieldValidations;
    private final PartyValidator partyValidator;
    private final LedgerOffsetValidator ledgerOffsetValidator;
    private final TransactionFilterValidator transactionFilterValidator;

    public TransactionServiceRequestValidator$PartialValidation$ PartialValidation() {
        if (this.PartialValidation$module == null) {
            this.PartialValidation$lzycompute$1();
        }
        return this.PartialValidation$module;
    }

    private FieldValidations fieldValidations() {
        return this.fieldValidations;
    }

    private PartyValidator partyValidator() {
        return this.partyValidator;
    }

    private LedgerOffsetValidator ledgerOffsetValidator() {
        return this.ledgerOffsetValidator;
    }

    private TransactionFilterValidator transactionFilterValidator() {
        return this.transactionFilterValidator;
    }

    private Either<StatusRuntimeException, Object> matchId(Object input, ContextualizedErrorLogger contextualizedErrorLogger) {
        return this.fieldValidations().matchLedgerId(this.ledgerId, input, contextualizedErrorLogger);
    }

    private Either<StatusRuntimeException, PartialValidation> commonValidations(com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest req, ContextualizedErrorLogger contextualizedErrorLogger) {
        return this.matchId(domain$.MODULE$.LedgerId().apply((Object)req.ledgerId()), contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)ledgerId -> this.fieldValidations().requirePresence(req.filter(), "filter", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)filter -> this.fieldValidations().requirePresence(req.begin(), "begin", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)requiredBegin -> this.ledgerOffsetValidator().validate((LedgerOffset)requiredBegin, "begin", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)convertedBegin -> this.ledgerOffsetValidator().validateOptional((Option<LedgerOffset>)req.end(), "end", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)convertedEnd -> this.partyValidator().requireKnownParties((Iterable<String>)req.getFilter().filtersByParty().keySet(), contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)knownParties -> new PartialValidation(this, ledgerId, (TransactionFilter)filter, (domain.LedgerOffset)convertedBegin, (Option<domain.LedgerOffset>)convertedEnd, (Set<String>)knownParties)))))));
    }

    public Either<StatusRuntimeException, GetTransactionsRequest> validate(com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest req, domain.LedgerOffset.Absolute ledgerEnd, ContextualizedErrorLogger contextualizedErrorLogger) {
        return this.commonValidations(req, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)partial -> this.ledgerOffsetValidator().offsetIsBeforeEndIfAbsolute("Begin", partial.begin(), ledgerEnd, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.ledgerOffsetValidator().offsetIsBeforeEndIfAbsolute("End", partial.end(), ledgerEnd, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.transactionFilterValidator().validate(partial.transactionFilter(), contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)convertedFilter -> new GetTransactionsRequest($this.ledgerId, partial.begin(), partial.end(), convertedFilter, req.verbose())))));
    }

    public Either<StatusRuntimeException, GetTransactionTreesRequest> validateTree(com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest req, domain.LedgerOffset.Absolute ledgerEnd, ContextualizedErrorLogger contextualizedErrorLogger) {
        return this.commonValidations(req, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)partial -> this.ledgerOffsetValidator().offsetIsBeforeEndIfAbsolute("Begin", partial.begin(), ledgerEnd, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.ledgerOffsetValidator().offsetIsBeforeEndIfAbsolute("End", partial.end(), ledgerEnd, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.transactionFilterToPartySet(partial.transactionFilter(), contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)convertedFilter -> new GetTransactionTreesRequest(partial.ledgerId(), partial.begin(), partial.end(), convertedFilter, req.verbose())))));
    }

    public Either<StatusRuntimeException, GetLedgerEndRequest> validateLedgerEnd(com.daml.ledger.api.v1.transaction_service.GetLedgerEndRequest req, ContextualizedErrorLogger contextualizedErrorLogger) {
        return this.matchId(domain$.MODULE$.LedgerId().apply((Object)req.ledgerId()), contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)ledgerId -> new GetLedgerEndRequest(ledgerId));
    }

    public Either<StatusRuntimeException, GetTransactionByIdRequest> validateTransactionById(com.daml.ledger.api.v1.transaction_service.GetTransactionByIdRequest req, ContextualizedErrorLogger contextualizedErrorLogger) {
        return this.matchId(domain$.MODULE$.LedgerId().apply((Object)req.ledgerId()), contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)ledgerId -> this.fieldValidations().requireNonEmptyString(req.transactionId(), "transaction_id", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.fieldValidations().requireLedgerString(req.transactionId(), contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)trId -> this.fieldValidations().requireNonEmpty(req.requestingParties(), "requesting_parties", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.partyValidator().requireKnownParties((Iterable<String>)req.requestingParties(), contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)parties -> new GetTransactionByIdRequest(ledgerId, domain$.MODULE$.TransactionId().apply(trId), parties))))));
    }

    public Either<StatusRuntimeException, GetTransactionByEventIdRequest> validateTransactionByEventId(com.daml.ledger.api.v1.transaction_service.GetTransactionByEventIdRequest req, ContextualizedErrorLogger contextualizedErrorLogger) {
        return this.matchId(domain$.MODULE$.LedgerId().apply((Object)req.ledgerId()), contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)ledgerId -> this.fieldValidations().requireLedgerString(req.eventId(), "event_id", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)eventId -> this.fieldValidations().requireNonEmpty(req.requestingParties(), "requesting_parties", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.partyValidator().requireKnownParties((Iterable<String>)req.requestingParties(), contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)parties -> new GetTransactionByEventIdRequest(ledgerId, domain$.MODULE$.EventId().apply(eventId), parties)))));
    }

    private Either<StatusRuntimeException, Set<String>> transactionFilterToPartySet(TransactionFilter transactionFilter, ContextualizedErrorLogger contextualizedErrorLogger) {
        return (Either)transactionFilter.filtersByParty().collectFirst((PartialFunction)new scala.Serializable(this, contextualizedErrorLogger){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionServiceRequestValidator $outer;
            private final ContextualizedErrorLogger contextualizedErrorLogger$6;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, Filters>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Option option;
                    String party = (String)A1._1();
                    Filters filters = (Filters)A1._2();
                    if (filters != null && (option = filters.inclusive()) instanceof Some) {
                        Some some = (Some)option;
                        InclusiveFilters inclusive = (InclusiveFilters)some.value();
                        object = this.$outer.com$daml$ledger$api$validation$TransactionServiceRequestValidator$$errorFactories.invalidArgument((Option<Object>)None$.MODULE$, new StringBuilder(155).append(party).append(" attempted subscription for templates ").append(inclusive.templateIds().mkString("[", ", ", "]")).append(". Template filtration is not supported on GetTransactionTrees RPC. To get filtered data, use the GetTransactions RPC.").toString(), this.contextualizedErrorLogger$6);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, Filters> x1) {
                Option option;
                Filters filters;
                Tuple2<String, Filters> tuple2 = x1;
                boolean bl = tuple2 != null && (filters = (Filters)tuple2._2()) != null && (option = filters.inclusive()) instanceof Some;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.contextualizedErrorLogger$6 = contextualizedErrorLogger$6;
            }
        }).fold((Function0 & Serializable & scala.Serializable)() -> this.partyValidator().requireKnownParties((Iterable<String>)transactionFilter.filtersByParty().keys(), contextualizedErrorLogger), (Function1 & Serializable & scala.Serializable)x$1 -> package$.MODULE$.Left().apply(x$1));
    }

    private final void PartialValidation$lzycompute$1() {
        TransactionServiceRequestValidator transactionServiceRequestValidator = this;
        synchronized (transactionServiceRequestValidator) {
            if (this.PartialValidation$module == null) {
                this.PartialValidation$module = new TransactionServiceRequestValidator$PartialValidation$(this);
            }
        }
    }

    public TransactionServiceRequestValidator(Object ledgerId, PartyNameChecker partyNameChecker, ErrorFactories errorFactories) {
        this.ledgerId = ledgerId;
        this.com$daml$ledger$api$validation$TransactionServiceRequestValidator$$errorFactories = errorFactories;
        this.fieldValidations = FieldValidations$.MODULE$.apply(errorFactories);
        this.partyValidator = new PartyValidator(partyNameChecker, errorFactories, this.fieldValidations());
        this.ledgerOffsetValidator = new LedgerOffsetValidator(errorFactories);
        this.transactionFilterValidator = new TransactionFilterValidator(errorFactories);
    }

    public class PartialValidation
    implements Product,
    scala.Serializable {
        private final Object ledgerId;
        private final TransactionFilter transactionFilter;
        private final domain.LedgerOffset begin;
        private final Option<domain.LedgerOffset> end;
        private final Set<String> knownParties;
        public final /* synthetic */ TransactionServiceRequestValidator $outer;

        public Object ledgerId() {
            return this.ledgerId;
        }

        public TransactionFilter transactionFilter() {
            return this.transactionFilter;
        }

        public domain.LedgerOffset begin() {
            return this.begin;
        }

        public Option<domain.LedgerOffset> end() {
            return this.end;
        }

        public Set<String> knownParties() {
            return this.knownParties;
        }

        public PartialValidation copy(Object ledgerId, TransactionFilter transactionFilter, domain.LedgerOffset begin, Option<domain.LedgerOffset> end, Set<String> knownParties) {
            return new PartialValidation(this.com$daml$ledger$api$validation$TransactionServiceRequestValidator$PartialValidation$$$outer(), ledgerId, transactionFilter, begin, end, knownParties);
        }

        public Object copy$default$1() {
            return this.ledgerId();
        }

        public TransactionFilter copy$default$2() {
            return this.transactionFilter();
        }

        public domain.LedgerOffset copy$default$3() {
            return this.begin();
        }

        public Option<domain.LedgerOffset> copy$default$4() {
            return this.end();
        }

        public Set<String> copy$default$5() {
            return this.knownParties();
        }

        public String productPrefix() {
            return "PartialValidation";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Option<domain.LedgerOffset> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.ledgerId();
                    break;
                }
                case 1: {
                    option = this.transactionFilter();
                    break;
                }
                case 2: {
                    option = this.begin();
                    break;
                }
                case 3: {
                    option = this.end();
                    break;
                }
                case 4: {
                    option = this.knownParties();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PartialValidation;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PartialValidation)) return false;
            if (((PartialValidation)object).com$daml$ledger$api$validation$TransactionServiceRequestValidator$PartialValidation$$$outer() != this.com$daml$ledger$api$validation$TransactionServiceRequestValidator$PartialValidation$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            PartialValidation partialValidation = (PartialValidation)x$1;
            if (!BoxesRunTime.equals((Object)this.ledgerId(), (Object)partialValidation.ledgerId())) return false;
            TransactionFilter transactionFilter = this.transactionFilter();
            TransactionFilter transactionFilter2 = partialValidation.transactionFilter();
            if (transactionFilter == null) {
                if (transactionFilter2 != null) {
                    return false;
                }
            } else if (!transactionFilter.equals(transactionFilter2)) return false;
            domain.LedgerOffset ledgerOffset = this.begin();
            domain.LedgerOffset ledgerOffset2 = partialValidation.begin();
            if (ledgerOffset == null) {
                if (ledgerOffset2 != null) {
                    return false;
                }
            } else if (!ledgerOffset.equals(ledgerOffset2)) return false;
            Option<domain.LedgerOffset> option = this.end();
            Option<domain.LedgerOffset> option2 = partialValidation.end();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Set<String> set = this.knownParties();
            Set<String> set2 = partialValidation.knownParties();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (!partialValidation.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ TransactionServiceRequestValidator com$daml$ledger$api$validation$TransactionServiceRequestValidator$PartialValidation$$$outer() {
            return this.$outer;
        }

        public PartialValidation(TransactionServiceRequestValidator $outer, Object ledgerId, TransactionFilter transactionFilter, domain.LedgerOffset begin, Option<domain.LedgerOffset> end, Set<String> knownParties) {
            this.ledgerId = ledgerId;
            this.transactionFilter = transactionFilter;
            this.begin = begin;
            this.end = end;
            this.knownParties = knownParties;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

