/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.api.validation;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.ledger.api.v1.value.Enum;
import com.daml.ledger.api.v1.value.GenMap;
import com.daml.ledger.api.v1.value.Identifier;
import com.daml.ledger.api.v1.value.List;
import com.daml.ledger.api.v1.value.Map;
import com.daml.ledger.api.v1.value.Optional;
import com.daml.ledger.api.v1.value.Record;
import com.daml.ledger.api.v1.value.RecordField;
import com.daml.ledger.api.v1.value.Value;
import com.daml.ledger.api.v1.value.Variant;
import com.daml.lf.data.BackStack$;
import com.daml.lf.data.FrontStack$;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Ref$;
import com.daml.lf.data.SortedLookupList$;
import com.daml.lf.data.Time;
import com.daml.lf.value.Value;
import com.daml.lf.value.Value$;
import com.daml.platform.server.api.validation.ErrorFactories;
import com.daml.platform.server.api.validation.FieldValidations;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scalaz.Bifunctor;
import scalaz.std.either$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001\u0002\u0006\f\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!)A\u0006\u0001C\u0001[!1!\u0007\u0001C\u0001\u0017MBQa\u001f\u0001\u0005\u0002qD\u0011\"!\b\u0001\u0005\u0004%I!a\b\t\u0011\u0005U\u0002\u0001)A\u0005\u0003CAq!a\u000e\u0001\t\u0003\tI\u0004\u0003\u0005\u0002J\u0001!\taCA&\u000591\u0016\r\\;f-\u0006d\u0017\u000eZ1u_JT!\u0001D\u0007\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002\u000f\u001f\u0005\u0019\u0011\r]5\u000b\u0005A\t\u0012A\u00027fI\u001e,'O\u0003\u0002\u0013'\u0005!A-Y7m\u0015\u0005!\u0012aA2p[\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u0006qQM\u001d:pe\u001a\u000b7\r^8sS\u0016\u001c\bCA\u0010'\u001b\u0005\u0001#B\u0001\u0007\"\u0015\tq!E\u0003\u0002$I\u000511/\u001a:wKJT!!J\t\u0002\u0011Ad\u0017\r\u001e4pe6L!a\n\u0011\u0003\u001d\u0015\u0013(o\u001c:GC\u000e$xN]5fg\u0006\u0001b-[3mIZ\u000bG.\u001b3bi&|gn\u001d\t\u0003?)J!a\u000b\u0011\u0003!\u0019KW\r\u001c3WC2LG-\u0019;j_:\u001c\u0018A\u0002\u001fj]&$h\bF\u0002/aE\u0002\"a\f\u0001\u000e\u0003-AQ!H\u0002A\u0002yAQ\u0001K\u0002A\u0002%\nAC^1mS\u0012\fG/\u001a*fG>\u0014HMR5fY\u0012\u001cHC\u0001\u001bo)\t)d\r\u0005\u00037}\u0005KeBA\u001c=\u001d\tA4(D\u0001:\u0015\tQT#\u0001\u0004=e>|GOP\u0005\u00025%\u0011Q(G\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004I\u0001\u0004FSRDWM\u001d\u0006\u0003{e\u0001\"AQ$\u000e\u0003\rS!\u0001R#\u0002\t\u001d\u0014\bo\u0019\u0006\u0002\r\u0006\u0011\u0011n\\\u0005\u0003\u0011\u000e\u0013ac\u0015;biV\u001c(+\u001e8uS6,W\t_2faRLwN\u001c\t\u0004\u0015>\u000bV\"A&\u000b\u00051k\u0015\u0001\u00023bi\u0006T!AT\t\u0002\u000514\u0017B\u0001)L\u0005!IU.\\!se\u0006L\b\u0003\u0002\rS)zK!aU\r\u0003\rQ+\b\u000f\\33!\rARkV\u0005\u0003-f\u0011aa\u00149uS>t\u0007C\u0001-\\\u001d\tQ\u0015,\u0003\u0002[\u0017\u0006\u0019!+\u001a4\n\u0005qk&\u0001\u0002(b[\u0016T!AW&\u0011\u0005}\u001bgB\u00011b\u001b\u0005i\u0011B\u00012\u000e\u0003\u0019!w.\\1j]&\u0011A-\u001a\u0002\u0006-\u0006dW/\u001a\u0006\u0003E6AQa\u001a\u0003A\u0004!\f\u0011dY8oi\u0016DH/^1mSj,G-\u0012:s_JdunZ4feB\u0011\u0011\u000e\\\u0007\u0002U*\u00111.E\u0001\u0006KJ\u0014xN]\u0005\u0003[*\u0014\u0011dQ8oi\u0016DH/^1mSj,G-\u0012:s_JdunZ4fe\")q\u000e\u0002a\u0001a\u0006a!/Z2pe\u00124\u0015.\u001a7egB\u0019a']:\n\u0005I\u0004%aA*fcB\u0011A/_\u0007\u0002k*\u0011ao^\u0001\u0006m\u0006dW/\u001a\u0006\u0003q6\t!A^\u0019\n\u0005i,(a\u0003*fG>\u0014HMR5fY\u0012\faB^1mS\u0012\fG/\u001a*fG>\u0014H\rF\u0002~\u0003'!2A`A\t!\u00111d(Q@\u0011\t\u0005\u0005\u00111\u0002\b\u0005\u0003\u0007\t9!\u0004\u0002\u0002\u0006)\u0011a/T\u0005\u0005\u0003\u0013\t)!A\u0003WC2,X-\u0003\u0003\u0002\u000e\u0005=!a\u0003,bYV,'+Z2pe\u0012TA!!\u0003\u0002\u0006!)q-\u0002a\u0002Q\"9\u0011QC\u0003A\u0002\u0005]\u0011a\u0001:fGB\u0019A/!\u0007\n\u0007\u0005mQO\u0001\u0004SK\u000e|'\u000fZ\u0001\u0013m\u0006d\u0017\u000e\u001a(v[\u0016\u0014\u0018nY*ue&tw-\u0006\u0002\u0002\"A!\u00111EA\u0019\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012!\u0002:fO\u0016D(\u0002BA\u0016\u0003[\tA!\u001e;jY*\u0011\u0011qF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00024\u0005\u0015\"a\u0002)biR,'O\\\u0001\u0014m\u0006d\u0017\u000e\u001a(v[\u0016\u0014\u0018nY*ue&tw\rI\u0001\u000em\u0006d\u0017\u000eZ1uKZ\u000bG.^3\u0015\t\u0005m\u0012\u0011\t\u000b\u0005\u0003{\ty\u0004\u0005\u00037}\u0005s\u0006\"B4\t\u0001\bA\u0007bBA\"\u0011\u0001\u0007\u0011QI\u0001\u0003mB\u00022\u0001^A$\u0013\t!W/\u0001\u000ewC2LG-\u0019;f\u001fB$\u0018n\u001c8bY&#WM\u001c;jM&,'\u000f\u0006\u0003\u0002N\u0005mC\u0003BA(\u00033\u0002RA\u000e B\u0003#\u0002B\u0001G+\u0002TA\u0019\u0001,!\u0016\n\u0007\u0005]SL\u0001\u0006JI\u0016tG/\u001b4jKJDQaZ\u0005A\u0004!Dq!!\u0018\n\u0001\u0004\ty&\u0001\u0006wCJL\u0017M\u001c;JI>\u0003B\u0001G+\u0002bA\u0019A/a\u0019\n\u0007\u0005]S\u000f")
public class ValueValidator {
    private final ErrorFactories errorFactories;
    private final FieldValidations fieldValidations;
    private final Pattern validNumericString;

    public Either<StatusRuntimeException, ImmArray<Tuple2<Option<String>, com.daml.lf.value.Value>>> validateRecordFields(Seq<RecordField> recordFields, ContextualizedErrorLogger contextualizedErrorLogger) {
        return ((Either)recordFields.foldLeft((Object)package$.MODULE$.Right().apply((Object)BackStack$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(acc, rf) -> acc.flatMap((Function1 & Serializable & scala.Serializable)fields -> $this.fieldValidations.requirePresence(rf.value(), "value", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)v -> this.validateValue((Value)v, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)value -> (rf.label().isEmpty() ? package$.MODULE$.Right().apply((Object)None$.MODULE$) : $this.fieldValidations.requireIdentifier(rf.label(), contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)x$1 -> new Some(x$1))).map((Function1 & Serializable & scala.Serializable)label -> fields.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(label), value)))))))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toImmArray());
    }

    public Either<StatusRuntimeException, Value.ValueRecord> validateRecord(Record rec, ContextualizedErrorLogger contextualizedErrorLogger) {
        return this.validateOptionalIdentifier((Option<Identifier>)rec.recordId(), contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)recId -> this.validateRecordFields((Seq<RecordField>)rec.fields(), contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)fields -> new Value.ValueRecord(recId, fields)));
    }

    private Pattern validNumericString() {
        return this.validNumericString;
    }

    public Either<StatusRuntimeException, com.daml.lf.value.Value> validateValue(Value v0, ContextualizedErrorLogger contextualizedErrorLogger) {
        Value.Sum$.List list;
        List list2;
        Value.Sum$.Enum enum_;
        Enum enum_2;
        Value.Sum$.Variant variant;
        Variant variant2;
        Either either;
        Value.Sum sum = v0.sum();
        if (sum instanceof Value.Sum$.ContractId) {
            Value.Sum$.ContractId contractId = (Value.Sum$.ContractId)sum;
            String cId = contractId.value();
            Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
            either = (Either)scalaz.syntax.package$.MODULE$.bifunctor().ToBifunctorOps((Object)Value.ContractId$.MODULE$.fromString(cId), (Bifunctor)either$.MODULE$.eitherInstance()).bimap((Function1 & Serializable & scala.Serializable)message -> $this.errorFactories.invalidArgument((Option<Object>)some, (String)message, contextualizedErrorLogger), (Function1 & Serializable & scala.Serializable)x$3 -> new Value.ValueContractId(x$3));
        } else if (sum instanceof Value.Sum$.Numeric) {
            Value.Sum$.Numeric numeric = (Value.Sum$.Numeric)sum;
            String value = numeric.value();
            either = this.validNumericString().matcher(value).matches() ? com.daml.lf.data.package$.MODULE$.Numeric().fromUnscaledBigDecimal(new BigDecimal(value)).left().map((Function1 & Serializable & scala.Serializable)x$4 -> this.err$1(value, contextualizedErrorLogger)).map((Function1)Value.ValueNumeric$.MODULE$) : package$.MODULE$.Left().apply((Object)this.err$1(value, contextualizedErrorLogger));
        } else if (sum instanceof Value.Sum$.Party) {
            Value.Sum$.Party party = (Value.Sum$.Party)sum;
            String party2 = party.value();
            Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
            either = Ref$.MODULE$.Party().fromString(party2).left().map((Function1 & Serializable & scala.Serializable)message -> $this.errorFactories.invalidArgument((Option<Object>)some, (String)message, contextualizedErrorLogger)).map((Function1)Value.ValueParty$.MODULE$);
        } else if (sum instanceof Value.Sum$.Bool) {
            Value.Sum$.Bool bool = (Value.Sum$.Bool)sum;
            boolean b = bool.value();
            either = package$.MODULE$.Right().apply((Object)Value.ValueBool$.MODULE$.apply(b));
        } else if (sum instanceof Value.Sum$.Timestamp) {
            Value.Sum$.Timestamp timestamp = (Value.Sum$.Timestamp)sum;
            long micros = timestamp.value();
            Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
            either = Time.Timestamp$.MODULE$.fromLong(micros).left().map((Function1 & Serializable & scala.Serializable)message -> $this.errorFactories.invalidArgument((Option<Object>)some, (String)message, contextualizedErrorLogger)).map((Function1)Value.ValueTimestamp$.MODULE$);
        } else if (sum instanceof Value.Sum$.Date) {
            Value.Sum$.Date date = (Value.Sum$.Date)sum;
            int days = date.value();
            Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
            either = Time.Date$.MODULE$.fromDaysSinceEpoch(days).left().map((Function1 & Serializable & scala.Serializable)message -> $this.errorFactories.invalidArgument((Option<Object>)some, (String)message, contextualizedErrorLogger)).map((Function1)Value.ValueDate$.MODULE$);
        } else if (sum instanceof Value.Sum$.Text) {
            Value.Sum$.Text text = (Value.Sum$.Text)sum;
            String text2 = text.value();
            either = package$.MODULE$.Right().apply((Object)new Value.ValueText(text2));
        } else if (sum instanceof Value.Sum$.Int64) {
            Value.Sum$.Int64 int64 = (Value.Sum$.Int64)sum;
            long value = int64.value();
            either = package$.MODULE$.Right().apply((Object)new Value.ValueInt64(value));
        } else if (sum instanceof Value.Sum$.Record) {
            Value.Sum$.Record record = (Value.Sum$.Record)sum;
            Record rec = record.value();
            either = this.validateRecord(rec, contextualizedErrorLogger);
        } else if (sum instanceof Value.Sum$.Variant && (variant2 = (variant = (Value.Sum$.Variant)sum).value()) != null) {
            Option variantId = variant2.variantId();
            String constructor = variant2.constructor();
            Option value = variant2.value();
            either = this.validateOptionalIdentifier((Option<Identifier>)variantId, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)validatedVariantId -> $this.fieldValidations.requireName(constructor, "constructor", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)validatedConstructor -> $this.fieldValidations.requirePresence(value, "value", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)v -> this.validateValue((Value)v, contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)validatedValue -> new Value.ValueVariant(validatedVariantId, validatedConstructor, validatedValue)))));
        } else if (sum instanceof Value.Sum$.Enum && (enum_2 = (enum_ = (Value.Sum$.Enum)sum).value()) != null) {
            Option enumId = enum_2.enumId();
            String value = enum_2.constructor();
            either = this.validateOptionalIdentifier((Option<Identifier>)enumId, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)validatedEnumId -> $this.fieldValidations.requireName(value, "value", contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)validatedValue -> new Value.ValueEnum(validatedEnumId, validatedValue)));
        } else if (sum instanceof Value.Sum$.List && (list2 = (list = (Value.Sum$.List)sum).value()) != null) {
            Seq elems = list2.elements();
            either = ((Either)elems.foldLeft((Object)package$.MODULE$.Right().apply((Object)BackStack$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(valuesE, v) -> valuesE.flatMap((Function1 & Serializable & scala.Serializable)values -> this.validateValue((Value)v, contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)validatedValue -> values.$colon$plus(validatedValue))))).map((Function1 & Serializable & scala.Serializable)elements -> new Value.ValueList(elements.toFrontStack()));
        } else if (sum instanceof Value.Sum$.Unit) {
            either = package$.MODULE$.Right().apply((Object)Value.ValueUnit$.MODULE$);
        } else if (sum instanceof Value.Sum$.Optional) {
            Value.Sum$.Optional optional = (Value.Sum$.Optional)sum;
            Optional o = optional.value();
            either = (Either)o.value().fold((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Right().apply((Object)Value$.MODULE$.ValueNone()), (Function1 & Serializable & scala.Serializable)x$5 -> this.validateValue((Value)x$5, contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)v -> new Value.ValueOptional((Option)new Some(v))));
        } else if (sum instanceof Value.Sum$.Map) {
            Value.Sum$.Map map = (Value.Sum$.Map)sum;
            Map map0 = map.value();
            Either map2 = (Either)map0.entries().foldLeft((Object)package$.MODULE$.Right().apply((Object)FrontStack$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Map.Entry entry;
                Either acc;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 == null) break block2;
                        acc = (Either)tuple2._1();
                        entry = (Map.Entry)tuple2._2();
                        if (entry != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                String key = entry.key();
                Option value0 = entry.value();
                Either either = acc.flatMap((Function1 & Serializable & scala.Serializable)tail -> $this.fieldValidations.requirePresence(value0, "value", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)v -> this.validateValue((Value)v, contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)validatedValue -> {
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), validatedValue);
                    return tail.$plus$colon((Object)tuple2);
                })));
                return either;
            });
            either = map2.flatMap((Function1 & Serializable & scala.Serializable)entries -> {
                Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
                return SortedLookupList$.MODULE$.fromImmArray(entries.toImmArray()).left().map((Function1 & Serializable & scala.Serializable)message -> $this.errorFactories.invalidArgument((Option<Object>)some, (String)message, contextualizedErrorLogger)).map((Function1 & Serializable & scala.Serializable)map -> new Value.ValueTextMap(map));
            });
        } else if (sum instanceof Value.Sum$.GenMap) {
            Value.Sum$.GenMap genMap = (Value.Sum$.GenMap)sum;
            GenMap genMap0 = genMap.value();
            Either genMap2 = (Either)genMap0.entries().foldLeft((Object)package$.MODULE$.Right().apply((Object)BackStack$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                GenMap.Entry entry;
                Either acc;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = new Tuple2(x0$2, x1$2);
                        if (tuple2 == null) break block2;
                        acc = (Either)tuple2._1();
                        entry = (GenMap.Entry)tuple2._2();
                        if (entry != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                Option key0 = entry.key();
                Option value0 = entry.value();
                Either either = acc.flatMap((Function1 & Serializable & scala.Serializable)stack -> $this.fieldValidations.requirePresence(key0, "key", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)key -> $this.fieldValidations.requirePresence(value0, "value", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)value -> this.validateValue((Value)key, contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)validatedKey -> this.validateValue((Value)value, contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)validatedValue -> stack.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(validatedKey), validatedValue)))))));
                return either;
            });
            either = genMap2.map((Function1 & Serializable & scala.Serializable)entries -> new Value.ValueGenMap(entries.toImmArray()));
        } else if (Value.Sum$.Empty$.MODULE$.equals(sum)) {
            either = package$.MODULE$.Left().apply((Object)this.errorFactories.missingField("value", (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger));
        } else {
            throw new MatchError((Object)sum);
        }
        return either;
    }

    public Either<StatusRuntimeException, Option<Ref.Identifier>> validateOptionalIdentifier(Option<Identifier> variantIdO, ContextualizedErrorLogger contextualizedErrorLogger) {
        return (Either)variantIdO.map((Function1 & Serializable & scala.Serializable)x$7 -> $this.fieldValidations.validateIdentifier((Identifier)x$7, contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)value -> new Some(value))).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Right().apply((Object)None$.MODULE$));
    }

    private final StatusRuntimeException err$1(String value$2, ContextualizedErrorLogger contextualizedErrorLogger$3) {
        return this.errorFactories.invalidArgument((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), new StringBuilder(32).append("Could not read Numeric string \"").append(value$2).append("\"").toString(), contextualizedErrorLogger$3);
    }

    public ValueValidator(ErrorFactories errorFactories, FieldValidations fieldValidations) {
        this.errorFactories = errorFactories;
        this.fieldValidations = fieldValidations;
        this.validNumericString = new StringOps(Predef$.MODULE$.augmentString("[+-]?\\d{1,38}(\\.\\d{0,37})?")).r().pattern();
    }
}

