/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.participant.util;

import com.daml.ledger.api.v1.event.ArchivedEvent;
import com.daml.ledger.api.v1.event.CreatedEvent;
import com.daml.ledger.api.v1.event.Event;
import com.daml.ledger.api.v1.event.ExercisedEvent;
import com.daml.ledger.api.v1.transaction.TreeEvent;
import com.daml.ledger.api.v1.value.Enum;
import com.daml.ledger.api.v1.value.GenMap;
import com.daml.ledger.api.v1.value.Identifier;
import com.daml.ledger.api.v1.value.Map;
import com.daml.ledger.api.v1.value.Optional;
import com.daml.ledger.api.v1.value.Optional$;
import com.daml.ledger.api.v1.value.Record;
import com.daml.ledger.api.v1.value.RecordField;
import com.daml.ledger.api.v1.value.Value;
import com.daml.ledger.api.v1.value.Variant;
import com.daml.lf.data.FrontStack;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.LawlessTraversals;
import com.daml.lf.data.LawlessTraversals$;
import com.daml.lf.data.Ref;
import com.daml.lf.data.SortedLookupList;
import com.daml.lf.data.Time;
import com.daml.lf.data.package$;
import com.daml.lf.ledger.EventId;
import com.daml.lf.transaction.Node;
import com.daml.lf.transaction.NodeId;
import com.daml.lf.value.Value;
import com.google.protobuf.empty.Empty;
import com.google.protobuf.empty.Empty$;
import com.google.protobuf.timestamp.Timestamp;
import com.google.protobuf.timestamp.Timestamp$;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class LfEngineToApi$ {
    public static LfEngineToApi$ MODULE$;

    static {
        new LfEngineToApi$();
    }

    public Identifier toApiIdentifier(Ref.Identifier identifier) {
        return new Identifier(identifier.packageId(), identifier.qualifiedName().module().toString(), identifier.qualifiedName().name().toString());
    }

    public Timestamp toTimestamp(Instant instant) {
        return new Timestamp(instant.getEpochSecond(), instant.getNano(), Timestamp$.MODULE$.apply$default$3());
    }

    public Either<String, Record> lfValueToApiRecord(boolean verbose, com.daml.lf.value.Value recordValue) {
        Left left;
        com.daml.lf.value.Value value = recordValue;
        if (value instanceof Value.ValueRecord) {
            Value.ValueRecord valueRecord = (Value.ValueRecord)value;
            Option tycon = valueRecord.tycon();
            ImmArray fields = valueRecord.fields();
            Either fs = (Either)fields.foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)scala.package$.MODULE$.Vector().empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Either either;
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null && (either = (Either)tuple2._1()) instanceof Left) {
                    Left left = (Left)either;
                    String e = (String)left.value();
                    return scala.package$.MODULE$.Left().apply((Object)e);
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Either either2 = (Either)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (!(either2 instanceof Right)) throw new MatchError((Object)tuple2);
                Right right = (Right)either2;
                Vector acc = (Vector)right.value();
                if (tuple22 == null) throw new MatchError((Object)tuple2);
                Option mbLabel = (Option)tuple22._1();
                com.daml.lf.value.Value value = (com.daml.lf.value.Value)tuple22._2();
                return MODULE$.lfValueToApiValue(verbose, value).map((Function1 & Serializable & scala.Serializable)v -> new RecordField(verbose ? (String)mbLabel.getOrElse((Function0 & Serializable & scala.Serializable)() -> "") : "", (Option)new Some(v))).map((Function1 & Serializable & scala.Serializable)x$1 -> (Vector)acc.$colon$plus(x$1, Vector$.MODULE$.canBuildFrom()));
            });
            None$ mbId = verbose ? tycon.map((Function1 & Serializable & scala.Serializable)identifier -> MODULE$.toApiIdentifier((Ref.Identifier)identifier)) : None$.MODULE$;
            left = fs.map(arg_0 -> LfEngineToApi$.$anonfun$lfValueToApiRecord$6((Option)mbId, arg_0));
        } else {
            left = scala.package$.MODULE$.Left().apply((Object)new StringBuilder(37).append("Expected value to be record, but got ").append(value).toString());
        }
        return left;
    }

    public Either<String, Option<Value>> lfValueToApiValue(boolean verbose, Option<com.daml.lf.value.Value> lf) {
        return (Either)lf.fold((Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Right().apply((Object)None$.MODULE$), (Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.lfValueToApiValue(verbose, (com.daml.lf.value.Value)x$3).map((Function1 & Serializable & scala.Serializable)x$4 -> new Some(x$4)));
    }

    public Either<String, Value> lfValueToApiValue(boolean verbose, com.daml.lf.value.Value value0) {
        Right right;
        com.daml.lf.value.Value value = value0;
        if (Value.ValueUnit$.MODULE$.equals(value)) {
            right = scala.package$.MODULE$.Right().apply((Object)new Value((Value.Sum)new Value.Sum$.Unit(new Empty(Empty$.MODULE$.apply$default$1()))));
        } else if (value instanceof Value.ValueNumeric) {
            Value.ValueNumeric valueNumeric = (Value.ValueNumeric)value;
            BigDecimal d = valueNumeric.value();
            right = scala.package$.MODULE$.Right().apply((Object)new Value((Value.Sum)new Value.Sum$.Numeric(package$.MODULE$.Numeric().toString(d))));
        } else if (value instanceof Value.ValueContractId) {
            Value.ValueContractId valueContractId = (Value.ValueContractId)value;
            Value.ContractId c = valueContractId.value();
            right = scala.package$.MODULE$.Right().apply((Object)new Value((Value.Sum)new Value.Sum$.ContractId(c.coid())));
        } else if (value instanceof Value.ValueBool) {
            Value.ValueBool valueBool = (Value.ValueBool)value;
            boolean b = valueBool.value();
            right = scala.package$.MODULE$.Right().apply((Object)new Value((Value.Sum)new Value.Sum$.Bool(b)));
        } else if (value instanceof Value.ValueDate) {
            Value.ValueDate valueDate = (Value.ValueDate)value;
            Time.Date d = valueDate.value();
            right = scala.package$.MODULE$.Right().apply((Object)new Value((Value.Sum)new Value.Sum$.Date(d.days())));
        } else if (value instanceof Value.ValueTimestamp) {
            Value.ValueTimestamp valueTimestamp = (Value.ValueTimestamp)value;
            Time.Timestamp t = valueTimestamp.value();
            right = scala.package$.MODULE$.Right().apply((Object)new Value((Value.Sum)new Value.Sum$.Timestamp(t.micros())));
        } else if (value instanceof Value.ValueInt64) {
            Value.ValueInt64 valueInt64 = (Value.ValueInt64)value;
            long i = valueInt64.value();
            right = scala.package$.MODULE$.Right().apply((Object)new Value((Value.Sum)new Value.Sum$.Int64(i)));
        } else if (value instanceof Value.ValueParty) {
            Value.ValueParty valueParty = (Value.ValueParty)value;
            String p = valueParty.value();
            right = scala.package$.MODULE$.Right().apply((Object)new Value((Value.Sum)new Value.Sum$.Party(p)));
        } else if (value instanceof Value.ValueText) {
            Value.ValueText valueText = (Value.ValueText)value;
            String t = valueText.value();
            right = scala.package$.MODULE$.Right().apply((Object)new Value((Value.Sum)new Value.Sum$.Text(t)));
        } else if (value instanceof Value.ValueOptional) {
            Value.ValueOptional valueOptional = (Value.ValueOptional)value;
            Option o = valueOptional.value();
            right = (Either)o.fold((Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Right().apply((Object)new Value((Value.Sum)new Value.Sum$.Optional(Optional$.MODULE$.defaultInstance()))), (Function1 & Serializable & scala.Serializable)v -> MODULE$.lfValueToApiValue(verbose, (com.daml.lf.value.Value)v).map((Function1 & Serializable & scala.Serializable)c -> new Value((Value.Sum)new Value.Sum$.Optional(new Optional((Option)new Some(c))))));
        } else if (value instanceof Value.ValueTextMap) {
            Value.ValueTextMap valueTextMap = (Value.ValueTextMap)value;
            SortedLookupList m = valueTextMap.value();
            right = ((Either)m.toImmArray().reverse().foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)List$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Either either = (Either)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        List list = (List)right.value();
                        if (tuple22 != null) {
                            String k = (String)tuple22._1();
                            com.daml.lf.value.Value v = (com.daml.lf.value.Value)tuple22._2();
                            return MODULE$.lfValueToApiValue(verbose, v).map((Function1 & Serializable & scala.Serializable)w -> {
                                Map.Entry entry = new Map.Entry(k, (Option)new Some(w));
                                return list.$colon$colon((Object)entry);
                            });
                        }
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Either left = (Either)tuple2._1();
                return left;
            })).map((Function1 & Serializable & scala.Serializable)list -> new Value((Value.Sum)new Value.Sum$.Map(new Map((Seq)list))));
        } else if (value instanceof Value.ValueGenMap) {
            Value.ValueGenMap valueGenMap = (Value.ValueGenMap)value;
            ImmArray entries = valueGenMap.entries();
            right = ((Either)entries.reverseIterator().foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)List$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                Tuple2 tuple2;
                Either acc;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$2, x1$2);
                        if (tuple22 == null) break block2;
                        acc = (Either)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                com.daml.lf.value.Value k = (com.daml.lf.value.Value)tuple2._1();
                com.daml.lf.value.Value v = (com.daml.lf.value.Value)tuple2._2();
                Either either = acc.flatMap((Function1 & Serializable & scala.Serializable)tail -> MODULE$.lfValueToApiValue(verbose, k).flatMap((Function1 & Serializable & scala.Serializable)key -> MODULE$.lfValueToApiValue(verbose, v).map((Function1 & Serializable & scala.Serializable)value -> {
                    GenMap.Entry entry = new GenMap.Entry((Option)new Some(key), (Option)new Some(value));
                    return tail.$colon$colon((Object)entry);
                })));
                return either;
            })).map((Function1 & Serializable & scala.Serializable)list -> new Value((Value.Sum)new Value.Sum$.GenMap(new GenMap((Seq)list))));
        } else if (value instanceof Value.ValueList) {
            Value.ValueList valueList = (Value.ValueList)value;
            FrontStack vs = valueList.values();
            right = LawlessTraversals.Lawless$u0020iterable$u0020traversal$.MODULE$.traverseEitherStrictly$extension(LawlessTraversals$.MODULE$.Lawless$u0020iterable$u0020traversal((IterableLike)vs.toImmArray().toSeq()), (Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.lfValueToApiValue(verbose, (com.daml.lf.value.Value)x$7), ImmArray.ImmArraySeq$.MODULE$.canBuildFrom()).map((Function1 & Serializable & scala.Serializable)xs -> new Value((Value.Sum)new Value.Sum$.List(new com.daml.ledger.api.v1.value.List((Seq)xs))));
        } else if (value instanceof Value.ValueVariant) {
            Value.ValueVariant valueVariant = (Value.ValueVariant)value;
            Option tycon = valueVariant.tycon();
            String variant = valueVariant.variant();
            com.daml.lf.value.Value v2 = valueVariant.value();
            right = this.lfValueToApiValue(verbose, v2).map((Function1 & Serializable & scala.Serializable)x -> new Value((Value.Sum)new Value.Sum$.Variant(new Variant(tycon.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)verbose)).map((Function1 & Serializable & scala.Serializable)identifier -> MODULE$.toApiIdentifier((Ref.Identifier)identifier)), variant, (Option)new Some(x)))));
        } else if (value instanceof Value.ValueEnum) {
            Value.ValueEnum valueEnum = (Value.ValueEnum)value;
            Option tyCon = valueEnum.tycon();
            String value2 = valueEnum.value();
            right = scala.package$.MODULE$.Right().apply((Object)new Value((Value.Sum)new Value.Sum$.Enum(new Enum(tyCon.filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)verbose)).map((Function1 & Serializable & scala.Serializable)identifier -> MODULE$.toApiIdentifier((Ref.Identifier)identifier)), value2))));
        } else if (value instanceof Value.ValueRecord) {
            Value.ValueRecord valueRecord = (Value.ValueRecord)value;
            Option tycon = valueRecord.tycon();
            ImmArray fields = valueRecord.fields();
            right = LawlessTraversals.Lawless$u0020iterable$u0020traversal$.MODULE$.traverseEitherStrictly$extension(LawlessTraversals$.MODULE$.Lawless$u0020iterable$u0020traversal((IterableLike)fields.toSeq()), (Function1 & Serializable & scala.Serializable)field -> MODULE$.lfValueToApiValue(verbose, (com.daml.lf.value.Value)field._2()).map((Function1 & Serializable & scala.Serializable)x -> new RecordField(verbose ? (String)((Option)field._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "") : "", (Option)new Some(x))), ImmArray.ImmArraySeq$.MODULE$.canBuildFrom()).map((Function1 & Serializable & scala.Serializable)apiFields -> new Value((Value.Sum)new Value.Sum$.Record(new Record((Option)(verbose ? tycon.map((Function1 & Serializable & scala.Serializable)identifier -> MODULE$.toApiIdentifier((Ref.Identifier)identifier)) : None$.MODULE$), (Seq)apiFields))));
        } else {
            throw new MatchError((Object)value);
        }
        return right;
    }

    public Either<String, Value> lfContractKeyToApiValue(boolean verbose, Node.KeyWithMaintainers lf) {
        return this.lfValueToApiValue(verbose, lf.key());
    }

    public Either<String, Option<Value>> lfContractKeyToApiValue(boolean verbose, Option<Node.KeyWithMaintainers> lf) {
        return (Either)lf.fold((Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Right().apply((Object)None$.MODULE$), (Function1 & Serializable & scala.Serializable)x$10 -> MODULE$.lfContractKeyToApiValue(verbose, (Node.KeyWithMaintainers)x$10).map((Function1 & Serializable & scala.Serializable)x$11 -> new Some(x$11)));
    }

    public Either<String, Event> lfNodeCreateToEvent(boolean verbose, String trId, NodeId nodeId, Node.Create node) {
        return this.lfValueToApiRecord(verbose, node.arg()).flatMap((Function1 & Serializable & scala.Serializable)arg -> MODULE$.lfContractKeyToApiValue(verbose, (Option<Node.KeyWithMaintainers>)node.key()).map((Function1 & Serializable & scala.Serializable)key -> new Event((Event.Event)new Event.Event$.Created(new CreatedEvent(new EventId(trId, nodeId).toLedgerString(), node.coid().coid(), (Option)new Some((Object)MODULE$.toApiIdentifier(node.templateId())), key, (Option)new Some(arg), node.stakeholders().toSeq(), node.signatories().toSeq(), node.stakeholders().diff((GenSet)node.signatories()).toSeq(), (Option)new Some((Object)node.agreementText()))))));
    }

    public Either<String, Event> lfNodeExercisesToEvent(String trId, NodeId nodeId, Node.Exercise node) {
        return scala.package$.MODULE$.Either().cond(node.consuming(), (Function0 & Serializable & scala.Serializable)() -> new Event((Event.Event)new Event.Event$.Archived(new ArchivedEvent(new EventId(trId, nodeId).toLedgerString(), node.targetCoid().coid(), (Option)new Some((Object)MODULE$.toApiIdentifier(node.templateId())), node.stakeholders().toSeq()))), (Function0 & Serializable & scala.Serializable)() -> "illegal conversion of non-consuming exercise to archived event");
    }

    public Either<String, TreeEvent> lfNodeCreateToTreeEvent(boolean verbose, EventId eventId, Set<String> witnessParties, Node.Create node) {
        return this.lfValueToApiRecord(verbose, node.arg()).flatMap((Function1 & Serializable & scala.Serializable)arg -> MODULE$.lfContractKeyToApiValue(verbose, (Option<Node.KeyWithMaintainers>)node.key()).map((Function1 & Serializable & scala.Serializable)key -> new TreeEvent((TreeEvent.Kind)new TreeEvent.Kind$.Created(new CreatedEvent(eventId.toLedgerString(), node.coid().coid(), (Option)new Some((Object)MODULE$.toApiIdentifier(node.templateId())), key, (Option)new Some(arg), witnessParties.toSeq(), node.signatories().toSeq(), node.stakeholders().diff((GenSet)node.signatories()).toSeq(), (Option)new Some((Object)node.agreementText()))))));
    }

    public Either<String, TreeEvent> lfNodeExercisesToTreeEvent(boolean verbose, String trId, EventId eventId, Set<String> witnessParties, Node.Exercise node, Function1<NodeId, Object> filterChildren) {
        return this.lfValueToApiValue(verbose, node.chosenValue()).flatMap((Function1 & Serializable & scala.Serializable)arg -> MODULE$.lfValueToApiValue(verbose, (Option<com.daml.lf.value.Value>)node.exerciseResult()).map((Function1 & Serializable & scala.Serializable)result -> new TreeEvent((TreeEvent.Kind)new TreeEvent.Kind$.Exercised(new ExercisedEvent(eventId.toLedgerString(), node.targetCoid().coid(), (Option)new Some((Object)MODULE$.toApiIdentifier(node.templateId())), node.choiceId(), (Option)new Some(arg), node.actingParties().toSeq(), node.consuming(), witnessParties.toSeq(), node.children().iterator().filter(filterChildren).map((Function1 & Serializable & scala.Serializable)x$12 -> new EventId(trId, x$12).toLedgerString()).toSeq(), result)))));
    }

    public <A> A assertOrRuntimeEx(String failureContext, Either<String, A> ea) throws RuntimeException {
        return (A)ea.fold((Function1 & Serializable & scala.Serializable)e -> {
            throw new RuntimeException(new StringBuilder(24).append("Unexpected error when ").append(failureContext).append(": ").append((String)e).toString());
        }, (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x));
    }

    public static final /* synthetic */ Record $anonfun$lfValueToApiRecord$6(Option mbId$1, Vector x$2) {
        return new Record(mbId$1, (Seq)x$2);
    }

    private LfEngineToApi$() {
        MODULE$ = this;
    }
}

