/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.server.api.services.grpc;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.ErrorCodesVersionSwitcher;
import com.daml.ledger.api.SubmissionIdGenerator;
import com.daml.ledger.api.v1.command_service.CommandServiceGrpc;
import com.daml.ledger.api.v1.command_service.CommandServiceGrpc$;
import com.daml.ledger.api.v1.command_service.CommandServiceGrpc$CommandService$;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionIdResponse;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionResponse;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitForTransactionTreeResponse;
import com.daml.ledger.api.v1.command_service.SubmitAndWaitRequest;
import com.daml.ledger.api.v1.commands.Commands;
import com.daml.ledger.api.validation.CommandsValidator;
import com.daml.ledger.api.validation.SubmitAndWaitRequestValidator;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.server.api.ProxyCloseable;
import com.daml.platform.server.api.ValidationLogger$;
import com.daml.platform.server.api.validation.ErrorFactories$;
import com.daml.platform.server.api.validation.FieldValidations$;
import com.google.protobuf.empty.Empty;
import io.grpc.ServerServiceDefinition;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\f\u0019\u0001\u001dB\u0001\"\u0016\u0001\u0003\u0006\u0004%\tB\u0016\u0005\tE\u0002\u0011\t\u0011)A\u0005/\"A1\r\u0001BC\u0002\u0013\u0005A\r\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003f\u0011!i\u0007A!A!\u0002\u0013q\u0007\u0002\u0003;\u0001\u0005\u0003\u0005\u000b\u0011B;\t\u0011y\u0004!\u0011!Q\u0001\nUD\u0011b \u0001\u0003\u0002\u0003\u0006I!!\u0001\t\u0015\u0005=\u0001A!A!\u0002\u0013\t\t\u0002\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0006\u00037A!\"a\n\u0001\u0005\u0003\u0005\u000b1BA\u0015\u0011\u001d\t)\u0004\u0001C\u0001\u0003oA\u0011\"!\u0016\u0001\u0005\u0004%\u0019\"a\u0016\t\u0011\u0005}\u0003\u0001)A\u0005\u00033B\u0001\"!\u0019\u0001A\u0003%\u00111\r\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\tI\n\u0001C!\u00037Cq!a*\u0001\t\u0003\nI\u000bC\u0004\u00026\u0002!\t%a.\t\u000f\u0005\r\u0007\u0001\"\u0011\u0002F\"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0007bBAn\u0001\u0011%\u0011Q\u001c\u0002\u0013\u000fJ\u00048mQ8n[\u0006tGmU3sm&\u001cWM\u0003\u0002\u001a5\u0005!qM\u001d9d\u0015\tYB$\u0001\u0005tKJ4\u0018nY3t\u0015\tib$A\u0002ba&T!a\b\u0011\u0002\rM,'O^3s\u0015\t\t#%\u0001\u0005qY\u0006$hm\u001c:n\u0015\t\u0019C%\u0001\u0003eC6d'\"A\u0013\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001AcfS)\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g!\ty\u0003J\u0004\u00021\u000b:\u0011\u0011G\u0011\b\u0003e}r!aM\u001f\u000f\u0005QZdBA\u001b;\u001d\t1\u0014(D\u00018\u0015\tAd%\u0001\u0004=e>|GOP\u0005\u0002K%\u00111\u0005J\u0005\u0003y\t\na\u0001\\3eO\u0016\u0014\u0018BA\u000f?\u0015\ta$%\u0003\u0002A\u0003\u0006\u0011a/\r\u0006\u0003;yJ!a\u0011#\u0002\u001f\r|W.\\1oI~\u001bXM\u001d<jG\u0016T!\u0001Q!\n\u0005\u0019;\u0015AE\"p[6\fg\u000eZ*feZL7-Z$sa\u000eT!a\u0011#\n\u0005%S%AD\"p[6\fg\u000eZ*feZL7-\u001a\u0006\u0003\r\u001e\u0003\"\u0001T(\u000e\u00035S!!\u0007(\u000b\u0005u\u0001\u0013B\u0001)N\u000599%\u000f]2Ba&\u001cVM\u001d<jG\u0016\u0004\"AU*\u000e\u0003qI!\u0001\u0016\u000f\u0003\u001dA\u0013x\u000e_=DY>\u001cX-\u00192mK\u000691/\u001a:wS\u000e,W#A,\u0013\u0007as#L\u0002\u0003Z\u0001\u00019&\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004CA.a\u001b\u0005a&BA/_\u0003\u0011a\u0017M\\4\u000b\u0003}\u000bAA[1wC&\u0011\u0011\r\u0018\u0002\u000e\u0003V$xn\u00117pg\u0016\f'\r\\3\u0002\u0011M,'O^5dK\u0002\n\u0001\u0002\\3eO\u0016\u0014\u0018\nZ\u000b\u0002KB\u0011a-\u001b\b\u0003e\u001dL!\u0001[!\u0002\r\u0011|W.Y5o\u0013\tQ7N\u0001\u0005MK\u0012<WM]%e\u0015\tA\u0017)A\u0005mK\u0012<WM]%eA\u0005IRM\u001d:pe\u000e{G-Z:WKJ\u001c\u0018n\u001c8To&$8\r[3s!\ty'/D\u0001q\u0015\t\t(%A\u0003feJ|'/\u0003\u0002ta\nIRI\u001d:pe\u000e{G-Z:WKJ\u001c\u0018n\u001c8To&$8\r[3s\u0003E\u0019WO\u001d:f]RdU\rZ4feRKW.\u001a\t\u0004SYD\u0018BA<+\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002zy6\t!P\u0003\u0002|=\u0006!A/[7f\u0013\ti(PA\u0004J]N$\u0018M\u001c;\u0002\u001d\r,(O]3oiV#8\rV5nK\u0006!R.\u0019=EK\u0012,\b\u000f\\5dCRLwN\u001c+j[\u0016\u0004B!\u000b<\u0002\u0004A)\u0011&!\u0002\u0002\n%\u0019\u0011q\u0001\u0016\u0003\r=\u0003H/[8o!\rI\u00181B\u0005\u0004\u0003\u001bQ(\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002)\u001d,g.\u001a:bi\u0016\u001cVOY7jgNLwN\\%e!\u0011\t\u0019\"!\u0006\u000e\u0003\u0005K1!a\u0006B\u0005U\u0019VOY7jgNLwN\\%e\u000f\u0016tWM]1u_J\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t+\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003K\tyB\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006qAn\\4hS:<7i\u001c8uKb$\b\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\"%A\u0004m_\u001e<\u0017N\\4\n\t\u0005M\u0012Q\u0006\u0002\u000f\u0019><w-\u001b8h\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0001\u0012\u0011HA\"\u0003\u0013\nY%!\u0014\u0002P\u0005E\u00131\u000b\u000b\u0007\u0003w\ty$!\u0011\u0011\u0007\u0005u\u0002!D\u0001\u0019\u0011\u001d\tI\u0002\u0004a\u0002\u00037Aq!a\n\r\u0001\b\tI\u0003\u0003\u0004V\u0019\u0001\u0007\u0011Q\t\n\u0005\u0003\u000fr#LB\u0003Z\u0001\u0001\t)\u0005C\u0003d\u0019\u0001\u0007Q\rC\u0003n\u0019\u0001\u0007a\u000eC\u0003u\u0019\u0001\u0007Q\u000fC\u0003\u007f\u0019\u0001\u0007Q\u000f\u0003\u0004\u0000\u0019\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u001fa\u0001\u0019AA\t\u0003\u0019awnZ4feV\u0011\u0011\u0011\f\t\u0005\u0003W\tY&\u0003\u0003\u0002^\u00055\"\u0001F\"p]R,\u0007\u0010^;bY&TX\r\u001a'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0013Y\fG.\u001b3bi>\u0014\b\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%\u0014)\u0001\u0006wC2LG-\u0019;j_:LA!!\u001c\u0002h\ti2+\u001e2nSR\fe\u000eZ,bSR\u0014V-];fgR4\u0016\r\\5eCR|'/A\u0007tk\nl\u0017\u000e^!oI^\u000b\u0017\u000e\u001e\u000b\u0005\u0003g\ni\t\u0005\u0004\u0002\u001e\u0005U\u0014\u0011P\u0005\u0005\u0003o\nyB\u0001\u0004GkR,(/\u001a\t\u0005\u0003w\nI)\u0004\u0002\u0002~)!\u0011qPAA\u0003\u0015)W\u000e\u001d;z\u0015\u0011\t\u0019)!\"\u0002\u0011A\u0014x\u000e^8ck\u001aT1!a\"%\u0003\u00199wn\\4mK&!\u00111RA?\u0005\u0015)U\u000e\u001d;z\u0011\u001d\ty\t\u0005a\u0001\u0003#\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002\u0014\u0006UU\"A$\n\u0007\u0005]uI\u0001\u000bTk\nl\u0017\u000e^!oI^\u000b\u0017\u000e\u001e*fcV,7\u000f^\u0001\u001egV\u0014W.\u001b;B]\u0012<\u0016-\u001b;G_J$&/\u00198tC\u000e$\u0018n\u001c8JIR!\u0011QTAS!\u0019\ti\"!\u001e\u0002 B!\u00111SAQ\u0013\r\t\u0019k\u0012\u0002&'V\u0014W.\u001b;B]\u0012<\u0016-\u001b;G_J$&/\u00198tC\u000e$\u0018n\u001c8JIJ+7\u000f]8og\u0016Dq!a$\u0012\u0001\u0004\t\t*A\u000etk\nl\u0017\u000e^!oI^\u000b\u0017\u000e\u001e$peR\u0013\u0018M\\:bGRLwN\u001c\u000b\u0005\u0003W\u000b\u0019\f\u0005\u0004\u0002\u001e\u0005U\u0014Q\u0016\t\u0005\u0003'\u000by+C\u0002\u00022\u001e\u00131eU;c[&$\u0018I\u001c3XC&$hi\u001c:Ue\u0006t7/Y2uS>t'+Z:q_:\u001cX\rC\u0004\u0002\u0010J\u0001\r!!%\u0002?M,(-\\5u\u0003:$w+Y5u\r>\u0014HK]1og\u0006\u001cG/[8o)J,W\r\u0006\u0003\u0002:\u0006\u0005\u0007CBA\u000f\u0003k\nY\f\u0005\u0003\u0002\u0014\u0006u\u0016bAA`\u000f\n93+\u001e2nSR\fe\u000eZ,bSR4uN\u001d+sC:\u001c\u0018m\u0019;j_:$&/Z3SKN\u0004xN\\:f\u0011\u001d\tyi\u0005a\u0001\u0003#\u000b1BY5oIN+'O^5dKR\u0011\u0011q\u0019\t\u0005\u0003\u0013\f\t.\u0004\u0002\u0002L*\u0019\u0011$!4\u000b\u0005\u0005=\u0017AA5p\u0013\u0011\t\u0019.a3\u0003/M+'O^3s'\u0016\u0014h/[2f\t\u00164\u0017N\\5uS>t\u0017aG4f]\u0016\u0014\u0018\r^3Tk\nl\u0017n]:j_:LE-\u00134F[B$\u0018\u0010\u0006\u0003\u0002\u0012\u0006e\u0007bBAH+\u0001\u0007\u0011\u0011S\u0001\u001aG>tG/\u001a=uk\u0006d\u0017N_3e\u000bJ\u0014xN\u001d'pO\u001e,'\u000f\u0006\u0003\u0002`\u0006%H\u0003BAq\u0003O\u00042a\\Ar\u0013\r\t)\u000f\u001d\u0002\u001e\t\u0006lGnQ8oi\u0016DH/^1mSj,G-\u0012:s_JdunZ4fe\"9\u0011q\u0005\fA\u0004\u0005%\u0002bBAH-\u0001\u0007\u0011\u0011\u0013")
public class GrpcCommandService
implements CommandServiceGrpc.CommandService,
GrpcApiService,
ProxyCloseable {
    private final CommandServiceGrpc.CommandService service;
    private final Object ledgerId;
    private final Function0<Instant> currentLedgerTime;
    private final Function0<Instant> currentUtcTime;
    private final Function0<Option<Duration>> maxDeduplicationTime;
    private final SubmissionIdGenerator generateSubmissionId;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final SubmitAndWaitRequestValidator validator;

    @Override
    public void close() {
        ProxyCloseable.close$(this);
    }

    public CommandServiceGrpc$CommandService$ serviceCompanion() {
        return CommandServiceGrpc.CommandService.serviceCompanion$((CommandServiceGrpc.CommandService)this);
    }

    public CommandServiceGrpc.CommandService service() {
        return this.service;
    }

    public Object ledgerId() {
        return this.ledgerId;
    }

    public ContextualizedLogger logger() {
        return this.logger;
    }

    public Future<Empty> submitAndWait(SubmitAndWaitRequest request) {
        SubmitAndWaitRequest requestWithSubmissionId = this.generateSubmissionIdIfEmpty(request);
        return (Future)this.validator.validate(requestWithSubmissionId, (Instant)this.currentLedgerTime.apply(), (Instant)this.currentUtcTime.apply(), (Option<Duration>)((Option)this.maxDeduplicationTime.apply()), (ContextualizedErrorLogger)this.contextualizedErrorLogger(requestWithSubmissionId, this.loggingContext)).fold((Function1 & Serializable & scala.Serializable)t -> Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure(requestWithSubmissionId, (Throwable)t, this.logger(), $this.loggingContext)), (Function1 & Serializable & scala.Serializable)x$1 -> this.service().submitAndWait(requestWithSubmissionId));
    }

    public Future<SubmitAndWaitForTransactionIdResponse> submitAndWaitForTransactionId(SubmitAndWaitRequest request) {
        SubmitAndWaitRequest requestWithSubmissionId = this.generateSubmissionIdIfEmpty(request);
        return (Future)this.validator.validate(requestWithSubmissionId, (Instant)this.currentLedgerTime.apply(), (Instant)this.currentUtcTime.apply(), (Option<Duration>)((Option)this.maxDeduplicationTime.apply()), (ContextualizedErrorLogger)this.contextualizedErrorLogger(requestWithSubmissionId, this.loggingContext)).fold((Function1 & Serializable & scala.Serializable)t -> Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure(requestWithSubmissionId, (Throwable)t, this.logger(), $this.loggingContext)), (Function1 & Serializable & scala.Serializable)x$2 -> this.service().submitAndWaitForTransactionId(requestWithSubmissionId));
    }

    public Future<SubmitAndWaitForTransactionResponse> submitAndWaitForTransaction(SubmitAndWaitRequest request) {
        SubmitAndWaitRequest requestWithSubmissionId = this.generateSubmissionIdIfEmpty(request);
        return (Future)this.validator.validate(requestWithSubmissionId, (Instant)this.currentLedgerTime.apply(), (Instant)this.currentUtcTime.apply(), (Option<Duration>)((Option)this.maxDeduplicationTime.apply()), (ContextualizedErrorLogger)this.contextualizedErrorLogger(requestWithSubmissionId, this.loggingContext)).fold((Function1 & Serializable & scala.Serializable)t -> Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure(requestWithSubmissionId, (Throwable)t, this.logger(), $this.loggingContext)), (Function1 & Serializable & scala.Serializable)x$3 -> this.service().submitAndWaitForTransaction(requestWithSubmissionId));
    }

    public Future<SubmitAndWaitForTransactionTreeResponse> submitAndWaitForTransactionTree(SubmitAndWaitRequest request) {
        SubmitAndWaitRequest requestWithSubmissionId = this.generateSubmissionIdIfEmpty(request);
        return (Future)this.validator.validate(requestWithSubmissionId, (Instant)this.currentLedgerTime.apply(), (Instant)this.currentUtcTime.apply(), (Option<Duration>)((Option)this.maxDeduplicationTime.apply()), (ContextualizedErrorLogger)this.contextualizedErrorLogger(requestWithSubmissionId, this.loggingContext)).fold((Function1 & Serializable & scala.Serializable)t -> Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure(requestWithSubmissionId, (Throwable)t, this.logger(), $this.loggingContext)), (Function1 & Serializable & scala.Serializable)x$4 -> this.service().submitAndWaitForTransactionTree(requestWithSubmissionId));
    }

    public ServerServiceDefinition bindService() {
        return CommandServiceGrpc$.MODULE$.bindService((CommandServiceGrpc.CommandService)this, this.executionContext);
    }

    private SubmitAndWaitRequest generateSubmissionIdIfEmpty(SubmitAndWaitRequest request) {
        SubmitAndWaitRequest submitAndWaitRequest;
        if (request.commands().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)GrpcCommandService.$anonfun$generateSubmissionIdIfEmpty$1(x$5)))) {
            Option commandsWithSubmissionId = request.commands().map((Function1 & Serializable & scala.Serializable)x$6 -> {
                String x$1 = $this.generateSubmissionId.generate();
                String x$2 = x$6.copy$default$1();
                String x$3 = x$6.copy$default$2();
                String x$4 = x$6.copy$default$3();
                String x$5 = x$6.copy$default$4();
                String x$62 = x$6.copy$default$5();
                Seq x$7 = x$6.copy$default$6();
                Commands.DeduplicationPeriod x$8 = x$6.copy$default$7();
                Option x$9 = x$6.copy$default$8();
                Option x$10 = x$6.copy$default$9();
                Seq x$11 = x$6.copy$default$10();
                Seq x$12 = x$6.copy$default$11();
                return x$6.copy(x$2, x$3, x$4, x$5, x$62, x$7, x$8, x$9, x$10, x$11, x$12, x$1);
            });
            submitAndWaitRequest = request.copy(commandsWithSubmissionId);
        } else {
            submitAndWaitRequest = request;
        }
        return submitAndWaitRequest;
    }

    private DamlContextualizedErrorLogger contextualizedErrorLogger(SubmitAndWaitRequest request, LoggingContext loggingContext) {
        return new DamlContextualizedErrorLogger(this.logger(), loggingContext, request.commands().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.submissionId()));
    }

    public static final /* synthetic */ boolean $anonfun$generateSubmissionIdIfEmpty$1(Commands x$5) {
        return x$5.submissionId().isEmpty();
    }

    public GrpcCommandService(CommandServiceGrpc.CommandService service, Object ledgerId, ErrorCodesVersionSwitcher errorCodesVersionSwitcher, Function0<Instant> currentLedgerTime, Function0<Instant> currentUtcTime, Function0<Option<Duration>> maxDeduplicationTime, SubmissionIdGenerator generateSubmissionId, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.service = service;
        this.ledgerId = ledgerId;
        this.currentLedgerTime = currentLedgerTime;
        this.currentUtcTime = currentUtcTime;
        this.maxDeduplicationTime = maxDeduplicationTime;
        this.generateSubmissionId = generateSubmissionId;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        CommandServiceGrpc.CommandService.$init$((CommandServiceGrpc.CommandService)this);
        ProxyCloseable.$init$(this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.validator = new SubmitAndWaitRequestValidator(new CommandsValidator(ledgerId, errorCodesVersionSwitcher), FieldValidations$.MODULE$.apply(ErrorFactories$.MODULE$.apply(errorCodesVersionSwitcher)));
    }
}

