/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.server.api.services.grpc;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.ErrorCodesVersionSwitcher;
import com.daml.ledger.api.SubmissionIdGenerator;
import com.daml.ledger.api.messages.command.submission.SubmitRequest;
import com.daml.ledger.api.v1.command_submission_service.CommandSubmissionServiceGrpc;
import com.daml.ledger.api.v1.command_submission_service.CommandSubmissionServiceGrpc$;
import com.daml.ledger.api.v1.command_submission_service.CommandSubmissionServiceGrpc$CommandSubmissionService$;
import com.daml.ledger.api.v1.command_submission_service.SubmitRequest$;
import com.daml.ledger.api.v1.commands.Commands;
import com.daml.ledger.api.v1.commands.Commands$;
import com.daml.ledger.api.validation.CommandsValidator;
import com.daml.ledger.api.validation.SubmitRequestValidator;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.metrics.Timed$;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.server.api.ProxyCloseable;
import com.daml.platform.server.api.ValidationLogger$;
import com.daml.platform.server.api.services.domain.CommandSubmissionService;
import com.daml.platform.server.api.validation.ErrorFactories$;
import com.daml.platform.server.api.validation.FieldValidations$;
import com.daml.telemetry.DefaultTelemetry$;
import com.daml.telemetry.SpanAttribute$;
import com.daml.telemetry.TelemetryContext;
import com.google.protobuf.empty.Empty;
import com.google.protobuf.empty.Empty$;
import io.grpc.ServerServiceDefinition;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001\u0002\u000b\u0016\u0001\u0011B\u0001B\u0015\u0001\u0003\u0006\u0004%\tf\u0015\u0005\tI\u0002\u0011\t\u0011)A\u0005)\"AQ\r\u0001B\u0001B\u0003%a\r\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003n\u0011!1\bA!A!\u0002\u0013i\u0007\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0013}\u0004!\u0011!Q\u0001\n\u0005\u0005\u0001BCA\u0005\u0001\t\u0005\t\u0015!\u0003\u0002\f!Q\u0011Q\u0003\u0001\u0003\u0002\u0003\u0006I!a\u0006\t\u0015\u0005\r\u0002A!A!\u0002\u0017\t)\u0003\u0003\u0006\u00022\u0001\u0011\t\u0011)A\u0006\u0003gAq!a\u0010\u0001\t\u0003\t\t\u0005C\u0005\u0002b\u0001\u0011\r\u0011b\u0005\u0002d!A\u00111\u000e\u0001!\u0002\u0013\t)\u0007C\u0005\u0002n\u0001\u0011\r\u0011\"\u0003\u0002p!A\u0011Q\u0010\u0001!\u0002\u0013\t\t\bC\u0004\u0002\u0000\u0001!\t%!!\t\u000f\u0005%\u0006\u0001\"\u0011\u0002,\"9\u00111\u0018\u0001\u0005\n\u0005u&\u0001H$sa\u000e\u001cu.\\7b]\u0012\u001cVOY7jgNLwN\\*feZL7-\u001a\u0006\u0003-]\tAa\u001a:qG*\u0011\u0001$G\u0001\tg\u0016\u0014h/[2fg*\u0011!dG\u0001\u0004CBL'B\u0001\u000f\u001e\u0003\u0019\u0019XM\u001d<fe*\u0011adH\u0001\ta2\fGOZ8s[*\u0011\u0001%I\u0001\u0005I\u0006lGNC\u0001#\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001Qe\u000b%M!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fMB\u0011A&\u0012\b\u0003[\ts!AL \u000f\u0005=bdB\u0001\u0019;\u001d\t\t\u0004H\u0004\u00023o9\u00111GN\u0007\u0002i)\u0011QgI\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ!\u0001I\u0011\n\u0005ez\u0012A\u00027fI\u001e,'/\u0003\u0002\u001bw)\u0011\u0011hH\u0005\u0003{y\n!A^\u0019\u000b\u0005iY\u0014B\u0001!B\u0003i\u0019w.\\7b]\u0012|6/\u001e2nSN\u001c\u0018n\u001c8`g\u0016\u0014h/[2f\u0015\tid(\u0003\u0002D\t\u0006a2i\\7nC:$7+\u001e2nSN\u001c\u0018n\u001c8TKJ4\u0018nY3HeB\u001c'B\u0001!B\u0013\t1uI\u0001\rD_6l\u0017M\u001c3Tk\nl\u0017n]:j_:\u001cVM\u001d<jG\u0016T!a\u0011#\u0011\u0005%SU\"A\r\n\u0005-K\"A\u0004)s_bL8\t\\8tK\u0006\u0014G.\u001a\t\u0003\u001bBk\u0011A\u0014\u0006\u0003-=S!AG\u000f\n\u0005Es%AD$sa\u000e\f\u0005/[*feZL7-Z\u0001\bg\u0016\u0014h/[2f+\u0005!&cA+X9\u001a!a\u000b\u0001\u0001U\u00051a$/\u001a4j]\u0016lWM\u001c;?!\tA6,D\u0001Z\u0015\tQv#\u0001\u0004e_6\f\u0017N\\\u0005\u0003\rf\u0003\"!\u00182\u000e\u0003yS!a\u00181\u0002\t1\fgn\u001a\u0006\u0002C\u0006!!.\u0019<b\u0013\t\u0019gLA\u0007BkR|7\t\\8tK\u0006\u0014G.Z\u0001\tg\u0016\u0014h/[2fA\u0005AA.\u001a3hKJLE\r\u0005\u0002hS:\u0011q\u0006[\u0005\u00035zJ!A[6\u0003\u00111+GmZ3s\u0013\u0012T!A\u0017 \u0002#\r,(O]3oi2+GmZ3s)&lW\rE\u0002']BL!a\\\u0014\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004CA9u\u001b\u0005\u0011(BA:a\u0003\u0011!\u0018.\\3\n\u0005U\u0014(aB%ogR\fg\u000e^\u0001\u000fGV\u0014(/\u001a8u+R\u001cG+[7f\u0003Qi\u0017\r\u001f#fIV\u0004H.[2bi&|g\u000eV5nKB\u0019aE\\=\u0011\u0007\u0019RH0\u0003\u0002|O\t1q\n\u001d;j_:\u0004\"!]?\n\u0005y\u0014(\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002+M,(-\\5tg&|g.\u00133HK:,'/\u0019;peB!\u00111AA\u0003\u001b\u0005q\u0014bAA\u0004}\t)2+\u001e2nSN\u001c\u0018n\u001c8JI\u001e+g.\u001a:bi>\u0014\u0018aB7fiJL7m\u001d\t\u0005\u0003\u001b\t\t\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011B\u0010\n\t\u0005M\u0011q\u0002\u0002\b\u001b\u0016$(/[2t\u0003e)'O]8s\u0007>$Wm\u001d,feNLwN\\*xSR\u001c\u0007.\u001a:\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b \u0003\u0015)'O]8s\u0013\u0011\t\t#a\u0007\u00033\u0015\u0013(o\u001c:D_\u0012,7OV3sg&|gnU<ji\u000eDWM]\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W9\u0013AC2p]\u000e,(O]3oi&!\u0011qFA\u0015\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\bm_\u001e<\u0017N\\4D_:$X\r\u001f;\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQ1!!\u000f \u0003\u001dawnZ4j]\u001eLA!!\u0010\u00028\tqAj\\4hS:<7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\b\u0006\n\u0002D\u00055\u00131KA+\u0003/\nI&a\u0017\u0002^\u0005}CCBA#\u0003\u0013\nY\u0005E\u0002\u0002H\u0001i\u0011!\u0006\u0005\b\u0003Ga\u00019AA\u0013\u0011\u001d\t\t\u0004\u0004a\u0002\u0003gAaA\u0015\u0007A\u0002\u0005=#\u0003BA)/r3QA\u0016\u0001\u0001\u0003\u001fBQ!\u001a\u0007A\u0002\u0019DQ\u0001\u001c\u0007A\u00025DQA\u001e\u0007A\u00025DQa\u001e\u0007A\u0002aDaa \u0007A\u0002\u0005\u0005\u0001bBA\u0005\u0019\u0001\u0007\u00111\u0002\u0005\b\u0003+a\u0001\u0019AA\f\u0003\u0019awnZ4feV\u0011\u0011Q\r\t\u0005\u0003k\t9'\u0003\u0003\u0002j\u0005]\"\u0001F\"p]R,\u0007\u0010^;bY&TX\r\u001a'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0013Y\fG.\u001b3bi>\u0014XCAA9!\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$bAA<}\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\n\t\u0005m\u0014Q\u000f\u0002\u0017'V\u0014W.\u001b;SKF,Xm\u001d;WC2LG-\u0019;pe\u0006Qa/\u00197jI\u0006$xN\u001d\u0011\u0002\rM,(-\\5u)\u0011\t\u0019)!(\u0011\r\u0005\u001d\u0012QQAE\u0013\u0011\t9)!\u000b\u0003\r\u0019+H/\u001e:f!\u0011\tY)!'\u000e\u0005\u00055%\u0002BAH\u0003#\u000bQ!Z7qifTA!a%\u0002\u0016\u0006A\u0001O]8u_\n,hMC\u0002\u0002\u0018\u0006\naaZ8pO2,\u0017\u0002BAN\u0003\u001b\u0013Q!R7qifDq!a(\u0012\u0001\u0004\t\t+A\u0004sKF,Xm\u001d;\u0011\t\u0005\r\u0016QU\u0007\u0002\t&\u0019\u0011q\u0015#\u0003\u001bM+(-\\5u%\u0016\fX/Z:u\u0003-\u0011\u0017N\u001c3TKJ4\u0018nY3\u0015\u0005\u00055\u0006\u0003BAX\u0003ok!!!-\u000b\u0007Y\t\u0019L\u0003\u0002\u00026\u0006\u0011\u0011n\\\u0005\u0005\u0003s\u000b\tLA\fTKJ4XM]*feZL7-\u001a#fM&t\u0017\u000e^5p]\u0006Yr-\u001a8fe\u0006$XmU;c[&\u001c8/[8o\u0013\u0012Le-R7qif$B!!)\u0002@\"9\u0011qT\nA\u0002\u0005\u0005\u0006")
public class GrpcCommandSubmissionService
implements CommandSubmissionServiceGrpc.CommandSubmissionService,
ProxyCloseable,
GrpcApiService {
    private final CommandSubmissionService service;
    private final Function0<Instant> currentLedgerTime;
    private final Function0<Instant> currentUtcTime;
    private final Function0<Option<Duration>> maxDeduplicationTime;
    private final SubmissionIdGenerator submissionIdGenerator;
    private final Metrics metrics;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final SubmitRequestValidator validator;

    @Override
    public void close() {
        ProxyCloseable.close$(this);
    }

    public CommandSubmissionServiceGrpc$CommandSubmissionService$ serviceCompanion() {
        return CommandSubmissionServiceGrpc.CommandSubmissionService.serviceCompanion$((CommandSubmissionServiceGrpc.CommandSubmissionService)this);
    }

    public CommandSubmissionService service() {
        return this.service;
    }

    public ContextualizedLogger logger() {
        return this.logger;
    }

    private SubmitRequestValidator validator() {
        return this.validator;
    }

    public Future<Empty> submit(com.daml.ledger.api.v1.command_submission_service.SubmitRequest request) {
        TelemetryContext telemetryContext = DefaultTelemetry$.MODULE$.contextFromGrpcThreadLocalContext();
        request.commands().foreach((Function1 & Serializable & scala.Serializable)commands -> {
            telemetryContext.setAttribute(SpanAttribute$.MODULE$.ApplicationId(), commands.applicationId());
            telemetryContext.setAttribute(SpanAttribute$.MODULE$.CommandId(), commands.commandId());
            telemetryContext.setAttribute(SpanAttribute$.MODULE$.Submitter(), commands.party());
            return telemetryContext.setAttribute(SpanAttribute$.MODULE$.WorkflowId(), commands.workflowId());
        });
        com.daml.ledger.api.v1.command_submission_service.SubmitRequest requestWithSubmissionId = this.generateSubmissionIdIfEmpty(request);
        DamlContextualizedErrorLogger errorLogger = new DamlContextualizedErrorLogger(this.logger(), this.loggingContext, requestWithSubmissionId.commands().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.submissionId()));
        return Timed$.MODULE$.timedAndTrackedFuture(this.metrics.daml().commands().submissions(), this.metrics.daml().commands().submissionsRunning(), (Function0 & Serializable & scala.Serializable)() -> (Future)((Either)Timed$.MODULE$.value($this.metrics.daml().commands().validation(), (Function0 & Serializable & scala.Serializable)() -> this.validator().validate(requestWithSubmissionId, (Instant)$this.currentLedgerTime.apply(), (Instant)$this.currentUtcTime.apply(), (Option<Duration>)((Option)$this.maxDeduplicationTime.apply()), (ContextualizedErrorLogger)errorLogger))).fold((Function1 & Serializable & scala.Serializable)t -> Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure(requestWithSubmissionId, (Throwable)t, this.logger(), $this.loggingContext)), (Function1 & Serializable & scala.Serializable)x$2 -> this.service().submit((SubmitRequest)x$2, telemetryContext).map((Function1 & Serializable & scala.Serializable)x$3 -> Empty$.MODULE$.defaultInstance(), $this.executionContext)));
    }

    public ServerServiceDefinition bindService() {
        return CommandSubmissionServiceGrpc$.MODULE$.bindService((CommandSubmissionServiceGrpc.CommandSubmissionService)this, this.executionContext);
    }

    private com.daml.ledger.api.v1.command_submission_service.SubmitRequest generateSubmissionIdIfEmpty(com.daml.ledger.api.v1.command_submission_service.SubmitRequest request) {
        return request.commands().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)GrpcCommandSubmissionService.$anonfun$generateSubmissionIdIfEmpty$1(x$4))) ? (com.daml.ledger.api.v1.command_submission_service.SubmitRequest)request.update((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable & scala.Serializable)x$5 -> Commands$.MODULE$.CommandsLens(SubmitRequest$.MODULE$.SubmitRequestLens(x$5).commands()).submissionId().$colon$eq((Object)$this.submissionIdGenerator.generate())})) : request;
    }

    public static final /* synthetic */ boolean $anonfun$generateSubmissionIdIfEmpty$1(Commands x$4) {
        return x$4.submissionId().isEmpty();
    }

    public GrpcCommandSubmissionService(CommandSubmissionService service, Object ledgerId, Function0<Instant> currentLedgerTime, Function0<Instant> currentUtcTime, Function0<Option<Duration>> maxDeduplicationTime, SubmissionIdGenerator submissionIdGenerator, Metrics metrics, ErrorCodesVersionSwitcher errorCodesVersionSwitcher, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.service = service;
        this.currentLedgerTime = currentLedgerTime;
        this.currentUtcTime = currentUtcTime;
        this.maxDeduplicationTime = maxDeduplicationTime;
        this.submissionIdGenerator = submissionIdGenerator;
        this.metrics = metrics;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        CommandSubmissionServiceGrpc.CommandSubmissionService.$init$((CommandSubmissionServiceGrpc.CommandSubmissionService)this);
        ProxyCloseable.$init$(this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.validator = new SubmitRequestValidator(new CommandsValidator(ledgerId, errorCodesVersionSwitcher), FieldValidations$.MODULE$.apply(ErrorFactories$.MODULE$.apply(errorCodesVersionSwitcher)));
    }
}

