/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.server.api.services.grpc;

import akka.NotUsed;
import akka.stream.Materializer;
import akka.stream.SharedKillSwitch;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.grpc.adapter.ExecutionSequencerFactory;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.messages.transaction.GetLedgerEndRequest;
import com.daml.ledger.api.messages.transaction.GetTransactionByEventIdRequest;
import com.daml.ledger.api.messages.transaction.GetTransactionByIdRequest;
import com.daml.ledger.api.messages.transaction.GetTransactionTreesRequest;
import com.daml.ledger.api.messages.transaction.GetTransactionsRequest;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset;
import com.daml.ledger.api.v1.transaction_service.GetFlatTransactionResponse;
import com.daml.ledger.api.v1.transaction_service.GetLedgerEndResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionTreesResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionsResponse;
import com.daml.ledger.api.v1.transaction_service.TransactionServiceAkkaGrpc;
import com.daml.ledger.api.v1.transaction_service.TransactionServiceGrpc;
import com.daml.ledger.api.v1.transaction_service.TransactionServiceGrpc$;
import com.daml.ledger.api.v1.transaction_service.TransactionServiceGrpc$TransactionService$;
import com.daml.ledger.api.validation.PartyNameChecker;
import com.daml.ledger.api.validation.TransactionServiceRequestValidator;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.api.grpc.GrpcApiService;
import com.daml.platform.server.api.ValidationLogger$;
import com.daml.platform.server.api.services.domain.TransactionService;
import com.daml.platform.server.api.validation.ErrorFactories;
import io.grpc.ServerServiceDefinition;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\t=c\u0001B\u000f\u001f\u00055B\u0001\"\u0012\u0001\u0003\u0006\u0004%\tB\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u000f\"Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003Q\u0011!\u0011\u0007A!A!\u0002\u0013\u0019\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u0011=\u0004!Q1A\u0005\u0014AD\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\ts\u0002\u0011)\u0019!C\nu\"I\u0011q\u0001\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\u000b\u0003\u0013\u0001!\u0011!Q\u0001\f\u0005-\u0001BCA\f\u0001\t\u0005\t\u0015a\u0003\u0002\u001a!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002\"CA \u0001\t\u0007I1CA!\u0011!\tI\u0005\u0001Q\u0001\n\u0005\r\u0003\"CA&\u0001\t\u0007I1BA'\u0011!\tY\u0006\u0001Q\u0001\n\u0005=\u0003\"CA/\u0001\t\u0007I\u0011BA0\u0011!\t9\u0007\u0001Q\u0001\n\u0005\u0005\u0004bBA5\u0001\u0011E\u00131\u000e\u0005\b\u0003#\u0003A\u0011KAJ\u0011\u001d\ty\n\u0001C\u0005\u0003CCq!!>\u0001\t\u0003\n9\u0010C\u0004\u0003\n\u0001!\tEa\u0003\t\u000f\tU\u0001\u0001\"\u0011\u0003\u0018!9!1\u0005\u0001\u0005B\t\u0015\u0002b\u0002B\u0015\u0001\u0011\u0005#1\u0006\u0005\b\u0005{\u0001A\u0011\tB \u0005Y9%\u000f]2Ue\u0006t7/Y2uS>t7+\u001a:wS\u000e,'BA\u0010!\u0003\u00119'\u000f]2\u000b\u0005\u0005\u0012\u0013\u0001C:feZL7-Z:\u000b\u0005\r\"\u0013aA1qS*\u0011QEJ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u001dB\u0013\u0001\u00039mCR4wN]7\u000b\u0005%R\u0013\u0001\u00023b[2T\u0011aK\u0001\u0004G>l7\u0001A\n\u0005\u00019\"t\b\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0003kuj\u0011A\u000e\u0006\u0003oa\n1\u0003\u001e:b]N\f7\r^5p]~\u001bXM\u001d<jG\u0016T!!\u000f\u001e\u0002\u0005Y\f$BA\u0012<\u0015\ta\u0004&\u0001\u0004mK\u0012<WM]\u0005\u0003}Y\u0012!\u0004\u0016:b]N\f7\r^5p]N+'O^5dK\u0006[7.Y$sa\u000e\u0004\"\u0001Q\"\u000e\u0003\u0005S!a\b\"\u000b\u0005\r2\u0013B\u0001#B\u000599%\u000f]2Ba&\u001cVM\u001d<jG\u0016\fqa]3sm&\u001cW-F\u0001H!\tA5*D\u0001J\u0015\tQ\u0005%\u0001\u0004e_6\f\u0017N\\\u0005\u0003\u0019&\u0013!\u0003\u0016:b]N\f7\r^5p]N+'O^5dK\u0006A1/\u001a:wS\u000e,\u0007%\u0001\u0005mK\u0012<WM]%e+\u0005\u0001\u0006CA)_\u001d\t\u0011VL\u0004\u0002T9:\u0011Ak\u0017\b\u0003+js!AV-\u000e\u0003]S!\u0001\u0017\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0013BA\u0015+\u0013\ta\u0004&\u0003\u0002$w%\u0011!JO\u0005\u0003?\u0002\u0014\u0001\u0002T3eO\u0016\u0014\u0018\n\u001a\u0006\u0003\u0015j\n\u0011\u0002\\3eO\u0016\u0014\u0018\n\u001a\u0011\u0002!A\f'\u000f^=OC6,7\t[3dW\u0016\u0014\bC\u00013h\u001b\u0005)'B\u00014;\u0003)1\u0018\r\\5eCRLwN\\\u0005\u0003Q\u0016\u0014\u0001\u0003U1sift\u0015-\\3DQ\u0016\u001c7.\u001a:\u0002\u001d\u0015\u0014(o\u001c:GC\u000e$xN]5fgB\u00111.\\\u0007\u0002Y*\u0011aMI\u0005\u0003]2\u0014a\"\u0012:s_J4\u0015m\u0019;pe&,7/A\u0002fg\u001a,\u0012!\u001d\t\u0003eZl\u0011a\u001d\u0006\u0003iV\fq!\u00193baR,'O\u0003\u0002 Q%\u0011qo\u001d\u0002\u001a\u000bb,7-\u001e;j_:\u001cV-];f]\u000e,'OR1di>\u0014\u00180\u0001\u0003fg\u001a\u0004\u0013aA7biV\t1\u0010E\u0002}\u0003\u0007i\u0011! \u0006\u0003}~\faa\u001d;sK\u0006l'BAA\u0001\u0003\u0011\t7n[1\n\u0007\u0005\u0015QP\u0001\u0007NCR,'/[1mSj,'/\u0001\u0003nCR\u0004\u0013\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\ta\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005U\u0011q\u0002\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0002\\8hO&twmQ8oi\u0016DH\u000f\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\u0002K\u0001\bY><w-\u001b8h\u0013\u0011\t\u0019#!\b\u0003\u001d1{wmZ5oO\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\"\"!\u000b\u00028\u0005e\u00121HA\u001f))\tY#a\f\u00022\u0005M\u0012Q\u0007\t\u0004\u0003[\u0001Q\"\u0001\u0010\t\u000b=l\u00019A9\t\u000bel\u00019A>\t\u000f\u0005%Q\u0002q\u0001\u0002\f!9\u0011qC\u0007A\u0004\u0005e\u0001\"B#\u000e\u0001\u00049\u0005\"\u0002(\u000e\u0001\u0004\u0001\u0006\"\u00022\u000e\u0001\u0004\u0019\u0007\"B5\u000e\u0001\u0004Q\u0017A\u00027pO\u001e,'/\u0006\u0002\u0002DA!\u00111DA#\u0013\u0011\t9%!\b\u0003)\r{g\u000e^3yiV\fG.\u001b>fI2{wmZ3s\u0003\u001dawnZ4fe\u0002\n\u0011dY8oi\u0016DH/^1mSj,G-\u0012:s_JdunZ4feV\u0011\u0011q\n\t\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019\u0011Q\u000b\u0015\u0002\u000b\u0015\u0014(o\u001c:\n\t\u0005e\u00131\u000b\u0002\u001a\u0007>tG/\u001a=uk\u0006d\u0017N_3e\u000bJ\u0014xN\u001d'pO\u001e,'/\u0001\u000ed_:$X\r\u001f;vC2L'0\u001a3FeJ|'\u000fT8hO\u0016\u0014\b%A\u0005wC2LG-\u0019;peV\u0011\u0011\u0011\r\t\u0004I\u0006\r\u0014bAA3K\n\u0011CK]1og\u0006\u001cG/[8o'\u0016\u0014h/[2f%\u0016\fX/Z:u-\u0006d\u0017\u000eZ1u_J\f!B^1mS\u0012\fGo\u001c:!\u0003U9W\r\u001e+sC:\u001c\u0018m\u0019;j_:\u001c8k\\;sG\u0016$B!!\u001c\u0002\bBA\u0011qNA;\u0003s\ny(\u0004\u0002\u0002r)\u0019\u00111O?\u0002\u0011M\u001c\u0017\r\\1eg2LA!a\u001e\u0002r\t11k\\;sG\u0016\u00042!NA>\u0013\r\tiH\u000e\u0002\u0018\u000f\u0016$HK]1og\u0006\u001cG/[8ogJ+7\u000f]8og\u0016\u0004B!!!\u0002\u00046\tq0C\u0002\u0002\u0006~\u0014qAT8u+N,G\rC\u0004\u0002\nR\u0001\r!a#\u0002\u000fI,\u0017/^3tiB\u0019Q'!$\n\u0007\u0005=eG\u0001\fHKR$&/\u00198tC\u000e$\u0018n\u001c8t%\u0016\fX/Z:u\u0003e9W\r\u001e+sC:\u001c\u0018m\u0019;j_:$&/Z3t'>,(oY3\u0015\t\u0005U\u0015Q\u0014\t\t\u0003_\n)(a&\u0002\u0000A\u0019Q'!'\n\u0007\u0005meGA\u000eHKR$&/\u00198tC\u000e$\u0018n\u001c8Ue\u0016,7OU3ta>t7/\u001a\u0005\b\u0003\u0013+\u0002\u0019AAF\u0003Q9W\r^*j]\u001edW\r\u0016:b]N\f7\r^5p]VQ\u00111UAc\u0003O\f\t0a,\u0015\u0011\u0005\u0015\u0016\u0011YAe\u0003W\u0004b!!\u0004\u0002(\u0006-\u0016\u0002BAU\u0003\u001f\u0011aAR;ukJ,\u0007\u0003BAW\u0003_c\u0001\u0001B\u0004\u00022Z\u0011\r!a-\u0003\u0011I+7\u000f]8og\u0016\fB!!.\u0002<B\u0019q&a.\n\u0007\u0005e\u0006GA\u0004O_RD\u0017N\\4\u0011\u0007=\ni,C\u0002\u0002@B\u00121!\u00118z\u0011\u001d\tII\u0006a\u0001\u0003\u0007\u0004B!!,\u0002F\u00129\u0011q\u0019\fC\u0002\u0005M&a\u0002*fcV,7\u000f\u001e\u0005\b\u0003\u00174\u0002\u0019AAg\u0003!1\u0018\r\\5eCR,\u0007cB\u0018\u0002P\u0006\r\u00171[\u0005\u0004\u0003#\u0004$!\u0003$v]\u000e$\u0018n\u001c82!\u0019\t).a8\u0002f:!\u0011q[An\u001d\r\u0011\u0016\u0011\\\u0005\u0003MjJ1!!8f\u0003\t\"&/\u00198tC\u000e$\u0018n\u001c8TKJ4\u0018nY3SKF,Xm\u001d;WC2LG-\u0019;pe&!\u0011\u0011]Ar\u0005\u0019\u0011Vm];mi*\u0019\u0011Q\\3\u0011\t\u00055\u0016q\u001d\u0003\b\u0003S4\"\u0019AAZ\u00055!u.\\1j]J+\u0017/^3ti\"9\u0011Q\u001e\fA\u0002\u0005=\u0018!\u00024fi\u000eD\u0007cB\u0018\u0002P\u0006\u0015\u0018Q\u0015\u0003\b\u0003g4\"\u0019AAZ\u0005!!u.\\1j]RC\u0018aF4fiR\u0013\u0018M\\:bGRLwN\u001c\"z\u000bZ,g\u000e^%e)\u0011\tIP!\u0001\u0011\r\u00055\u0011qUA~!\r)\u0014Q`\u0005\u0004\u0003\u007f4$AF$fiR\u0013\u0018M\\:bGRLwN\u001c*fgB|gn]3\t\u000f\u0005%u\u00031\u0001\u0003\u0004A\u0019QG!\u0002\n\u0007\t\u001daG\u0001\u0010HKR$&/\u00198tC\u000e$\u0018n\u001c8Cs\u00163XM\u001c;JIJ+\u0017/^3ti\u0006\u0011r-\u001a;Ue\u0006t7/Y2uS>t')_%e)\u0011\tIP!\u0004\t\u000f\u0005%\u0005\u00041\u0001\u0003\u0010A\u0019QG!\u0005\n\u0007\tMaGA\rHKR$&/\u00198tC\u000e$\u0018n\u001c8Cs&#'+Z9vKN$\u0018aG4fi\u001ac\u0017\r\u001e+sC:\u001c\u0018m\u0019;j_:\u0014\u00150\u0012<f]RLE\r\u0006\u0003\u0003\u001a\t\u0005\u0002CBA\u0007\u0003O\u0013Y\u0002E\u00026\u0005;I1Aa\b7\u0005i9U\r\u001e$mCR$&/\u00198tC\u000e$\u0018n\u001c8SKN\u0004xN\\:f\u0011\u001d\tI)\u0007a\u0001\u0005\u0007\tacZ3u\r2\fG\u000f\u0016:b]N\f7\r^5p]\nK\u0018\n\u001a\u000b\u0005\u00053\u00119\u0003C\u0004\u0002\nj\u0001\rAa\u0004\u0002\u0019\u001d,G\u000fT3eO\u0016\u0014XI\u001c3\u0015\t\t5\"Q\u0007\t\u0007\u0003\u001b\t9Ka\f\u0011\u0007U\u0012\t$C\u0002\u00034Y\u0012AcR3u\u0019\u0016$w-\u001a:F]\u0012\u0014Vm\u001d9p]N,\u0007bBAE7\u0001\u0007!q\u0007\t\u0004k\te\u0012b\u0001B\u001em\t\u0019r)\u001a;MK\u0012<WM]#oIJ+\u0017/^3ti\u0006Y!-\u001b8e'\u0016\u0014h/[2f)\t\u0011\t\u0005\u0005\u0003\u0003D\t-SB\u0001B#\u0015\ry\"q\t\u0006\u0003\u0005\u0013\n!![8\n\t\t5#Q\t\u0002\u0018'\u0016\u0014h/\u001a:TKJ4\u0018nY3EK\u001aLg.\u001b;j_:\u0004")
public final class GrpcTransactionService
implements TransactionServiceAkkaGrpc,
GrpcApiService {
    private final TransactionService service;
    private final Object ledgerId;
    private final ExecutionSequencerFactory esf;
    private final Materializer mat;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final ContextualizedErrorLogger contextualizedErrorLogger;
    private final TransactionServiceRequestValidator validator;
    private final SharedKillSwitch killSwitch;
    private final AtomicBoolean closed;

    public StatusRuntimeException closingError() {
        return TransactionServiceAkkaGrpc.closingError$((TransactionServiceAkkaGrpc)this);
    }

    @Override
    public void close() {
        TransactionServiceAkkaGrpc.close$((TransactionServiceAkkaGrpc)this);
    }

    public void getTransactions(com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest request, StreamObserver<GetTransactionsResponse> responseObserver) {
        TransactionServiceAkkaGrpc.getTransactions$((TransactionServiceAkkaGrpc)this, (com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest)request, responseObserver);
    }

    public void getTransactionTrees(com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest request, StreamObserver<GetTransactionTreesResponse> responseObserver) {
        TransactionServiceAkkaGrpc.getTransactionTrees$((TransactionServiceAkkaGrpc)this, (com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest)request, responseObserver);
    }

    public TransactionServiceGrpc$TransactionService$ serviceCompanion() {
        return TransactionServiceGrpc.TransactionService.serviceCompanion$((TransactionServiceGrpc.TransactionService)this);
    }

    public SharedKillSwitch killSwitch() {
        return this.killSwitch;
    }

    public AtomicBoolean closed() {
        return this.closed;
    }

    public void com$daml$ledger$api$v1$transaction_service$TransactionServiceAkkaGrpc$_setter_$killSwitch_$eq(SharedKillSwitch x$1) {
        this.killSwitch = x$1;
    }

    public void com$daml$ledger$api$v1$transaction_service$TransactionServiceAkkaGrpc$_setter_$closed_$eq(AtomicBoolean x$1) {
        this.closed = x$1;
    }

    public TransactionService service() {
        return this.service;
    }

    public Object ledgerId() {
        return this.ledgerId;
    }

    public ExecutionSequencerFactory esf() {
        return this.esf;
    }

    public Materializer mat() {
        return this.mat;
    }

    public ContextualizedLogger logger() {
        return this.logger;
    }

    private ContextualizedErrorLogger contextualizedErrorLogger() {
        return this.contextualizedErrorLogger;
    }

    private TransactionServiceRequestValidator validator() {
        return this.validator;
    }

    public Source<GetTransactionsResponse, NotUsed> getTransactionsSource(com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest request) {
        this.logger().debug().apply((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Received new transaction request ").append(request).toString(), this.loggingContext);
        return (Source)Source$.MODULE$.future(this.service().getLedgerEnd(request.ledgerId())).flatMapConcat((Function1 & Serializable & scala.Serializable)ledgerEnd -> {
            Either<StatusRuntimeException, GetTransactionsRequest> validation = this.validator().validate(request, (domain.LedgerOffset.Absolute)ledgerEnd, this.contextualizedErrorLogger());
            return (Source)validation.fold((Function1 & Serializable & scala.Serializable)t -> Source$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure(request, (Throwable)t, this.logger(), $this.loggingContext)), (Function1 & Serializable & scala.Serializable)req -> req.filter().filtersByParty().isEmpty() ? Source$.MODULE$.empty() : this.service().getTransactions((GetTransactionsRequest)req));
        });
    }

    public Source<GetTransactionTreesResponse, NotUsed> getTransactionTreesSource(com.daml.ledger.api.v1.transaction_service.GetTransactionsRequest request) {
        this.logger().debug().apply((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Received new transaction tree request ").append(request).toString(), this.loggingContext);
        return (Source)Source$.MODULE$.future(this.service().getLedgerEnd(request.ledgerId())).flatMapConcat((Function1 & Serializable & scala.Serializable)ledgerEnd -> {
            Either<StatusRuntimeException, GetTransactionTreesRequest> validation = this.validator().validateTree(request, (domain.LedgerOffset.Absolute)ledgerEnd, this.contextualizedErrorLogger());
            return (Source)validation.fold((Function1 & Serializable & scala.Serializable)t -> Source$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure(request, (Throwable)t, this.logger(), $this.loggingContext)), (Function1 & Serializable & scala.Serializable)req -> req.parties().isEmpty() ? Source$.MODULE$.empty() : this.service().getTransactionTrees((GetTransactionTreesRequest)req));
        });
    }

    private <Request, DomainRequest, DomainTx, Response> Future<Response> getSingleTransaction(Request request, Function1<Request, Either<StatusRuntimeException, DomainRequest>> validate, Function1<DomainRequest, Future<Response>> fetch) {
        return (Future)((Either)validate.apply(request)).fold((Function1 & Serializable & scala.Serializable)t -> Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure(request, (Throwable)t, this.logger(), $this.loggingContext)), (Function1 & Serializable & scala.Serializable)x$1 -> (Future)fetch.apply(x$1));
    }

    public Future<GetTransactionResponse> getTransactionByEventId(com.daml.ledger.api.v1.transaction_service.GetTransactionByEventIdRequest request) {
        return this.getSingleTransaction(request, (Function1 & Serializable & scala.Serializable)req -> this.validator().validateTransactionByEventId((com.daml.ledger.api.v1.transaction_service.GetTransactionByEventIdRequest)req, this.contextualizedErrorLogger()), (Function1 & Serializable & scala.Serializable)req -> this.service().getTransactionByEventId((GetTransactionByEventIdRequest)req));
    }

    public Future<GetTransactionResponse> getTransactionById(com.daml.ledger.api.v1.transaction_service.GetTransactionByIdRequest request) {
        return this.getSingleTransaction(request, (Function1 & Serializable & scala.Serializable)req -> this.validator().validateTransactionById((com.daml.ledger.api.v1.transaction_service.GetTransactionByIdRequest)req, this.contextualizedErrorLogger()), (Function1 & Serializable & scala.Serializable)req -> this.service().getTransactionById((GetTransactionByIdRequest)req));
    }

    public Future<GetFlatTransactionResponse> getFlatTransactionByEventId(com.daml.ledger.api.v1.transaction_service.GetTransactionByEventIdRequest request) {
        return this.getSingleTransaction(request, (Function1 & Serializable & scala.Serializable)req -> this.validator().validateTransactionByEventId((com.daml.ledger.api.v1.transaction_service.GetTransactionByEventIdRequest)req, this.contextualizedErrorLogger()), (Function1 & Serializable & scala.Serializable)req -> this.service().getFlatTransactionByEventId((GetTransactionByEventIdRequest)req));
    }

    public Future<GetFlatTransactionResponse> getFlatTransactionById(com.daml.ledger.api.v1.transaction_service.GetTransactionByIdRequest request) {
        return this.getSingleTransaction(request, (Function1 & Serializable & scala.Serializable)req -> this.validator().validateTransactionById((com.daml.ledger.api.v1.transaction_service.GetTransactionByIdRequest)req, this.contextualizedErrorLogger()), (Function1 & Serializable & scala.Serializable)req -> this.service().getFlatTransactionById((GetTransactionByIdRequest)req));
    }

    public Future<GetLedgerEndResponse> getLedgerEnd(com.daml.ledger.api.v1.transaction_service.GetLedgerEndRequest request) {
        Either<StatusRuntimeException, GetLedgerEndRequest> validation = this.validator().validateLedgerEnd(request, this.contextualizedErrorLogger());
        return (Future)validation.fold((Function1 & Serializable & scala.Serializable)t -> Future$.MODULE$.failed(ValidationLogger$.MODULE$.logFailure(request, (Throwable)t, this.logger(), $this.loggingContext)), (Function1 & Serializable & scala.Serializable)x$2 -> this.service().getLedgerEnd(request.ledgerId()).map((Function1 & Serializable & scala.Serializable)abs -> new GetLedgerEndResponse((Option)new Some((Object)new LedgerOffset((LedgerOffset.Value)new LedgerOffset.Value$.Absolute(abs.value())))), $this.executionContext));
    }

    public ServerServiceDefinition bindService() {
        return TransactionServiceGrpc$.MODULE$.bindService((TransactionServiceGrpc.TransactionService)this, this.executionContext);
    }

    public GrpcTransactionService(TransactionService service, Object ledgerId, PartyNameChecker partyNameChecker, ErrorFactories errorFactories, ExecutionSequencerFactory esf, Materializer mat, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.service = service;
        this.ledgerId = ledgerId;
        this.esf = esf;
        this.mat = mat;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        TransactionServiceGrpc.TransactionService.$init$((TransactionServiceGrpc.TransactionService)this);
        TransactionServiceAkkaGrpc.$init$((TransactionServiceAkkaGrpc)this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.contextualizedErrorLogger = new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$);
        this.validator = new TransactionServiceRequestValidator(ledgerId, partyNameChecker, errorFactories);
    }
}

