/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.server.api.validation;

import com.daml.api.util.DurationConversion$;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.ledger.api.DeduplicationPeriod;
import com.daml.ledger.api.domain$;
import com.daml.ledger.api.v1.commands.Commands;
import com.daml.ledger.api.v1.value.Identifier;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Ref$;
import com.daml.lf.value.Value;
import com.daml.platform.server.api.validation.ErrorFactories;
import com.daml.platform.server.api.validation.FieldValidations$;
import com.google.protobuf.duration.Duration;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t5f\u0001B\f\u0019\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\u0006c\u0001!IA\r\u0005\u0006k\u0001!\tA\u000e\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0006y\u0002!\t! \u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!!\u0010\u0001\t\u0003\ty\u0004C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005\u0015\u0005bBAG\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\ti\r\u0001C\u0001\u0003\u001fDq!!9\u0001\t\u0003\t\u0019\u000fC\u0004\u0003$\u0001!\tA!\n\t\u000f\tm\u0002\u0001\"\u0001\u0003>!9!1\u0011\u0001\u0005\u0002\t\u0015ua\u0002BP1!\u0005!\u0011\u0015\u0004\u0007/aA\tAa)\t\rE\"B\u0011\u0001BS\u0011\u001d\u00119\u000b\u0006C\u0001\u0005S\u0013\u0001CR5fY\u00124\u0016\r\\5eCRLwN\\:\u000b\u0005eQ\u0012A\u0003<bY&$\u0017\r^5p]*\u00111\u0004H\u0001\u0004CBL'BA\u000f\u001f\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0004I\u0001\ta2\fGOZ8s[*\u0011\u0011EI\u0001\u0005I\u0006lGNC\u0001$\u0003\r\u0019w.\\\u0002\u0001'\t\u0001a\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VMZ\u0001\u000fKJ\u0014xN\u001d$bGR|'/[3t!\tqs&D\u0001\u0019\u0013\t\u0001\u0004D\u0001\bFeJ|'OR1di>\u0014\u0018.Z:\u0002\rqJg.\u001b;?)\t\u0019D\u0007\u0005\u0002/\u0001!)AF\u0001a\u0001[\u0005iQ.\u0019;dQ2+GmZ3s\u0013\u0012$\"aN5\u0015\u0005a:GCA\u001d`!\u0011Q$)R'\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 %\u0003\u0019a$o\\8u}%\t\u0011&\u0003\u0002BQ\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005\u0019)\u0015\u000e\u001e5fe*\u0011\u0011\t\u000b\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000bAa\u001a:qG*\t!*\u0001\u0002j_&\u0011Aj\u0012\u0002\u0017'R\fG/^:Sk:$\u0018.\\3Fq\u000e,\u0007\u000f^5p]B\u0011a\n\u0018\b\u0003\u001ffs!\u0001U,\u000f\u0005E+fB\u0001*U\u001d\ta4+C\u0001$\u0013\t\t#%\u0003\u0002WA\u00051A.\u001a3hKJL!a\u0007-\u000b\u0005Y\u0003\u0013B\u0001.\\\u0003\u0019!w.\\1j]*\u00111\u0004W\u0005\u0003;z\u0013\u0001\u0002T3eO\u0016\u0014\u0018\n\u001a\u0006\u00035nCQ\u0001Y\u0002A\u0004\u0005\f\u0011dY8oi\u0016DH/^1mSj,G-\u0012:s_JdunZ4feB\u0011!-Z\u0007\u0002G*\u0011A\rI\u0001\u0006KJ\u0014xN]\u0005\u0003M\u000e\u0014\u0011dQ8oi\u0016DH/^1mSj,G-\u0012:s_JdunZ4fe\")\u0001n\u0001a\u0001\u001b\u0006A!/Z2fSZ,G\rC\u0003k\u0007\u0001\u0007Q*\u0001\u0005mK\u0012<WM]%e\u0003U\u0011X-];je\u0016tuN\\#naRL8\u000b\u001e:j]\u001e$2!\u001c={)\tqw\u000f\u0005\u0003;\u0005\u0016{\u0007C\u00019u\u001d\t\t(\u000f\u0005\u0002=Q%\u00111\u000fK\u0001\u0007!J,G-\u001a4\n\u0005U4(AB*ue&twM\u0003\u0002tQ!)\u0001\r\u0002a\u0002C\")\u0011\u0010\u0002a\u0001_\u0006\t1\u000fC\u0003|\t\u0001\u0007q.A\u0005gS\u0016dGMT1nK\u0006\t\"/Z9vSJ,\u0017\nZ3oi&4\u0017.\u001a:\u0015\u0007y\fY\u0002F\u0002\u0000\u00033\u0001RA\u000f\"F\u0003\u0003\u0001B!a\u0001\u0002\u00149!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011\u0001\u00023bi\u0006T1!!\u0004!\u0003\tag-\u0003\u0003\u0002\u0012\u0005\u001d\u0011a\u0001*fM&!\u0011QCA\f\u0005\u0011q\u0015-\\3\u000b\t\u0005E\u0011q\u0001\u0005\u0006A\u0016\u0001\u001d!\u0019\u0005\u0006s\u0016\u0001\ra\\\u0001\fe\u0016\fX/\u001b:f\u001d\u0006lW\r\u0006\u0004\u0002\"\u0005\u0015\u0012q\u0005\u000b\u0004\u007f\u0006\r\u0002\"\u00021\u0007\u0001\b\t\u0007\"B=\u0007\u0001\u0004y\u0007\"B>\u0007\u0001\u0004y\u0017\u0001\u0005:fcVL'/\u001a)bG.\fw-Z%e)\u0019\ti#!\u000f\u0002<Q!\u0011qFA\u001c!\u0015Q$)RA\u0019!\u0011\t\u0019!a\r\n\t\u0005U\u0012q\u0003\u0002\n!\u0006\u001c7.Y4f\u0013\u0012DQ\u0001Y\u0004A\u0004\u0005DQ!_\u0004A\u0002=DQa_\u0004A\u0002=\fAB]3rk&\u0014X\rU1sif$B!!\u0011\u0002NQ!\u00111IA&!\u0015Q$)RA#!\u0011\t\u0019!a\u0012\n\t\u0005%\u0013q\u0003\u0002\u0006!\u0006\u0014H/\u001f\u0005\u0006A\"\u0001\u001d!\u0019\u0005\u0006s\"\u0001\ra\\\u0001\u000fe\u0016\fX/\u001b:f!\u0006\u0014H/[3t)\u0011\t\u0019&a\u001b\u0015\t\u0005U\u0013\u0011\u000e\t\u0006u\t+\u0015q\u000b\t\u0006a\u0006e\u0013QL\u0005\u0004\u000372(aA*fiB!\u0011qLA$\u001d\u0011\t\t'a\u0004\u000f\t\u0005\r\u0014q\r\b\u0004#\u0006\u0015\u0014bAA\u0007A%!\u0011\u0011BA\u0006\u0011\u0015\u0001\u0017\u0002q\u0001b\u0011\u001d\ti'\u0003a\u0001\u0003_\nq\u0001]1si&,7\u000f\u0005\u0003q\u00033z\u0017a\u0005:fcVL'/\u001a'fI\u001e,'o\u0015;sS:<GCBA;\u0003\u0003\u000b\u0019\t\u0006\u0003\u0002x\u0005}\u0004#\u0002\u001eC\u000b\u0006e\u0004\u0003BA\u0002\u0003wJA!! \u0002\u0018\taA*\u001a3hKJ\u001cFO]5oO\")\u0001M\u0003a\u0002C\")\u0011P\u0003a\u0001_\")1P\u0003a\u0001_R!\u0011qQAF)\u0011\t9(!#\t\u000b\u0001\\\u00019A1\t\u000be\\\u0001\u0019A8\u0002)Y\fG.\u001b3bi\u0016\u001cVOY7jgNLwN\\%e)\u0011\t\t*a*\u0015\t\u0005M\u0015Q\u0015\t\u0006u\t+\u0015Q\u0013\t\u0006O\u0005]\u00151T\u0005\u0004\u00033C#AB(qi&|g\u000e\u0005\u0003\u0002\u001e\u0006\u0005fbAAP36\t1,C\u0002\u0002$z\u0013AbU;c[&\u001c8/[8o\u0013\u0012DQ\u0001\u0019\u0007A\u0004\u0005DQ!\u001f\u0007A\u0002=\f\u0011C]3rk&\u0014XmQ8oiJ\f7\r^%e)\u0019\ti+!3\u0002LR!\u0011qVAd!\u0015Q$)RAY!\u0011\t\u0019,!1\u000f\t\u0005U\u00161\u0018\b\u0005\u0003G\n9,\u0003\u0003\u0002:\u0006-\u0011!\u0002<bYV,\u0017\u0002BA_\u0003\u007f\u000bQAV1mk\u0016TA!!/\u0002\f%!\u00111YAc\u0005)\u0019uN\u001c;sC\u000e$\u0018\n\u001a\u0006\u0005\u0003{\u000by\fC\u0003a\u001b\u0001\u000f\u0011\rC\u0003z\u001b\u0001\u0007q\u000eC\u0003|\u001b\u0001\u0007q.A\tsKF,\u0018N]3E_R$X\r\u001a(b[\u0016$b!!5\u0002^\u0006}G\u0003BAj\u00037\u0004RA\u000f\"F\u0003+\u0004B!a\u0001\u0002X&!\u0011\u0011\\A\f\u0005)!u\u000e\u001e;fI:\u000bW.\u001a\u0005\u0006A:\u0001\u001d!\u0019\u0005\u0006s:\u0001\ra\u001c\u0005\u0006w:\u0001\ra\\\u0001\u0010e\u0016\fX/\u001b:f\u001d>tW)\u001c9usV1\u0011Q]Ax\u00053!b!a:\u0003 \t\u0005B\u0003BAu\u0005;\u0001RA\u000f\"F\u0003W\u0004b!!<\u0002p\n]A\u0002\u0001\u0003\b\u0003c|!\u0019AAz\u0005\u0005iU\u0003BA{\u0005'\tB!a>\u0002~B\u0019q%!?\n\u0007\u0005m\bFA\u0004O_RD\u0017N\\41\t\u0005}(q\u0001\t\u0006u\t\u0005!QA\u0005\u0004\u0005\u0007!%\u0001C%uKJ\f'\r\\3\u0011\t\u00055(q\u0001\u0003\r\u0005\u0013\ty/!A\u0001\u0002\u000b\u0005!1\u0002\u0002\u0004?\u0012\n\u0014\u0003BA|\u0005\u001b\u00012a\nB\b\u0013\r\u0011\t\u0002\u000b\u0002\u0004\u0003:LH\u0001\u0003B\u000b\u0003_\u0014\rAa\u0003\u0003\u0003}\u0003B!!<\u0003\u001a\u00119!1D\bC\u0002\t-!!\u0001+\t\u000b\u0001|\u00019A1\t\re|\u0001\u0019AAv\u0011\u0015Yx\u00021\u0001p\u0003=\u0011X-];je\u0016\u0004&/Z:f]\u000e,W\u0003\u0002B\u0014\u0005_!bA!\u000b\u00034\teB\u0003\u0002B\u0016\u0005c\u0001RA\u000f\"F\u0005[\u0001B!!<\u00030\u00119!1\u0004\tC\u0002\t-\u0001\"\u00021\u0011\u0001\b\t\u0007b\u0002B\u001b!\u0001\u0007!qG\u0001\u0007_B$\u0018n\u001c8\u0011\u000b\u001d\n9J!\f\t\u000bm\u0004\u0002\u0019A8\u00027Y\fG.\u001b3bi\u0016$U\rZ;qY&\u001c\u0017\r^5p]B+'/[8e)!\u0011yDa\u0013\u0003l\t\u0005E\u0003\u0002B!\u0005\u0013\u0002RA\u000f\"F\u0005\u0007\u0002B!a(\u0003F%\u0019!qI.\u0003'\u0011+G-\u001e9mS\u000e\fG/[8o!\u0016\u0014\u0018n\u001c3\t\u000b\u0001\f\u00029A1\t\u000f\t5\u0013\u00031\u0001\u0003P\u0005\u0019B-\u001a3va2L7-\u0019;j_:\u0004VM]5pIB!!\u0011\u000bB4\u001d\u0011\u0011\u0019F!\u0019\u000f\t\tU#1\f\b\u0004\u001f\n]\u0013b\u0001B-7\u0006\u0011a/M\u0005\u0005\u0005;\u0012y&\u0001\u0005d_6l\u0017M\u001c3t\u0015\r\u0011IfW\u0005\u0005\u0005G\u0012)'\u0001\u0005D_6l\u0017M\u001c3t\u0015\u0011\u0011iFa\u0018\n\t\t\u001d#\u0011\u000e\u0006\u0005\u0005G\u0012)\u0007C\u0004\u0003nE\u0001\rAa\u001c\u00027=\u0004H/T1y\t\u0016$W\u000f\u001d7jG\u0006$\u0018n\u001c8EkJ\fG/[8o!\u00159\u0013q\u0013B9!\u0011\u0011\u0019H! \u000e\u0005\tU$\u0002\u0002B<\u0005s\nA\u0001^5nK*\u0011!1P\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0000\tU$\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u000bm\f\u0002\u0019A8\u0002%Y\fG.\u001b3bi\u0016LE-\u001a8uS\u001aLWM\u001d\u000b\u0005\u0005\u000f\u0013\u0019\n\u0006\u0003\u0003\n\nE\u0005#\u0002\u001eC\u000b\n-\u0005\u0003BA\u0002\u0005\u001bKAAa$\u0002\u0018\tQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000b\u0001\u0014\u00029A1\t\u000f\tU%\u00031\u0001\u0003\u0018\u0006Q\u0011\u000eZ3oi&4\u0017.\u001a:\u0011\t\te%QT\u0007\u0003\u00057SA!!/\u0003`%!!q\u0012BN\u0003A1\u0015.\u001a7e-\u0006d\u0017\u000eZ1uS>t7\u000f\u0005\u0002/)M\u0011AC\n\u000b\u0003\u0005C\u000bQ!\u00199qYf$2a\rBV\u0011\u0015ac\u00031\u0001.\u0001")
public class FieldValidations {
    private final ErrorFactories errorFactories;

    public static FieldValidations apply(ErrorFactories errorFactories) {
        return FieldValidations$.MODULE$.apply(errorFactories);
    }

    public Either<StatusRuntimeException, Object> matchLedgerId(Object ledgerId, Object received, ContextualizedErrorLogger contextualizedErrorLogger) {
        return BoxesRunTime.equals((Object)ledgerId, (Object)received) ? package$.MODULE$.Right().apply(received) : package$.MODULE$.Left().apply((Object)this.errorFactories.ledgerIdMismatch(ledgerId, received, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger));
    }

    public Either<StatusRuntimeException, String> requireNonEmptyString(String s, String fieldName, ContextualizedErrorLogger contextualizedErrorLogger) {
        return package$.MODULE$.Either().cond(new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> s, (Function0 & Serializable & scala.Serializable)() -> $this.errorFactories.missingField(fieldName, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger));
    }

    public Either<StatusRuntimeException, String> requireIdentifier(String s, ContextualizedErrorLogger contextualizedErrorLogger) {
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        return Ref$.MODULE$.Name().fromString(s).left().map((Function1 & Serializable & scala.Serializable)message -> $this.errorFactories.invalidArgument((Option<Object>)some, (String)message, contextualizedErrorLogger));
    }

    public Either<StatusRuntimeException, String> requireName(String s, String fieldName, ContextualizedErrorLogger contextualizedErrorLogger) {
        return s.isEmpty() ? package$.MODULE$.Left().apply((Object)this.errorFactories.missingField(fieldName, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger)) : Ref$.MODULE$.Name().fromString(s).left().map((Function1 & Serializable & scala.Serializable)x$1 -> $this.errorFactories.invalidField(fieldName, (String)x$1, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger));
    }

    public Either<StatusRuntimeException, String> requirePackageId(String s, String fieldName, ContextualizedErrorLogger contextualizedErrorLogger) {
        return s.isEmpty() ? package$.MODULE$.Left().apply((Object)this.errorFactories.missingField(fieldName, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger)) : Ref$.MODULE$.PackageId().fromString(s).left().map((Function1 & Serializable & scala.Serializable)x$2 -> $this.errorFactories.invalidField(fieldName, (String)x$2, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger));
    }

    public Either<StatusRuntimeException, String> requireParty(String s, ContextualizedErrorLogger contextualizedErrorLogger) {
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        return Ref$.MODULE$.Party().fromString(s).left().map((Function1 & Serializable & scala.Serializable)message -> $this.errorFactories.invalidArgument((Option<Object>)some, (String)message, contextualizedErrorLogger));
    }

    public Either<StatusRuntimeException, Set<String>> requireParties(Set<String> parties, ContextualizedErrorLogger contextualizedErrorLogger) {
        return (Either)parties.foldLeft((Object)package$.MODULE$.Right().apply((Object)Predef$.MODULE$.Set().empty()), (Function2 & Serializable & scala.Serializable)(acc, partyTxt) -> acc.flatMap((Function1 & Serializable & scala.Serializable)parties -> this.requireParty((String)partyTxt, contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)party -> (Set)parties.$plus(party))));
    }

    public Either<StatusRuntimeException, String> requireLedgerString(String s, String fieldName, ContextualizedErrorLogger contextualizedErrorLogger) {
        return s.isEmpty() ? package$.MODULE$.Left().apply((Object)this.errorFactories.missingField(fieldName, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger)) : Ref$.MODULE$.LedgerString().fromString(s).left().map((Function1 & Serializable & scala.Serializable)x$3 -> $this.errorFactories.invalidField(fieldName, (String)x$3, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger));
    }

    public Either<StatusRuntimeException, String> requireLedgerString(String s, ContextualizedErrorLogger contextualizedErrorLogger) {
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        return Ref$.MODULE$.LedgerString().fromString(s).left().map((Function1 & Serializable & scala.Serializable)message -> $this.errorFactories.invalidArgument((Option<Object>)some, (String)message, contextualizedErrorLogger));
    }

    public Either<StatusRuntimeException, Option<Object>> validateSubmissionId(String s, ContextualizedErrorLogger contextualizedErrorLogger) {
        return s.isEmpty() ? package$.MODULE$.Right().apply((Object)None$.MODULE$) : Ref$.MODULE$.SubmissionId().fromString(s).map((Function1 & Serializable & scala.Serializable)submissionId -> new Some(domain$.MODULE$.SubmissionId().apply(submissionId))).left().map((Function1 & Serializable & scala.Serializable)x$4 -> $this.errorFactories.invalidField("submission_id", (String)x$4, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger));
    }

    public Either<StatusRuntimeException, Value.ContractId> requireContractId(String s, String fieldName, ContextualizedErrorLogger contextualizedErrorLogger) {
        return s.isEmpty() ? package$.MODULE$.Left().apply((Object)this.errorFactories.missingField(fieldName, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger)) : Value.ContractId$.MODULE$.fromString(s).left().map((Function1 & Serializable & scala.Serializable)x$5 -> $this.errorFactories.invalidField(fieldName, (String)x$5, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger));
    }

    public Either<StatusRuntimeException, Ref.DottedName> requireDottedName(String s, String fieldName, ContextualizedErrorLogger contextualizedErrorLogger) {
        return Ref.DottedName$.MODULE$.fromString(s).left().map((Function1 & Serializable & scala.Serializable)x$6 -> $this.errorFactories.invalidField(fieldName, (String)x$6, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger));
    }

    public <M extends Iterable<?>, T> Either<StatusRuntimeException, M> requireNonEmpty(M s, String fieldName, ContextualizedErrorLogger contextualizedErrorLogger) {
        return s.nonEmpty() ? package$.MODULE$.Right().apply(s) : package$.MODULE$.Left().apply((Object)this.errorFactories.missingField(fieldName, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger));
    }

    public <T> Either<StatusRuntimeException, T> requirePresence(Option<T> option, String fieldName, ContextualizedErrorLogger contextualizedErrorLogger) {
        return (Either)option.fold((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)$this.errorFactories.missingField(fieldName, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger)), (Function1 & Serializable & scala.Serializable)x$7 -> package$.MODULE$.Right().apply(x$7));
    }

    public Either<StatusRuntimeException, DeduplicationPeriod> validateDeduplicationPeriod(Commands.DeduplicationPeriod deduplicationPeriod, Option<java.time.Duration> optMaxDeduplicationDuration, String fieldName, ContextualizedErrorLogger contextualizedErrorLogger) {
        return (Either)optMaxDeduplicationDuration.fold((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)$this.errorFactories.missingLedgerConfig(Status.Code.UNAVAILABLE, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger)), (Function1 & Serializable & scala.Serializable)maxDeduplicationDuration -> {
            Right right;
            Commands.DeduplicationPeriod deduplicationPeriod = deduplicationPeriod;
            if (Commands.DeduplicationPeriod$.Empty$.MODULE$.equals(deduplicationPeriod)) {
                right = package$.MODULE$.Right().apply((Object)new DeduplicationPeriod.DeduplicationDuration(maxDeduplicationDuration));
            } else if (deduplicationPeriod instanceof Commands.DeduplicationPeriod$.DeduplicationTime) {
                Commands.DeduplicationPeriod$.DeduplicationTime deduplicationTime = (Commands.DeduplicationPeriod$.DeduplicationTime)deduplicationPeriod;
                Duration duration = deduplicationTime.value();
                right = this.protoDurationToDurationPeriod$1(duration, (java.time.Duration)maxDeduplicationDuration, fieldName, contextualizedErrorLogger);
            } else if (deduplicationPeriod instanceof Commands.DeduplicationPeriod$.DeduplicationDuration) {
                Commands.DeduplicationPeriod$.DeduplicationDuration deduplicationDuration = (Commands.DeduplicationPeriod$.DeduplicationDuration)deduplicationPeriod;
                Duration duration = deduplicationDuration.value();
                right = this.protoDurationToDurationPeriod$1(duration, (java.time.Duration)maxDeduplicationDuration, fieldName, contextualizedErrorLogger);
            } else {
                throw new MatchError((Object)deduplicationPeriod);
            }
            return right;
        });
    }

    public Either<StatusRuntimeException, Ref.Identifier> validateIdentifier(Identifier identifier, ContextualizedErrorLogger contextualizedErrorLogger) {
        return this.requirePackageId(identifier.packageId(), "package_id", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)packageId -> this.requireDottedName(identifier.moduleName(), "module_name", contextualizedErrorLogger).flatMap((Function1 & Serializable & scala.Serializable)mn -> this.requireDottedName(identifier.entityName(), "entity_name", contextualizedErrorLogger).map((Function1 & Serializable & scala.Serializable)en -> new Ref.Identifier(packageId, Ref.QualifiedName$.MODULE$.apply(mn, en)))));
    }

    private final Either validateDuration$1(java.time.Duration duration, String exceedsMaxDurationMessage, String fieldName$8, ContextualizedErrorLogger contextualizedErrorLogger$13, java.time.Duration maxDeduplicationDuration$1) {
        return duration.isNegative() ? package$.MODULE$.Left().apply((Object)this.errorFactories.invalidField(fieldName$8, "Duration must be positive", (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), contextualizedErrorLogger$13)) : (duration.compareTo(maxDeduplicationDuration$1) > 0 ? package$.MODULE$.Left().apply((Object)this.errorFactories.invalidDeduplicationDuration(fieldName$8, exceedsMaxDurationMessage, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), maxDeduplicationDuration$1, contextualizedErrorLogger$13)) : package$.MODULE$.Right().apply((Object)duration));
    }

    private final Either protoDurationToDurationPeriod$1(Duration duration, java.time.Duration maxDeduplicationDuration$1, String fieldName$8, ContextualizedErrorLogger contextualizedErrorLogger$13) {
        java.time.Duration result = DurationConversion$.MODULE$.fromProto(duration);
        return this.validateDuration$1(result, new StringBuilder(79).append("The given deduplication duration of ").append(result).append(" exceeds the maximum deduplication time of ").append(maxDeduplicationDuration$1).toString(), fieldName$8, contextualizedErrorLogger$13, maxDeduplicationDuration$1).map((Function1)DeduplicationPeriod.DeduplicationDuration$.MODULE$);
    }

    public FieldValidations(ErrorFactories errorFactories) {
        this.errorFactories = errorFactories;
    }
}

