/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.serialization;

import com.daml.crypto.MessageDigestPrototype$;
import com.daml.lf.data.Bytes$;
import com.daml.lf.data.FrontStack;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.SortedLookupList;
import com.daml.lf.data.Time;
import com.daml.lf.data.Utf8$;
import com.daml.lf.data.package$;
import com.daml.lf.transaction.GlobalKey;
import com.daml.lf.value.Value;
import com.daml.platform.store.serialization.KeyHasher;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;

public final class KeyHasher$
implements KeyHasher {
    public static KeyHasher$ MODULE$;

    static {
        new KeyHasher$();
    }

    @Override
    public String hashKeyString(GlobalKey key) {
        return KeyHasher.hashKeyString$(this, key);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public <T> T foldLeft(Value value, T z, Function2<T, KeyHasher.HashToken, T> op) {
        Option option;
        Object object;
        boolean bl = false;
        Value.ValueOptional valueOptional = null;
        Value value2 = value;
        if (value2 instanceof Value.ValueContractId) {
            Value.ValueContractId valueContractId = (Value.ValueContractId)value2;
            Value.ContractId v2 = valueContractId.value();
            object = op.apply(z, (Object)new KeyHasher.HashTokenText(v2.coid()));
            return (T)object;
        }
        if (value2 instanceof Value.ValueInt64) {
            Value.ValueInt64 valueInt64 = (Value.ValueInt64)value2;
            long v3 = valueInt64.value();
            object = op.apply(z, (Object)new KeyHasher.HashTokenLong(v3));
            return (T)object;
        }
        if (value2 instanceof Value.ValueNumeric) {
            Value.ValueNumeric valueNumeric = (Value.ValueNumeric)value2;
            BigDecimal v4 = valueNumeric.value();
            object = op.apply(z, (Object)new KeyHasher.HashTokenText(package$.MODULE$.Numeric().toUnscaledString(v4)));
            return (T)object;
        }
        if (value2 instanceof Value.ValueText) {
            Value.ValueText valueText = (Value.ValueText)value2;
            String v5 = valueText.value();
            object = op.apply(z, (Object)new KeyHasher.HashTokenText(v5));
            return (T)object;
        }
        if (value2 instanceof Value.ValueTimestamp) {
            Value.ValueTimestamp valueTimestamp = (Value.ValueTimestamp)value2;
            Time.Timestamp v6 = valueTimestamp.value();
            object = op.apply(z, (Object)new KeyHasher.HashTokenLong(v6.micros()));
            return (T)object;
        }
        if (value2 instanceof Value.ValueParty) {
            Value.ValueParty valueParty = (Value.ValueParty)value2;
            String v7 = valueParty.value();
            object = op.apply(z, (Object)new KeyHasher.HashTokenText(v7));
            return (T)object;
        }
        if (value2 instanceof Value.ValueBool) {
            Value.ValueBool valueBool = (Value.ValueBool)value2;
            boolean v8 = valueBool.value();
            object = op.apply(z, (Object)new KeyHasher.HashTokenByte(v8 ? (byte)1 : (byte)0));
            return (T)object;
        }
        if (value2 instanceof Value.ValueDate) {
            Value.ValueDate valueDate = (Value.ValueDate)value2;
            Time.Date v9 = valueDate.value();
            object = op.apply(z, (Object)new KeyHasher.HashTokenInt(v9.days()));
            return (T)object;
        }
        if (Value.ValueUnit$.MODULE$.equals(value2)) {
            object = op.apply(z, (Object)new KeyHasher.HashTokenByte(0));
            return (T)object;
        }
        if (value2 instanceof Value.ValueRecord) {
            Value.ValueRecord valueRecord = (Value.ValueRecord)value2;
            ImmArray fs = valueRecord.fields();
            Object z1 = op.apply(z, (Object)new KeyHasher.HashTokenCollectionBegin(fs.length()));
            Object z2 = fs.foldLeft(z1, (Function2 & Serializable & scala.Serializable)(t, v) -> MODULE$.foldLeft((Value)v._2(), t, op));
            object = op.apply(z2, (Object)new KeyHasher.HashTokenCollectionEnd());
            return (T)object;
        }
        if (value2 instanceof Value.ValueOptional) {
            bl = true;
            valueOptional = (Value.ValueOptional)value2;
            Option option2 = valueOptional.value();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Value v10 = (Value)some.value();
                Object z1 = op.apply(z, (Object)new KeyHasher.HashTokenCollectionBegin(1));
                Object z2 = this.foldLeft(v10, z1, op);
                object = op.apply(z2, (Object)new KeyHasher.HashTokenCollectionEnd());
                return (T)object;
            }
        }
        if (bl && None$.MODULE$.equals(option = valueOptional.value())) {
            Object z1 = op.apply(z, (Object)new KeyHasher.HashTokenCollectionBegin(0));
            object = op.apply(z1, (Object)new KeyHasher.HashTokenCollectionEnd());
            return (T)object;
        }
        if (value2 instanceof Value.ValueVariant) {
            Value.ValueVariant valueVariant = (Value.ValueVariant)value2;
            String variant = valueVariant.variant();
            Value v11 = valueVariant.value();
            Object z1 = op.apply(z, (Object)new KeyHasher.HashTokenCollectionBegin(1));
            Object z2 = op.apply(z1, (Object)new KeyHasher.HashTokenText(variant));
            Object z3 = this.foldLeft(v11, z2, op);
            object = op.apply(z3, (Object)new KeyHasher.HashTokenCollectionEnd());
            return (T)object;
        }
        if (value2 instanceof Value.ValueEnum) {
            Value.ValueEnum valueEnum = (Value.ValueEnum)value2;
            String value_ = valueEnum.value();
            object = op.apply(z, (Object)new KeyHasher.HashTokenText(value_));
            return (T)object;
        }
        if (value2 instanceof Value.ValueList) {
            Value.ValueList valueList = (Value.ValueList)value2;
            FrontStack xs = valueList.values();
            ImmArray arr = xs.toImmArray();
            Object z1 = op.apply(z, (Object)new KeyHasher.HashTokenCollectionBegin(xs.length()));
            Object z2 = arr.foldLeft(z1, (Function2 & Serializable & scala.Serializable)(t, v) -> MODULE$.foldLeft((Value)v, (Object)t, op));
            object = op.apply(z2, (Object)new KeyHasher.HashTokenCollectionEnd());
            return (T)object;
        }
        if (value2 instanceof Value.ValueTextMap) {
            Value.ValueTextMap valueTextMap = (Value.ValueTextMap)value2;
            SortedLookupList xs = valueTextMap.value();
            ImmArray arr = xs.toImmArray();
            Object z1 = op.apply(z, (Object)new KeyHasher.HashTokenCollectionBegin(arr.length()));
            Object z2 = arr.foldLeft(z1, (Function2 & Serializable & scala.Serializable)(t, v) -> {
                Object zz1 = op.apply(t, (Object)new KeyHasher.HashTokenText((String)v._1()));
                return MODULE$.foldLeft((Value)v._2(), zz1, op);
            });
            object = op.apply(z2, (Object)new KeyHasher.HashTokenCollectionEnd());
            return (T)object;
        }
        if (!(value2 instanceof Value.ValueGenMap)) throw new MatchError((Object)value2);
        Value.ValueGenMap valueGenMap = (Value.ValueGenMap)value2;
        ImmArray entries = valueGenMap.entries();
        Object z1 = op.apply(z, (Object)new KeyHasher.HashTokenCollectionBegin(entries.length()));
        Object z2 = entries.foldLeft(z1, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Object t;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    t = tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Value k = (Value)tuple2._1();
            Value v = (Value)tuple2._2();
            Object object = MODULE$.foldLeft(k, MODULE$.foldLeft(v, t, op), op);
            return object;
        });
        object = op.apply(z2, (Object)new KeyHasher.HashTokenCollectionEnd());
        return (T)object;
    }

    private void putInt(MessageDigest digest, int value) {
        digest.update(ByteBuffer.allocate(4).putInt(value).array());
    }

    private void putLong(MessageDigest digest, long value) {
        digest.update(ByteBuffer.allocate(8).putLong(value).array());
    }

    private void putString(MessageDigest digest, String value) {
        ByteString bytes = Utf8$.MODULE$.getBytes(value);
        this.putInt(digest, Bytes$.MODULE$.length$extension(bytes));
        digest.update(Bytes$.MODULE$.toByteBuffer$extension(bytes));
    }

    public MessageDigest putValue(MessageDigest digest, Value value) {
        return this.foldLeft(value, digest, (Function2 & Serializable & scala.Serializable)(d, token) -> {
            KeyHasher.HashToken hashToken = token;
            if (hashToken instanceof KeyHasher.HashTokenByte) {
                KeyHasher.HashTokenByte hashTokenByte = (KeyHasher.HashTokenByte)hashToken;
                byte v = hashTokenByte.value();
                d.update(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (hashToken instanceof KeyHasher.HashTokenInt) {
                KeyHasher.HashTokenInt hashTokenInt = (KeyHasher.HashTokenInt)hashToken;
                int v = hashTokenInt.value();
                MODULE$.putInt((MessageDigest)d, v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (hashToken instanceof KeyHasher.HashTokenLong) {
                KeyHasher.HashTokenLong hashTokenLong = (KeyHasher.HashTokenLong)hashToken;
                long v = hashTokenLong.value();
                MODULE$.putLong((MessageDigest)d, v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (hashToken instanceof KeyHasher.HashTokenText) {
                KeyHasher.HashTokenText hashTokenText = (KeyHasher.HashTokenText)hashToken;
                String v = hashTokenText.value();
                MODULE$.putString((MessageDigest)d, v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (hashToken instanceof KeyHasher.HashTokenCollectionBegin) {
                KeyHasher.HashTokenCollectionBegin hashTokenCollectionBegin = (KeyHasher.HashTokenCollectionBegin)hashToken;
                int length = hashTokenCollectionBegin.length();
                MODULE$.putInt((MessageDigest)d, length);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (hashToken instanceof KeyHasher.HashTokenCollectionEnd) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)hashToken);
            }
            return d;
        });
    }

    @Override
    public byte[] hashKey(GlobalKey key) {
        MessageDigest digest = MessageDigestPrototype$.MODULE$.SHA_256().newDigest();
        this.putString(digest, key.templateId().packageId());
        this.putString(digest, key.templateId().qualifiedName().toString());
        this.putValue(digest, key.key());
        return digest.digest();
    }

    private KeyHasher$() {
        MODULE$ = this;
        KeyHasher.$init$(this);
    }
}

