/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.error;

import com.databricks.internal.apache.commons.io.IOUtils;
import com.databricks.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.internal.sdk.core.DatabricksError;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.error.ApiErrorBody;
import com.databricks.internal.sdk.core.error.ErrorMapper;
import com.databricks.internal.sdk.core.error.PrivateLinkInfo;
import com.databricks.internal.sdk.core.error.details.ErrorDetails;
import com.databricks.internal.sdk.core.http.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApiErrors {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Pattern HTML_ERROR_REGEX = Pattern.compile("<pre>(.*)</pre>");
    private static final ErrorMapper ERROR_MAPPER = new ErrorMapper();

    public static DatabricksError getDatabricksError(Response out, Exception error) {
        if (error != null) {
            return new DatabricksError("IO_ERROR", 523, error);
        }
        if (out.getStatusCode() == 429) {
            return new DatabricksError("TOO_MANY_REQUESTS", "Current request has to be retried", 429);
        }
        ApiErrorBody errorBody = ApiErrors.readErrorFromResponse(out);
        return ERROR_MAPPER.apply(out, errorBody);
    }

    private static ApiErrorBody readErrorFromResponse(Response response) {
        if (PrivateLinkInfo.isPrivateLinkRedirect(response)) {
            return new ApiErrorBody();
        }
        ApiErrorBody errorBody = ApiErrors.parseApiError(response);
        if (errorBody.getApi12Error() != null && !errorBody.getApi12Error().isEmpty()) {
            errorBody.setMessage(errorBody.getApi12Error());
        }
        if (errorBody.getMessage() == null || errorBody.getMessage().isEmpty()) {
            if (errorBody.getScimDetail() != null && !"null".equals(errorBody.getScimDetail())) {
                errorBody.setMessage(errorBody.getScimDetail());
            } else {
                errorBody.setMessage("SCIM API Internal Error");
            }
            String message = errorBody.getScimType() + " " + errorBody.getMessage();
            errorBody.setMessage(message.trim());
            errorBody.setErrorCode("SCIM_" + errorBody.getScimStatus());
        }
        if (errorBody.getErrorDetails() == null) {
            errorBody.setErrorDetails(ErrorDetails.builder().build());
        }
        return errorBody;
    }

    private static ApiErrorBody parseApiError(Response response) {
        try {
            InputStream in = response.getBody();
            if (in == null) {
                ApiErrorBody errorBody = new ApiErrorBody();
                errorBody.setMessage(String.format("Status response from server: %s", response.getStatus()));
                return errorBody;
            }
            String body = IOUtils.toString(in, StandardCharsets.UTF_8);
            try {
                return MAPPER.readValue(body, ApiErrorBody.class);
            }
            catch (IOException e) {
                return ApiErrors.parseUnknownError(response, body, e);
            }
        }
        catch (IOException e) {
            throw new DatabricksException("Unable to read response body", e);
        }
    }

    private static ApiErrorBody parseUnknownError(Response response, String body, IOException err) {
        ApiErrorBody errorBody = new ApiErrorBody();
        String[] statusParts = response.getStatus().split(" ", 2);
        if (statusParts.length < 2) {
            errorBody.setErrorCode("UNKNOWN");
        } else {
            String errorCode = statusParts[1].replaceAll("^[ .]+|[ .]+$", "");
            errorBody.setErrorCode(errorCode.replaceAll(" ", "_").toUpperCase());
        }
        Matcher messageMatcher = HTML_ERROR_REGEX.matcher(body);
        if (messageMatcher.find()) {
            errorBody.setMessage(messageMatcher.group(1).replaceAll("^[ .]+|[ .]+$", ""));
        } else {
            errorBody.setMessage(String.format("Response from server (%s) %s: %s", response.getStatus(), body, err.getMessage()));
        }
        return errorBody;
    }
}

