/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow.incubator;

import com.databricks.internal.apache.hc.client5.http.async.methods.AbstractBinResponseConsumer;
import com.databricks.internal.apache.hc.core5.http.ContentType;
import com.databricks.internal.apache.hc.core5.http.HttpException;
import com.databricks.internal.apache.hc.core5.http.HttpResponse;
import com.databricks.jdbc.api.impl.arrow.incubator.ArrowResultChunkV2;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

class StreamingResponseConsumer
extends AbstractBinResponseConsumer<byte[]> {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(StreamingResponseConsumer.class);
    private final ArrowResultChunkV2 chunk;
    private long bytesReceived = 0L;
    private final ByteArrayOutputStream byteOutputStream;

    public StreamingResponseConsumer(ArrowResultChunkV2 chunk) {
        this.chunk = chunk;
        this.byteOutputStream = new ByteArrayOutputStream();
    }

    @Override
    protected void start(HttpResponse response, ContentType contentType) throws HttpException {
        if (response.getCode() != 200) {
            throw new HttpException("Unexpected response status: " + response.getCode());
        }
        this.chunk.downloadStartTime = System.nanoTime();
    }

    @Override
    protected int capacityIncrement() {
        return 0x100000;
    }

    @Override
    protected void data(ByteBuffer data, boolean endOfStream) throws IOException {
        try {
            int currentBatch = data.remaining();
            this.bytesReceived += (long)currentBatch;
            byte[] bytes = new byte[currentBatch];
            data.get(bytes);
            this.byteOutputStream.write(bytes);
            if (endOfStream) {
                this.chunk.downloadEndTime = System.nanoTime();
                this.chunk.bytesDownloaded = this.bytesReceived;
                this.logDownloadStats();
            }
        }
        catch (IOException e) {
            this.failed(e);
            throw e;
        }
    }

    @Override
    protected byte[] buildResult() {
        return this.byteOutputStream.toByteArray();
    }

    @Override
    public void failed(Exception cause) {
        this.byteOutputStream.reset();
    }

    @Override
    public void releaseResources() {
        this.byteOutputStream.reset();
    }

    private void logDownloadStats() {
        double durationMs = (double)(this.chunk.downloadEndTime - this.chunk.downloadStartTime) / 1000000.0;
        double speedMBps = (double)this.chunk.bytesDownloaded / 1024.0 / 1024.0 / (durationMs / 1000.0);
        LOGGER.debug("Download stats for chunk %s: Size: %s MB, Duration: %s ms, Speed: %s MB/s", this.chunk.getChunkIndex(), (double)this.chunk.bytesDownloaded / 1024.0 / 1024.0, durationMs, speedMBps);
    }
}

