/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class AdAssetDescription
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="text")
    private String mText = null;
    @SerializedName(value="url_tags")
    private String mUrlTags = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAssetDescription loadJSON(String json, APIContext context, String header) {
        AdAssetDescription adAssetDescription = (AdAssetDescription)AdAssetDescription.getGson().fromJson(json, AdAssetDescription.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAssetDescription.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAssetDescription.context = context;
        adAssetDescription.rawValue = json;
        adAssetDescription.header = header;
        return adAssetDescription;
    }

    public static APINodeList<AdAssetDescription> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAssetDescription> adAssetDescriptions = new APINodeList<AdAssetDescription>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAssetDescriptions.add(AdAssetDescription.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adAssetDescriptions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAssetDescriptions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAssetDescriptions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAssetDescriptions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAssetDescriptions.add(AdAssetDescription.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAssetDescriptions.add(AdAssetDescription.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAssetDescriptions.add(AdAssetDescription.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adAssetDescriptions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAssetDescriptions.add(AdAssetDescription.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adAssetDescriptions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAssetDescriptions.add(AdAssetDescription.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAssetDescriptions;
                }
                adAssetDescriptions.clear();
                adAssetDescriptions.add(AdAssetDescription.loadJSON(json, context, header));
                return adAssetDescriptions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAssetDescription.getGson().toJson((Object)this);
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdAssetDescription setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldText() {
        return this.mText;
    }

    public AdAssetDescription setFieldText(String value) {
        this.mText = value;
        return this;
    }

    public String getFieldUrlTags() {
        return this.mUrlTags;
    }

    public AdAssetDescription setFieldUrlTags(String value) {
        this.mUrlTags = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAssetDescription copyFrom(AdAssetDescription instance) {
        this.mId = instance.mId;
        this.mText = instance.mText;
        this.mUrlTags = instance.mUrlTags;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAssetDescription> getParser() {
        return new APIRequest.ResponseParser<AdAssetDescription>(){

            @Override
            public APINodeList<AdAssetDescription> parseResponse(String response, APIContext context, APIRequest<AdAssetDescription> request, String header) throws APIException.MalformedResponseException {
                return AdAssetDescription.parseResponse(response, context, request, header);
            }
        };
    }
}

