/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdCreationPackageConfig
extends APINode {
    @SerializedName(value="api_version")
    private String mApiVersion = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_eligible_for_default_opt_in")
    private Boolean mIsEligibleForDefaultOptIn = null;
    @SerializedName(value="objective")
    private String mObjective = null;
    @SerializedName(value="package_id")
    private String mPackageId = null;
    @SerializedName(value="status")
    private String mStatus = null;
    protected static Gson gson = null;

    AdCreationPackageConfig() {
    }

    public AdCreationPackageConfig(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCreationPackageConfig(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCreationPackageConfig fetch() throws APIException {
        AdCreationPackageConfig newInstance = AdCreationPackageConfig.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCreationPackageConfig fetchById(Long id, APIContext context) throws APIException {
        return AdCreationPackageConfig.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCreationPackageConfig> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCreationPackageConfig.fetchByIdAsync(id.toString(), context);
    }

    public static AdCreationPackageConfig fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCreationPackageConfig> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCreationPackageConfig> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCreationPackageConfig>(context, "", "/", "GET", AdCreationPackageConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCreationPackageConfig>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCreationPackageConfig>(context, "", "/", "GET", AdCreationPackageConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreationPackageConfig loadJSON(String json, APIContext context, String header) {
        AdCreationPackageConfig adCreationPackageConfig = (AdCreationPackageConfig)AdCreationPackageConfig.getGson().fromJson(json, AdCreationPackageConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreationPackageConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreationPackageConfig.context = context;
        adCreationPackageConfig.rawValue = json;
        adCreationPackageConfig.header = header;
        return adCreationPackageConfig;
    }

    public static APINodeList<AdCreationPackageConfig> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreationPackageConfig> adCreationPackageConfigs = new APINodeList<AdCreationPackageConfig>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreationPackageConfigs.add(AdCreationPackageConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCreationPackageConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreationPackageConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreationPackageConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreationPackageConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreationPackageConfigs.add(AdCreationPackageConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreationPackageConfigs.add(AdCreationPackageConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreationPackageConfigs.add(AdCreationPackageConfig.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCreationPackageConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreationPackageConfigs.add(AdCreationPackageConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCreationPackageConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreationPackageConfigs.add(AdCreationPackageConfig.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreationPackageConfigs;
                }
                adCreationPackageConfigs.clear();
                adCreationPackageConfigs.add(AdCreationPackageConfig.loadJSON(json, context, header));
                return adCreationPackageConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreationPackageConfig.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldApiVersion() {
        return this.mApiVersion;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsEligibleForDefaultOptIn() {
        return this.mIsEligibleForDefaultOptIn;
    }

    public String getFieldObjective() {
        return this.mObjective;
    }

    public String getFieldPackageId() {
        return this.mPackageId;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreationPackageConfig copyFrom(AdCreationPackageConfig instance) {
        this.mApiVersion = instance.mApiVersion;
        this.mId = instance.mId;
        this.mIsEligibleForDefaultOptIn = instance.mIsEligibleForDefaultOptIn;
        this.mObjective = instance.mObjective;
        this.mPackageId = instance.mPackageId;
        this.mStatus = instance.mStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreationPackageConfig> getParser() {
        return new APIRequest.ResponseParser<AdCreationPackageConfig>(){

            @Override
            public APINodeList<AdCreationPackageConfig> parseResponse(String response, APIContext context, APIRequest<AdCreationPackageConfig> request, String header) throws APIException.MalformedResponseException {
                return AdCreationPackageConfig.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<AdCreationPackageConfig> {
        AdCreationPackageConfig lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"api_version", "id", "is_eligible_for_default_opt_in", "objective", "package_id", "status"};

        @Override
        public AdCreationPackageConfig getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreationPackageConfig parseResponse(String response, String header) throws APIException {
            return AdCreationPackageConfig.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdCreationPackageConfig execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreationPackageConfig execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdCreationPackageConfig> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCreationPackageConfig> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdCreationPackageConfig>(){

                public AdCreationPackageConfig apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestApiVersionField() {
            return this.requestApiVersionField(true);
        }

        public APIRequestGet requestApiVersionField(boolean value) {
            this.requestField("api_version", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsEligibleForDefaultOptInField() {
            return this.requestIsEligibleForDefaultOptInField(true);
        }

        public APIRequestGet requestIsEligibleForDefaultOptInField(boolean value) {
            this.requestField("is_eligible_for_default_opt_in", value);
            return this;
        }

        public APIRequestGet requestObjectiveField() {
            return this.requestObjectiveField(true);
        }

        public APIRequestGet requestObjectiveField(boolean value) {
            this.requestField("objective", value);
            return this;
        }

        public APIRequestGet requestPackageIdField() {
            return this.requestPackageIdField(true);
        }

        public APIRequestGet requestPackageIdField(boolean value) {
            this.requestField("package_id", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }
    }
}

