/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdRuleHistoryResultAction;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class AdRuleHistoryResult
extends APINode {
    @SerializedName(value="actions")
    private List<AdRuleHistoryResultAction> mActions = null;
    @SerializedName(value="object_id")
    private String mObjectId = null;
    @SerializedName(value="object_type")
    private EnumObjectType mObjectType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdRuleHistoryResult loadJSON(String json, APIContext context, String header) {
        AdRuleHistoryResult adRuleHistoryResult = (AdRuleHistoryResult)AdRuleHistoryResult.getGson().fromJson(json, AdRuleHistoryResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adRuleHistoryResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adRuleHistoryResult.context = context;
        adRuleHistoryResult.rawValue = json;
        adRuleHistoryResult.header = header;
        return adRuleHistoryResult;
    }

    public static APINodeList<AdRuleHistoryResult> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdRuleHistoryResult> adRuleHistoryResults = new APINodeList<AdRuleHistoryResult>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adRuleHistoryResults.add(AdRuleHistoryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adRuleHistoryResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adRuleHistoryResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adRuleHistoryResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adRuleHistoryResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adRuleHistoryResults.add(AdRuleHistoryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adRuleHistoryResults.add(AdRuleHistoryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adRuleHistoryResults.add(AdRuleHistoryResult.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adRuleHistoryResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adRuleHistoryResults.add(AdRuleHistoryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adRuleHistoryResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adRuleHistoryResults.add(AdRuleHistoryResult.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adRuleHistoryResults;
                }
                adRuleHistoryResults.clear();
                adRuleHistoryResults.add(AdRuleHistoryResult.loadJSON(json, context, header));
                return adRuleHistoryResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdRuleHistoryResult.getGson().toJson((Object)this);
    }

    public List<AdRuleHistoryResultAction> getFieldActions() {
        return this.mActions;
    }

    public AdRuleHistoryResult setFieldActions(List<AdRuleHistoryResultAction> value) {
        this.mActions = value;
        return this;
    }

    public AdRuleHistoryResult setFieldActions(String value) {
        Type type = new TypeToken<List<AdRuleHistoryResultAction>>(){}.getType();
        this.mActions = (List)AdRuleHistoryResultAction.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldObjectId() {
        return this.mObjectId;
    }

    public AdRuleHistoryResult setFieldObjectId(String value) {
        this.mObjectId = value;
        return this;
    }

    public EnumObjectType getFieldObjectType() {
        return this.mObjectType;
    }

    public AdRuleHistoryResult setFieldObjectType(EnumObjectType value) {
        this.mObjectType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdRuleHistoryResult copyFrom(AdRuleHistoryResult instance) {
        this.mActions = instance.mActions;
        this.mObjectId = instance.mObjectId;
        this.mObjectType = instance.mObjectType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdRuleHistoryResult> getParser() {
        return new APIRequest.ResponseParser<AdRuleHistoryResult>(){

            @Override
            public APINodeList<AdRuleHistoryResult> parseResponse(String response, APIContext context, APIRequest<AdRuleHistoryResult> request, String header) throws APIException.MalformedResponseException {
                return AdRuleHistoryResult.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumObjectType {
        VALUE_AD("AD"),
        VALUE_ADSET("ADSET"),
        VALUE_CAMPAIGN("CAMPAIGN");

        private String value;

        private EnumObjectType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

