/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AudioRelease
extends APINode {
    @SerializedName(value="album_title")
    private String mAlbumTitle = null;
    @SerializedName(value="asset_availability_status")
    private List<Map<Long, Object>> mAssetAvailabilityStatus = null;
    @SerializedName(value="audio_availability_status")
    private String mAudioAvailabilityStatus = null;
    @SerializedName(value="audio_release_image_uri")
    private String mAudioReleaseImageUri = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="displayed_artist")
    private String mDisplayedArtist = null;
    @SerializedName(value="ean")
    private String mEan = null;
    @SerializedName(value="genre")
    private String mGenre = null;
    @SerializedName(value="grid")
    private String mGrid = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="isrc")
    private String mIsrc = null;
    @SerializedName(value="label_name")
    private String mLabelName = null;
    @SerializedName(value="original_release_date")
    private String mOriginalReleaseDate = null;
    @SerializedName(value="parental_warning_type")
    private String mParentalWarningType = null;
    @SerializedName(value="proprietary_id")
    private String mProprietaryId = null;
    @SerializedName(value="upc")
    private String mUpc = null;
    protected static Gson gson = null;

    AudioRelease() {
    }

    public AudioRelease(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AudioRelease(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AudioRelease fetch() throws APIException {
        AudioRelease newInstance = AudioRelease.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AudioRelease fetchById(Long id, APIContext context) throws APIException {
        return AudioRelease.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AudioRelease> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AudioRelease.fetchByIdAsync(id.toString(), context);
    }

    public static AudioRelease fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AudioRelease> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AudioRelease> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AudioRelease>(context, "", "/", "GET", AudioRelease.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AudioRelease>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AudioRelease>(context, "", "/", "GET", AudioRelease.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AudioRelease loadJSON(String json, APIContext context, String header) {
        AudioRelease audioRelease = (AudioRelease)AudioRelease.getGson().fromJson(json, AudioRelease.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(audioRelease.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        audioRelease.context = context;
        audioRelease.rawValue = json;
        audioRelease.header = header;
        return audioRelease;
    }

    public static APINodeList<AudioRelease> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AudioRelease> audioReleases = new APINodeList<AudioRelease>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        audioReleases.add(AudioRelease.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return audioReleases;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            audioReleases.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        audioReleases.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            audioReleases.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            audioReleases.add(AudioRelease.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                audioReleases.add(AudioRelease.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            audioReleases.add(AudioRelease.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return audioReleases;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        audioReleases.add(AudioRelease.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return audioReleases;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        audioReleases.add(AudioRelease.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return audioReleases;
                }
                audioReleases.clear();
                audioReleases.add(AudioRelease.loadJSON(json, context, header));
                return audioReleases;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AudioRelease.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAlbumTitle() {
        return this.mAlbumTitle;
    }

    public List<Map<Long, Object>> getFieldAssetAvailabilityStatus() {
        return this.mAssetAvailabilityStatus;
    }

    public String getFieldAudioAvailabilityStatus() {
        return this.mAudioAvailabilityStatus;
    }

    public String getFieldAudioReleaseImageUri() {
        return this.mAudioReleaseImageUri;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDisplayedArtist() {
        return this.mDisplayedArtist;
    }

    public String getFieldEan() {
        return this.mEan;
    }

    public String getFieldGenre() {
        return this.mGenre;
    }

    public String getFieldGrid() {
        return this.mGrid;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldIsrc() {
        return this.mIsrc;
    }

    public String getFieldLabelName() {
        return this.mLabelName;
    }

    public String getFieldOriginalReleaseDate() {
        return this.mOriginalReleaseDate;
    }

    public String getFieldParentalWarningType() {
        return this.mParentalWarningType;
    }

    public String getFieldProprietaryId() {
        return this.mProprietaryId;
    }

    public String getFieldUpc() {
        return this.mUpc;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AudioRelease copyFrom(AudioRelease instance) {
        this.mAlbumTitle = instance.mAlbumTitle;
        this.mAssetAvailabilityStatus = instance.mAssetAvailabilityStatus;
        this.mAudioAvailabilityStatus = instance.mAudioAvailabilityStatus;
        this.mAudioReleaseImageUri = instance.mAudioReleaseImageUri;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDisplayedArtist = instance.mDisplayedArtist;
        this.mEan = instance.mEan;
        this.mGenre = instance.mGenre;
        this.mGrid = instance.mGrid;
        this.mId = instance.mId;
        this.mIsrc = instance.mIsrc;
        this.mLabelName = instance.mLabelName;
        this.mOriginalReleaseDate = instance.mOriginalReleaseDate;
        this.mParentalWarningType = instance.mParentalWarningType;
        this.mProprietaryId = instance.mProprietaryId;
        this.mUpc = instance.mUpc;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AudioRelease> getParser() {
        return new APIRequest.ResponseParser<AudioRelease>(){

            @Override
            public APINodeList<AudioRelease> parseResponse(String response, APIContext context, APIRequest<AudioRelease> request, String header) throws APIException.MalformedResponseException {
                return AudioRelease.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<AudioRelease> {
        AudioRelease lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"album_title", "asset_availability_status", "audio_availability_status", "audio_release_image_uri", "created_time", "displayed_artist", "ean", "genre", "grid", "id", "isrc", "label_name", "original_release_date", "parental_warning_type", "proprietary_id", "upc"};

        @Override
        public AudioRelease getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AudioRelease parseResponse(String response, String header) throws APIException {
            return AudioRelease.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AudioRelease execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AudioRelease execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AudioRelease> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AudioRelease> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AudioRelease>(){

                public AudioRelease apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAlbumTitleField() {
            return this.requestAlbumTitleField(true);
        }

        public APIRequestGet requestAlbumTitleField(boolean value) {
            this.requestField("album_title", value);
            return this;
        }

        public APIRequestGet requestAssetAvailabilityStatusField() {
            return this.requestAssetAvailabilityStatusField(true);
        }

        public APIRequestGet requestAssetAvailabilityStatusField(boolean value) {
            this.requestField("asset_availability_status", value);
            return this;
        }

        public APIRequestGet requestAudioAvailabilityStatusField() {
            return this.requestAudioAvailabilityStatusField(true);
        }

        public APIRequestGet requestAudioAvailabilityStatusField(boolean value) {
            this.requestField("audio_availability_status", value);
            return this;
        }

        public APIRequestGet requestAudioReleaseImageUriField() {
            return this.requestAudioReleaseImageUriField(true);
        }

        public APIRequestGet requestAudioReleaseImageUriField(boolean value) {
            this.requestField("audio_release_image_uri", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDisplayedArtistField() {
            return this.requestDisplayedArtistField(true);
        }

        public APIRequestGet requestDisplayedArtistField(boolean value) {
            this.requestField("displayed_artist", value);
            return this;
        }

        public APIRequestGet requestEanField() {
            return this.requestEanField(true);
        }

        public APIRequestGet requestEanField(boolean value) {
            this.requestField("ean", value);
            return this;
        }

        public APIRequestGet requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGet requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGet requestGridField() {
            return this.requestGridField(true);
        }

        public APIRequestGet requestGridField(boolean value) {
            this.requestField("grid", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsrcField() {
            return this.requestIsrcField(true);
        }

        public APIRequestGet requestIsrcField(boolean value) {
            this.requestField("isrc", value);
            return this;
        }

        public APIRequestGet requestLabelNameField() {
            return this.requestLabelNameField(true);
        }

        public APIRequestGet requestLabelNameField(boolean value) {
            this.requestField("label_name", value);
            return this;
        }

        public APIRequestGet requestOriginalReleaseDateField() {
            return this.requestOriginalReleaseDateField(true);
        }

        public APIRequestGet requestOriginalReleaseDateField(boolean value) {
            this.requestField("original_release_date", value);
            return this;
        }

        public APIRequestGet requestParentalWarningTypeField() {
            return this.requestParentalWarningTypeField(true);
        }

        public APIRequestGet requestParentalWarningTypeField(boolean value) {
            this.requestField("parental_warning_type", value);
            return this;
        }

        public APIRequestGet requestProprietaryIdField() {
            return this.requestProprietaryIdField(true);
        }

        public APIRequestGet requestProprietaryIdField(boolean value) {
            this.requestField("proprietary_id", value);
            return this;
        }

        public APIRequestGet requestUpcField() {
            return this.requestUpcField(true);
        }

        public APIRequestGet requestUpcField(boolean value) {
            this.requestField("upc", value);
            return this;
        }
    }
}

