/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class BusinessCreative
extends APINode {
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="duration")
    private Long mDuration = null;
    @SerializedName(value="hash")
    private String mHash = null;
    @SerializedName(value="height")
    private Long mHeight = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="thumbnail")
    private String mThumbnail = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="video_id")
    private String mVideoId = null;
    @SerializedName(value="width")
    private Long mWidth = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessCreative loadJSON(String json, APIContext context, String header) {
        BusinessCreative businessCreative = (BusinessCreative)BusinessCreative.getGson().fromJson(json, BusinessCreative.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessCreative.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessCreative.context = context;
        businessCreative.rawValue = json;
        businessCreative.header = header;
        return businessCreative;
    }

    public static APINodeList<BusinessCreative> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessCreative> businessCreatives = new APINodeList<BusinessCreative>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessCreatives.add(BusinessCreative.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessCreatives;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessCreatives.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessCreatives.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessCreatives.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessCreatives.add(BusinessCreative.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessCreatives.add(BusinessCreative.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessCreatives.add(BusinessCreative.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessCreatives;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessCreatives.add(BusinessCreative.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessCreatives;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessCreatives.add(BusinessCreative.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessCreatives;
                }
                businessCreatives.clear();
                businessCreatives.add(BusinessCreative.loadJSON(json, context, header));
                return businessCreatives;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessCreative.getGson().toJson((Object)this);
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public BusinessCreative setFieldCreationTime(String value) {
        this.mCreationTime = value;
        return this;
    }

    public Long getFieldDuration() {
        return this.mDuration;
    }

    public BusinessCreative setFieldDuration(Long value) {
        this.mDuration = value;
        return this;
    }

    public String getFieldHash() {
        return this.mHash;
    }

    public BusinessCreative setFieldHash(String value) {
        this.mHash = value;
        return this;
    }

    public Long getFieldHeight() {
        return this.mHeight;
    }

    public BusinessCreative setFieldHeight(Long value) {
        this.mHeight = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public BusinessCreative setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public BusinessCreative setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldThumbnail() {
        return this.mThumbnail;
    }

    public BusinessCreative setFieldThumbnail(String value) {
        this.mThumbnail = value;
        return this;
    }

    public String getFieldType() {
        return this.mType;
    }

    public BusinessCreative setFieldType(String value) {
        this.mType = value;
        return this;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public BusinessCreative setFieldUrl(String value) {
        this.mUrl = value;
        return this;
    }

    public String getFieldVideoId() {
        return this.mVideoId;
    }

    public BusinessCreative setFieldVideoId(String value) {
        this.mVideoId = value;
        return this;
    }

    public Long getFieldWidth() {
        return this.mWidth;
    }

    public BusinessCreative setFieldWidth(Long value) {
        this.mWidth = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessCreative copyFrom(BusinessCreative instance) {
        this.mCreationTime = instance.mCreationTime;
        this.mDuration = instance.mDuration;
        this.mHash = instance.mHash;
        this.mHeight = instance.mHeight;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mThumbnail = instance.mThumbnail;
        this.mType = instance.mType;
        this.mUrl = instance.mUrl;
        this.mVideoId = instance.mVideoId;
        this.mWidth = instance.mWidth;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessCreative> getParser() {
        return new APIRequest.ResponseParser<BusinessCreative>(){

            @Override
            public APINodeList<BusinessCreative> parseResponse(String response, APIContext context, APIRequest<BusinessCreative> request, String header) throws APIException.MalformedResponseException {
                return BusinessCreative.parseResponse(response, context, request, header);
            }
        };
    }
}

