/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class ConversionHealthKPI
extends APINode {
    @SerializedName(value="health_indicator")
    private String mHealthIndicator = null;
    @SerializedName(value="impacted_browsers_match_rate")
    private Double mImpactedBrowsersMatchRate = null;
    @SerializedName(value="impacted_browsers_match_rate_mom_trend")
    private Double mImpactedBrowsersMatchRateMomTrend = null;
    @SerializedName(value="impacted_browsers_traffic_share")
    private Double mImpactedBrowsersTrafficShare = null;
    @SerializedName(value="impacted_browsers_traffic_share_mom_trend")
    private Double mImpactedBrowsersTrafficShareMomTrend = null;
    @SerializedName(value="match_rate")
    private Double mMatchRate = null;
    @SerializedName(value="match_rate_mom_trend")
    private Double mMatchRateMomTrend = null;
    @SerializedName(value="match_rate_vertical_benchmark")
    private Double mMatchRateVerticalBenchmark = null;
    @SerializedName(value="match_rate_vs_benchmark_mom_trend")
    private Double mMatchRateVsBenchmarkMomTrend = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ConversionHealthKPI loadJSON(String json, APIContext context, String header) {
        ConversionHealthKPI conversionHealthKPI = (ConversionHealthKPI)ConversionHealthKPI.getGson().fromJson(json, ConversionHealthKPI.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(conversionHealthKPI.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        conversionHealthKPI.context = context;
        conversionHealthKPI.rawValue = json;
        conversionHealthKPI.header = header;
        return conversionHealthKPI;
    }

    public static APINodeList<ConversionHealthKPI> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ConversionHealthKPI> conversionHealthKPIs = new APINodeList<ConversionHealthKPI>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        conversionHealthKPIs.add(ConversionHealthKPI.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return conversionHealthKPIs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            conversionHealthKPIs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        conversionHealthKPIs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            conversionHealthKPIs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            conversionHealthKPIs.add(ConversionHealthKPI.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                conversionHealthKPIs.add(ConversionHealthKPI.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            conversionHealthKPIs.add(ConversionHealthKPI.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return conversionHealthKPIs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        conversionHealthKPIs.add(ConversionHealthKPI.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return conversionHealthKPIs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        conversionHealthKPIs.add(ConversionHealthKPI.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return conversionHealthKPIs;
                }
                conversionHealthKPIs.clear();
                conversionHealthKPIs.add(ConversionHealthKPI.loadJSON(json, context, header));
                return conversionHealthKPIs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ConversionHealthKPI.getGson().toJson((Object)this);
    }

    public String getFieldHealthIndicator() {
        return this.mHealthIndicator;
    }

    public ConversionHealthKPI setFieldHealthIndicator(String value) {
        this.mHealthIndicator = value;
        return this;
    }

    public Double getFieldImpactedBrowsersMatchRate() {
        return this.mImpactedBrowsersMatchRate;
    }

    public ConversionHealthKPI setFieldImpactedBrowsersMatchRate(Double value) {
        this.mImpactedBrowsersMatchRate = value;
        return this;
    }

    public Double getFieldImpactedBrowsersMatchRateMomTrend() {
        return this.mImpactedBrowsersMatchRateMomTrend;
    }

    public ConversionHealthKPI setFieldImpactedBrowsersMatchRateMomTrend(Double value) {
        this.mImpactedBrowsersMatchRateMomTrend = value;
        return this;
    }

    public Double getFieldImpactedBrowsersTrafficShare() {
        return this.mImpactedBrowsersTrafficShare;
    }

    public ConversionHealthKPI setFieldImpactedBrowsersTrafficShare(Double value) {
        this.mImpactedBrowsersTrafficShare = value;
        return this;
    }

    public Double getFieldImpactedBrowsersTrafficShareMomTrend() {
        return this.mImpactedBrowsersTrafficShareMomTrend;
    }

    public ConversionHealthKPI setFieldImpactedBrowsersTrafficShareMomTrend(Double value) {
        this.mImpactedBrowsersTrafficShareMomTrend = value;
        return this;
    }

    public Double getFieldMatchRate() {
        return this.mMatchRate;
    }

    public ConversionHealthKPI setFieldMatchRate(Double value) {
        this.mMatchRate = value;
        return this;
    }

    public Double getFieldMatchRateMomTrend() {
        return this.mMatchRateMomTrend;
    }

    public ConversionHealthKPI setFieldMatchRateMomTrend(Double value) {
        this.mMatchRateMomTrend = value;
        return this;
    }

    public Double getFieldMatchRateVerticalBenchmark() {
        return this.mMatchRateVerticalBenchmark;
    }

    public ConversionHealthKPI setFieldMatchRateVerticalBenchmark(Double value) {
        this.mMatchRateVerticalBenchmark = value;
        return this;
    }

    public Double getFieldMatchRateVsBenchmarkMomTrend() {
        return this.mMatchRateVsBenchmarkMomTrend;
    }

    public ConversionHealthKPI setFieldMatchRateVsBenchmarkMomTrend(Double value) {
        this.mMatchRateVsBenchmarkMomTrend = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ConversionHealthKPI copyFrom(ConversionHealthKPI instance) {
        this.mHealthIndicator = instance.mHealthIndicator;
        this.mImpactedBrowsersMatchRate = instance.mImpactedBrowsersMatchRate;
        this.mImpactedBrowsersMatchRateMomTrend = instance.mImpactedBrowsersMatchRateMomTrend;
        this.mImpactedBrowsersTrafficShare = instance.mImpactedBrowsersTrafficShare;
        this.mImpactedBrowsersTrafficShareMomTrend = instance.mImpactedBrowsersTrafficShareMomTrend;
        this.mMatchRate = instance.mMatchRate;
        this.mMatchRateMomTrend = instance.mMatchRateMomTrend;
        this.mMatchRateVerticalBenchmark = instance.mMatchRateVerticalBenchmark;
        this.mMatchRateVsBenchmarkMomTrend = instance.mMatchRateVsBenchmarkMomTrend;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ConversionHealthKPI> getParser() {
        return new APIRequest.ResponseParser<ConversionHealthKPI>(){

            @Override
            public APINodeList<ConversionHealthKPI> parseResponse(String response, APIContext context, APIRequest<ConversionHealthKPI> request, String header) throws APIException.MalformedResponseException {
                return ConversionHealthKPI.parseResponse(response, context, request, header);
            }
        };
    }
}

