/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class CopyrightAudioAsset
extends APINode {
    @SerializedName(value="audio_availability_status")
    private String mAudioAvailabilityStatus = null;
    @SerializedName(value="audio_library_policy")
    private List<Map<String, List<Map<String, Object>>>> mAudioLibraryPolicy = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="reference_files")
    private List<Object> mReferenceFiles = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="update_time")
    private String mUpdateTime = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CopyrightAudioAsset loadJSON(String json, APIContext context, String header) {
        CopyrightAudioAsset copyrightAudioAsset = (CopyrightAudioAsset)CopyrightAudioAsset.getGson().fromJson(json, CopyrightAudioAsset.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(copyrightAudioAsset.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        copyrightAudioAsset.context = context;
        copyrightAudioAsset.rawValue = json;
        copyrightAudioAsset.header = header;
        return copyrightAudioAsset;
    }

    public static APINodeList<CopyrightAudioAsset> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CopyrightAudioAsset> copyrightAudioAssets = new APINodeList<CopyrightAudioAsset>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        copyrightAudioAssets.add(CopyrightAudioAsset.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return copyrightAudioAssets;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            copyrightAudioAssets.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        copyrightAudioAssets.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            copyrightAudioAssets.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            copyrightAudioAssets.add(CopyrightAudioAsset.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                copyrightAudioAssets.add(CopyrightAudioAsset.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            copyrightAudioAssets.add(CopyrightAudioAsset.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return copyrightAudioAssets;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        copyrightAudioAssets.add(CopyrightAudioAsset.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return copyrightAudioAssets;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        copyrightAudioAssets.add(CopyrightAudioAsset.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return copyrightAudioAssets;
                }
                copyrightAudioAssets.clear();
                copyrightAudioAssets.add(CopyrightAudioAsset.loadJSON(json, context, header));
                return copyrightAudioAssets;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CopyrightAudioAsset.getGson().toJson((Object)this);
    }

    public String getFieldAudioAvailabilityStatus() {
        return this.mAudioAvailabilityStatus;
    }

    public CopyrightAudioAsset setFieldAudioAvailabilityStatus(String value) {
        this.mAudioAvailabilityStatus = value;
        return this;
    }

    public List<Map<String, List<Map<String, Object>>>> getFieldAudioLibraryPolicy() {
        return this.mAudioLibraryPolicy;
    }

    public CopyrightAudioAsset setFieldAudioLibraryPolicy(List<Map<String, List<Map<String, Object>>>> value) {
        this.mAudioLibraryPolicy = value;
        return this;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public CopyrightAudioAsset setFieldCreationTime(String value) {
        this.mCreationTime = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public CopyrightAudioAsset setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public List<Object> getFieldReferenceFiles() {
        return this.mReferenceFiles;
    }

    public CopyrightAudioAsset setFieldReferenceFiles(List<Object> value) {
        this.mReferenceFiles = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public CopyrightAudioAsset setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    public String getFieldUpdateTime() {
        return this.mUpdateTime;
    }

    public CopyrightAudioAsset setFieldUpdateTime(String value) {
        this.mUpdateTime = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CopyrightAudioAsset copyFrom(CopyrightAudioAsset instance) {
        this.mAudioAvailabilityStatus = instance.mAudioAvailabilityStatus;
        this.mAudioLibraryPolicy = instance.mAudioLibraryPolicy;
        this.mCreationTime = instance.mCreationTime;
        this.mId = instance.mId;
        this.mReferenceFiles = instance.mReferenceFiles;
        this.mTitle = instance.mTitle;
        this.mUpdateTime = instance.mUpdateTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CopyrightAudioAsset> getParser() {
        return new APIRequest.ResponseParser<CopyrightAudioAsset>(){

            @Override
            public APINodeList<CopyrightAudioAsset> parseResponse(String response, APIContext context, APIRequest<CopyrightAudioAsset> request, String header) throws APIException.MalformedResponseException {
                return CopyrightAudioAsset.parseResponse(response, context, request, header);
            }
        };
    }
}

