/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CurrencyAmount;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ExtendedCreditApplication
extends APINode {
    @SerializedName(value="billing_country")
    private String mBillingCountry = null;
    @SerializedName(value="city")
    private String mCity = null;
    @SerializedName(value="cnpj")
    private String mCnpj = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="display_currency")
    private String mDisplayCurrency = null;
    @SerializedName(value="duns_number")
    private String mDunsNumber = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="invoice_email_address")
    private String mInvoiceEmailAddress = null;
    @SerializedName(value="is_umi")
    private Boolean mIsUmi = null;
    @SerializedName(value="legal_entity_name")
    private String mLegalEntityName = null;
    @SerializedName(value="original_online_limit")
    private CurrencyAmount mOriginalOnlineLimit = null;
    @SerializedName(value="phone_number")
    private String mPhoneNumber = null;
    @SerializedName(value="postal_code")
    private String mPostalCode = null;
    @SerializedName(value="product_types")
    private List<String> mProductTypes = null;
    @SerializedName(value="proposed_credit_limit")
    private CurrencyAmount mProposedCreditLimit = null;
    @SerializedName(value="registration_number")
    private String mRegistrationNumber = null;
    @SerializedName(value="run_id")
    private String mRunId = null;
    @SerializedName(value="state")
    private String mState = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="street1")
    private String mStreet1 = null;
    @SerializedName(value="street2")
    private String mStreet2 = null;
    @SerializedName(value="submitter")
    private User mSubmitter = null;
    @SerializedName(value="tax_exempt_status")
    private String mTaxExemptStatus = null;
    @SerializedName(value="tax_id")
    private String mTaxId = null;
    @SerializedName(value="terms")
    private String mTerms = null;
    protected static Gson gson = null;

    ExtendedCreditApplication() {
    }

    public ExtendedCreditApplication(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ExtendedCreditApplication(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ExtendedCreditApplication fetch() throws APIException {
        ExtendedCreditApplication newInstance = ExtendedCreditApplication.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ExtendedCreditApplication fetchById(Long id, APIContext context) throws APIException {
        return ExtendedCreditApplication.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ExtendedCreditApplication> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ExtendedCreditApplication.fetchByIdAsync(id.toString(), context);
    }

    public static ExtendedCreditApplication fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ExtendedCreditApplication> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ExtendedCreditApplication> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ExtendedCreditApplication>(context, "", "/", "GET", ExtendedCreditApplication.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ExtendedCreditApplication>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ExtendedCreditApplication>(context, "", "/", "GET", ExtendedCreditApplication.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ExtendedCreditApplication loadJSON(String json, APIContext context, String header) {
        ExtendedCreditApplication extendedCreditApplication = (ExtendedCreditApplication)ExtendedCreditApplication.getGson().fromJson(json, ExtendedCreditApplication.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(extendedCreditApplication.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        extendedCreditApplication.context = context;
        extendedCreditApplication.rawValue = json;
        extendedCreditApplication.header = header;
        return extendedCreditApplication;
    }

    public static APINodeList<ExtendedCreditApplication> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ExtendedCreditApplication> extendedCreditApplications = new APINodeList<ExtendedCreditApplication>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        extendedCreditApplications.add(ExtendedCreditApplication.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return extendedCreditApplications;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            extendedCreditApplications.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        extendedCreditApplications.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            extendedCreditApplications.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            extendedCreditApplications.add(ExtendedCreditApplication.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                extendedCreditApplications.add(ExtendedCreditApplication.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            extendedCreditApplications.add(ExtendedCreditApplication.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return extendedCreditApplications;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        extendedCreditApplications.add(ExtendedCreditApplication.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return extendedCreditApplications;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        extendedCreditApplications.add(ExtendedCreditApplication.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return extendedCreditApplications;
                }
                extendedCreditApplications.clear();
                extendedCreditApplications.add(ExtendedCreditApplication.loadJSON(json, context, header));
                return extendedCreditApplications;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ExtendedCreditApplication.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBillingCountry() {
        return this.mBillingCountry;
    }

    public String getFieldCity() {
        return this.mCity;
    }

    public String getFieldCnpj() {
        return this.mCnpj;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public String getFieldDisplayCurrency() {
        return this.mDisplayCurrency;
    }

    public String getFieldDunsNumber() {
        return this.mDunsNumber;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldInvoiceEmailAddress() {
        return this.mInvoiceEmailAddress;
    }

    public Boolean getFieldIsUmi() {
        return this.mIsUmi;
    }

    public String getFieldLegalEntityName() {
        return this.mLegalEntityName;
    }

    public CurrencyAmount getFieldOriginalOnlineLimit() {
        return this.mOriginalOnlineLimit;
    }

    public String getFieldPhoneNumber() {
        return this.mPhoneNumber;
    }

    public String getFieldPostalCode() {
        return this.mPostalCode;
    }

    public List<String> getFieldProductTypes() {
        return this.mProductTypes;
    }

    public CurrencyAmount getFieldProposedCreditLimit() {
        return this.mProposedCreditLimit;
    }

    public String getFieldRegistrationNumber() {
        return this.mRegistrationNumber;
    }

    public String getFieldRunId() {
        return this.mRunId;
    }

    public String getFieldState() {
        return this.mState;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldStreet1() {
        return this.mStreet1;
    }

    public String getFieldStreet2() {
        return this.mStreet2;
    }

    public User getFieldSubmitter() {
        if (this.mSubmitter != null) {
            this.mSubmitter.context = this.getContext();
        }
        return this.mSubmitter;
    }

    public String getFieldTaxExemptStatus() {
        return this.mTaxExemptStatus;
    }

    public String getFieldTaxId() {
        return this.mTaxId;
    }

    public String getFieldTerms() {
        return this.mTerms;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ExtendedCreditApplication copyFrom(ExtendedCreditApplication instance) {
        this.mBillingCountry = instance.mBillingCountry;
        this.mCity = instance.mCity;
        this.mCnpj = instance.mCnpj;
        this.mCountry = instance.mCountry;
        this.mDisplayCurrency = instance.mDisplayCurrency;
        this.mDunsNumber = instance.mDunsNumber;
        this.mId = instance.mId;
        this.mInvoiceEmailAddress = instance.mInvoiceEmailAddress;
        this.mIsUmi = instance.mIsUmi;
        this.mLegalEntityName = instance.mLegalEntityName;
        this.mOriginalOnlineLimit = instance.mOriginalOnlineLimit;
        this.mPhoneNumber = instance.mPhoneNumber;
        this.mPostalCode = instance.mPostalCode;
        this.mProductTypes = instance.mProductTypes;
        this.mProposedCreditLimit = instance.mProposedCreditLimit;
        this.mRegistrationNumber = instance.mRegistrationNumber;
        this.mRunId = instance.mRunId;
        this.mState = instance.mState;
        this.mStatus = instance.mStatus;
        this.mStreet1 = instance.mStreet1;
        this.mStreet2 = instance.mStreet2;
        this.mSubmitter = instance.mSubmitter;
        this.mTaxExemptStatus = instance.mTaxExemptStatus;
        this.mTaxId = instance.mTaxId;
        this.mTerms = instance.mTerms;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ExtendedCreditApplication> getParser() {
        return new APIRequest.ResponseParser<ExtendedCreditApplication>(){

            @Override
            public APINodeList<ExtendedCreditApplication> parseResponse(String response, APIContext context, APIRequest<ExtendedCreditApplication> request, String header) throws APIException.MalformedResponseException {
                return ExtendedCreditApplication.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<ExtendedCreditApplication> {
        ExtendedCreditApplication lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"billing_country", "city", "cnpj", "country", "display_currency", "duns_number", "id", "invoice_email_address", "is_umi", "legal_entity_name", "original_online_limit", "phone_number", "postal_code", "product_types", "proposed_credit_limit", "registration_number", "run_id", "state", "status", "street1", "street2", "submitter", "tax_exempt_status", "tax_id", "terms"};

        @Override
        public ExtendedCreditApplication getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ExtendedCreditApplication parseResponse(String response, String header) throws APIException {
            return ExtendedCreditApplication.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ExtendedCreditApplication execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ExtendedCreditApplication execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ExtendedCreditApplication> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ExtendedCreditApplication> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ExtendedCreditApplication>(){

                public ExtendedCreditApplication apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBillingCountryField() {
            return this.requestBillingCountryField(true);
        }

        public APIRequestGet requestBillingCountryField(boolean value) {
            this.requestField("billing_country", value);
            return this;
        }

        public APIRequestGet requestCityField() {
            return this.requestCityField(true);
        }

        public APIRequestGet requestCityField(boolean value) {
            this.requestField("city", value);
            return this;
        }

        public APIRequestGet requestCnpjField() {
            return this.requestCnpjField(true);
        }

        public APIRequestGet requestCnpjField(boolean value) {
            this.requestField("cnpj", value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestDisplayCurrencyField() {
            return this.requestDisplayCurrencyField(true);
        }

        public APIRequestGet requestDisplayCurrencyField(boolean value) {
            this.requestField("display_currency", value);
            return this;
        }

        public APIRequestGet requestDunsNumberField() {
            return this.requestDunsNumberField(true);
        }

        public APIRequestGet requestDunsNumberField(boolean value) {
            this.requestField("duns_number", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInvoiceEmailAddressField() {
            return this.requestInvoiceEmailAddressField(true);
        }

        public APIRequestGet requestInvoiceEmailAddressField(boolean value) {
            this.requestField("invoice_email_address", value);
            return this;
        }

        public APIRequestGet requestIsUmiField() {
            return this.requestIsUmiField(true);
        }

        public APIRequestGet requestIsUmiField(boolean value) {
            this.requestField("is_umi", value);
            return this;
        }

        public APIRequestGet requestLegalEntityNameField() {
            return this.requestLegalEntityNameField(true);
        }

        public APIRequestGet requestLegalEntityNameField(boolean value) {
            this.requestField("legal_entity_name", value);
            return this;
        }

        public APIRequestGet requestOriginalOnlineLimitField() {
            return this.requestOriginalOnlineLimitField(true);
        }

        public APIRequestGet requestOriginalOnlineLimitField(boolean value) {
            this.requestField("original_online_limit", value);
            return this;
        }

        public APIRequestGet requestPhoneNumberField() {
            return this.requestPhoneNumberField(true);
        }

        public APIRequestGet requestPhoneNumberField(boolean value) {
            this.requestField("phone_number", value);
            return this;
        }

        public APIRequestGet requestPostalCodeField() {
            return this.requestPostalCodeField(true);
        }

        public APIRequestGet requestPostalCodeField(boolean value) {
            this.requestField("postal_code", value);
            return this;
        }

        public APIRequestGet requestProductTypesField() {
            return this.requestProductTypesField(true);
        }

        public APIRequestGet requestProductTypesField(boolean value) {
            this.requestField("product_types", value);
            return this;
        }

        public APIRequestGet requestProposedCreditLimitField() {
            return this.requestProposedCreditLimitField(true);
        }

        public APIRequestGet requestProposedCreditLimitField(boolean value) {
            this.requestField("proposed_credit_limit", value);
            return this;
        }

        public APIRequestGet requestRegistrationNumberField() {
            return this.requestRegistrationNumberField(true);
        }

        public APIRequestGet requestRegistrationNumberField(boolean value) {
            this.requestField("registration_number", value);
            return this;
        }

        public APIRequestGet requestRunIdField() {
            return this.requestRunIdField(true);
        }

        public APIRequestGet requestRunIdField(boolean value) {
            this.requestField("run_id", value);
            return this;
        }

        public APIRequestGet requestStateField() {
            return this.requestStateField(true);
        }

        public APIRequestGet requestStateField(boolean value) {
            this.requestField("state", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestStreet1Field() {
            return this.requestStreet1Field(true);
        }

        public APIRequestGet requestStreet1Field(boolean value) {
            this.requestField("street1", value);
            return this;
        }

        public APIRequestGet requestStreet2Field() {
            return this.requestStreet2Field(true);
        }

        public APIRequestGet requestStreet2Field(boolean value) {
            this.requestField("street2", value);
            return this;
        }

        public APIRequestGet requestSubmitterField() {
            return this.requestSubmitterField(true);
        }

        public APIRequestGet requestSubmitterField(boolean value) {
            this.requestField("submitter", value);
            return this;
        }

        public APIRequestGet requestTaxExemptStatusField() {
            return this.requestTaxExemptStatusField(true);
        }

        public APIRequestGet requestTaxExemptStatusField(boolean value) {
            this.requestField("tax_exempt_status", value);
            return this;
        }

        public APIRequestGet requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGet requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGet requestTermsField() {
            return this.requestTermsField(true);
        }

        public APIRequestGet requestTermsField(boolean value) {
            this.requestField("terms", value);
            return this;
        }
    }
}

