/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class FundraiserPersonToCharity
extends APINode {
    @SerializedName(value="amount_raised")
    private Long mAmountRaised = null;
    @SerializedName(value="charity_id")
    private String mCharityId = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="donations_count")
    private Long mDonationsCount = null;
    @SerializedName(value="donors_count")
    private Long mDonorsCount = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="external_amount_raised")
    private Long mExternalAmountRaised = null;
    @SerializedName(value="external_donations_count")
    private Long mExternalDonationsCount = null;
    @SerializedName(value="external_donors_count")
    private Long mExternalDonorsCount = null;
    @SerializedName(value="external_event_name")
    private String mExternalEventName = null;
    @SerializedName(value="external_event_start_time")
    private String mExternalEventStartTime = null;
    @SerializedName(value="external_event_uri")
    private String mExternalEventUri = null;
    @SerializedName(value="external_fundraiser_uri")
    private String mExternalFundraiserUri = null;
    @SerializedName(value="external_id")
    private String mExternalId = null;
    @SerializedName(value="goal_amount")
    private Long mGoalAmount = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="internal_amount_raised")
    private Long mInternalAmountRaised = null;
    @SerializedName(value="internal_donations_count")
    private Long mInternalDonationsCount = null;
    @SerializedName(value="internal_donors_count")
    private Long mInternalDonorsCount = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="uri")
    private String mUri = null;
    protected static Gson gson = null;

    FundraiserPersonToCharity() {
    }

    public FundraiserPersonToCharity(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public FundraiserPersonToCharity(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public FundraiserPersonToCharity fetch() throws APIException {
        FundraiserPersonToCharity newInstance = FundraiserPersonToCharity.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static FundraiserPersonToCharity fetchById(Long id, APIContext context) throws APIException {
        return FundraiserPersonToCharity.fetchById(id.toString(), context);
    }

    public static ListenableFuture<FundraiserPersonToCharity> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return FundraiserPersonToCharity.fetchByIdAsync(id.toString(), context);
    }

    public static FundraiserPersonToCharity fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<FundraiserPersonToCharity> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<FundraiserPersonToCharity> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<FundraiserPersonToCharity>(context, "", "/", "GET", FundraiserPersonToCharity.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<FundraiserPersonToCharity>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<FundraiserPersonToCharity>(context, "", "/", "GET", FundraiserPersonToCharity.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static FundraiserPersonToCharity loadJSON(String json, APIContext context, String header) {
        FundraiserPersonToCharity fundraiserPersonToCharity = (FundraiserPersonToCharity)FundraiserPersonToCharity.getGson().fromJson(json, FundraiserPersonToCharity.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(fundraiserPersonToCharity.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        fundraiserPersonToCharity.context = context;
        fundraiserPersonToCharity.rawValue = json;
        fundraiserPersonToCharity.header = header;
        return fundraiserPersonToCharity;
    }

    public static APINodeList<FundraiserPersonToCharity> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<FundraiserPersonToCharity> fundraiserPersonToCharitys = new APINodeList<FundraiserPersonToCharity>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        fundraiserPersonToCharitys.add(FundraiserPersonToCharity.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return fundraiserPersonToCharitys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            fundraiserPersonToCharitys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        fundraiserPersonToCharitys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            fundraiserPersonToCharitys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            fundraiserPersonToCharitys.add(FundraiserPersonToCharity.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                fundraiserPersonToCharitys.add(FundraiserPersonToCharity.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            fundraiserPersonToCharitys.add(FundraiserPersonToCharity.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return fundraiserPersonToCharitys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        fundraiserPersonToCharitys.add(FundraiserPersonToCharity.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return fundraiserPersonToCharitys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        fundraiserPersonToCharitys.add(FundraiserPersonToCharity.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return fundraiserPersonToCharitys;
                }
                fundraiserPersonToCharitys.clear();
                fundraiserPersonToCharitys.add(FundraiserPersonToCharity.loadJSON(json, context, header));
                return fundraiserPersonToCharitys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return FundraiserPersonToCharity.getGson().toJson((Object)this);
    }

    public APIRequestGetDonations getDonations() {
        return new APIRequestGetDonations(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateEndFundraiser createEndFundraiser() {
        return new APIRequestCreateEndFundraiser(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetExternalDonations getExternalDonations() {
        return new APIRequestGetExternalDonations(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateExternalDonation createExternalDonation() {
        return new APIRequestCreateExternalDonation(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAmountRaised() {
        return this.mAmountRaised;
    }

    public String getFieldCharityId() {
        return this.mCharityId;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Long getFieldDonationsCount() {
        return this.mDonationsCount;
    }

    public Long getFieldDonorsCount() {
        return this.mDonorsCount;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public Long getFieldExternalAmountRaised() {
        return this.mExternalAmountRaised;
    }

    public Long getFieldExternalDonationsCount() {
        return this.mExternalDonationsCount;
    }

    public Long getFieldExternalDonorsCount() {
        return this.mExternalDonorsCount;
    }

    public String getFieldExternalEventName() {
        return this.mExternalEventName;
    }

    public String getFieldExternalEventStartTime() {
        return this.mExternalEventStartTime;
    }

    public String getFieldExternalEventUri() {
        return this.mExternalEventUri;
    }

    public String getFieldExternalFundraiserUri() {
        return this.mExternalFundraiserUri;
    }

    public String getFieldExternalId() {
        return this.mExternalId;
    }

    public Long getFieldGoalAmount() {
        return this.mGoalAmount;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Long getFieldInternalAmountRaised() {
        return this.mInternalAmountRaised;
    }

    public Long getFieldInternalDonationsCount() {
        return this.mInternalDonationsCount;
    }

    public Long getFieldInternalDonorsCount() {
        return this.mInternalDonorsCount;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldUri() {
        return this.mUri;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public FundraiserPersonToCharity copyFrom(FundraiserPersonToCharity instance) {
        this.mAmountRaised = instance.mAmountRaised;
        this.mCharityId = instance.mCharityId;
        this.mCurrency = instance.mCurrency;
        this.mDescription = instance.mDescription;
        this.mDonationsCount = instance.mDonationsCount;
        this.mDonorsCount = instance.mDonorsCount;
        this.mEndTime = instance.mEndTime;
        this.mExternalAmountRaised = instance.mExternalAmountRaised;
        this.mExternalDonationsCount = instance.mExternalDonationsCount;
        this.mExternalDonorsCount = instance.mExternalDonorsCount;
        this.mExternalEventName = instance.mExternalEventName;
        this.mExternalEventStartTime = instance.mExternalEventStartTime;
        this.mExternalEventUri = instance.mExternalEventUri;
        this.mExternalFundraiserUri = instance.mExternalFundraiserUri;
        this.mExternalId = instance.mExternalId;
        this.mGoalAmount = instance.mGoalAmount;
        this.mId = instance.mId;
        this.mInternalAmountRaised = instance.mInternalAmountRaised;
        this.mInternalDonationsCount = instance.mInternalDonationsCount;
        this.mInternalDonorsCount = instance.mInternalDonorsCount;
        this.mName = instance.mName;
        this.mUri = instance.mUri;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<FundraiserPersonToCharity> getParser() {
        return new APIRequest.ResponseParser<FundraiserPersonToCharity>(){

            @Override
            public APINodeList<FundraiserPersonToCharity> parseResponse(String response, APIContext context, APIRequest<FundraiserPersonToCharity> request, String header) throws APIException.MalformedResponseException {
                return FundraiserPersonToCharity.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumFundraiserType {
        VALUE_PERSON_FOR_CHARITY("person_for_charity");

        private String value;

        private EnumFundraiserType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<FundraiserPersonToCharity> {
        FundraiserPersonToCharity lastResponse = null;
        public static final String[] PARAMS = new String[]{"description", "end_time", "external_event_name", "external_event_start_time", "external_event_uri", "external_fundraiser_uri", "external_id", "goal_amount", "name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public FundraiserPersonToCharity getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public FundraiserPersonToCharity parseResponse(String response, String header) throws APIException {
            return FundraiserPersonToCharity.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public FundraiserPersonToCharity execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public FundraiserPersonToCharity execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<FundraiserPersonToCharity> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<FundraiserPersonToCharity> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, FundraiserPersonToCharity>(){

                public FundraiserPersonToCharity apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestUpdate setExternalEventName(String externalEventName) {
            this.setParam("external_event_name", externalEventName);
            return this;
        }

        public APIRequestUpdate setExternalEventStartTime(String externalEventStartTime) {
            this.setParam("external_event_start_time", externalEventStartTime);
            return this;
        }

        public APIRequestUpdate setExternalEventUri(String externalEventUri) {
            this.setParam("external_event_uri", externalEventUri);
            return this;
        }

        public APIRequestUpdate setExternalFundraiserUri(String externalFundraiserUri) {
            this.setParam("external_fundraiser_uri", externalFundraiserUri);
            return this;
        }

        public APIRequestUpdate setExternalId(String externalId) {
            this.setParam("external_id", externalId);
            return this;
        }

        public APIRequestUpdate setGoalAmount(Long goalAmount) {
            this.setParam("goal_amount", goalAmount);
            return this;
        }

        public APIRequestUpdate setGoalAmount(String goalAmount) {
            this.setParam("goal_amount", goalAmount);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<FundraiserPersonToCharity> {
        FundraiserPersonToCharity lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"amount_raised", "charity_id", "currency", "description", "donations_count", "donors_count", "end_time", "external_amount_raised", "external_donations_count", "external_donors_count", "external_event_name", "external_event_start_time", "external_event_uri", "external_fundraiser_uri", "external_id", "goal_amount", "id", "internal_amount_raised", "internal_donations_count", "internal_donors_count", "name", "uri"};

        @Override
        public FundraiserPersonToCharity getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public FundraiserPersonToCharity parseResponse(String response, String header) throws APIException {
            return FundraiserPersonToCharity.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public FundraiserPersonToCharity execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public FundraiserPersonToCharity execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<FundraiserPersonToCharity> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<FundraiserPersonToCharity> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, FundraiserPersonToCharity>(){

                public FundraiserPersonToCharity apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAmountRaisedField() {
            return this.requestAmountRaisedField(true);
        }

        public APIRequestGet requestAmountRaisedField(boolean value) {
            this.requestField("amount_raised", value);
            return this;
        }

        public APIRequestGet requestCharityIdField() {
            return this.requestCharityIdField(true);
        }

        public APIRequestGet requestCharityIdField(boolean value) {
            this.requestField("charity_id", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestDonationsCountField() {
            return this.requestDonationsCountField(true);
        }

        public APIRequestGet requestDonationsCountField(boolean value) {
            this.requestField("donations_count", value);
            return this;
        }

        public APIRequestGet requestDonorsCountField() {
            return this.requestDonorsCountField(true);
        }

        public APIRequestGet requestDonorsCountField(boolean value) {
            this.requestField("donors_count", value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestExternalAmountRaisedField() {
            return this.requestExternalAmountRaisedField(true);
        }

        public APIRequestGet requestExternalAmountRaisedField(boolean value) {
            this.requestField("external_amount_raised", value);
            return this;
        }

        public APIRequestGet requestExternalDonationsCountField() {
            return this.requestExternalDonationsCountField(true);
        }

        public APIRequestGet requestExternalDonationsCountField(boolean value) {
            this.requestField("external_donations_count", value);
            return this;
        }

        public APIRequestGet requestExternalDonorsCountField() {
            return this.requestExternalDonorsCountField(true);
        }

        public APIRequestGet requestExternalDonorsCountField(boolean value) {
            this.requestField("external_donors_count", value);
            return this;
        }

        public APIRequestGet requestExternalEventNameField() {
            return this.requestExternalEventNameField(true);
        }

        public APIRequestGet requestExternalEventNameField(boolean value) {
            this.requestField("external_event_name", value);
            return this;
        }

        public APIRequestGet requestExternalEventStartTimeField() {
            return this.requestExternalEventStartTimeField(true);
        }

        public APIRequestGet requestExternalEventStartTimeField(boolean value) {
            this.requestField("external_event_start_time", value);
            return this;
        }

        public APIRequestGet requestExternalEventUriField() {
            return this.requestExternalEventUriField(true);
        }

        public APIRequestGet requestExternalEventUriField(boolean value) {
            this.requestField("external_event_uri", value);
            return this;
        }

        public APIRequestGet requestExternalFundraiserUriField() {
            return this.requestExternalFundraiserUriField(true);
        }

        public APIRequestGet requestExternalFundraiserUriField(boolean value) {
            this.requestField("external_fundraiser_uri", value);
            return this;
        }

        public APIRequestGet requestExternalIdField() {
            return this.requestExternalIdField(true);
        }

        public APIRequestGet requestExternalIdField(boolean value) {
            this.requestField("external_id", value);
            return this;
        }

        public APIRequestGet requestGoalAmountField() {
            return this.requestGoalAmountField(true);
        }

        public APIRequestGet requestGoalAmountField(boolean value) {
            this.requestField("goal_amount", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInternalAmountRaisedField() {
            return this.requestInternalAmountRaisedField(true);
        }

        public APIRequestGet requestInternalAmountRaisedField(boolean value) {
            this.requestField("internal_amount_raised", value);
            return this;
        }

        public APIRequestGet requestInternalDonationsCountField() {
            return this.requestInternalDonationsCountField(true);
        }

        public APIRequestGet requestInternalDonationsCountField(boolean value) {
            this.requestField("internal_donations_count", value);
            return this;
        }

        public APIRequestGet requestInternalDonorsCountField() {
            return this.requestInternalDonorsCountField(true);
        }

        public APIRequestGet requestInternalDonorsCountField(boolean value) {
            this.requestField("internal_donors_count", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestUriField() {
            return this.requestUriField(true);
        }

        public APIRequestGet requestUriField(boolean value) {
            this.requestField("uri", value);
            return this;
        }
    }

    public static class APIRequestCreateExternalDonation
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"amount_received", "currency", "donation_id_hash", "donation_time", "donor_id_hash"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateExternalDonation(String nodeId, APIContext context) {
            super(context, nodeId, "/external_donations", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateExternalDonation setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateExternalDonation setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateExternalDonation setAmountReceived(Long amountReceived) {
            this.setParam("amount_received", amountReceived);
            return this;
        }

        public APIRequestCreateExternalDonation setAmountReceived(String amountReceived) {
            this.setParam("amount_received", amountReceived);
            return this;
        }

        public APIRequestCreateExternalDonation setCurrency(String currency) {
            this.setParam("currency", currency);
            return this;
        }

        public APIRequestCreateExternalDonation setDonationIdHash(String donationIdHash) {
            this.setParam("donation_id_hash", donationIdHash);
            return this;
        }

        public APIRequestCreateExternalDonation setDonationTime(Long donationTime) {
            this.setParam("donation_time", donationTime);
            return this;
        }

        public APIRequestCreateExternalDonation setDonationTime(String donationTime) {
            this.setParam("donation_time", donationTime);
            return this;
        }

        public APIRequestCreateExternalDonation setDonorIdHash(String donorIdHash) {
            this.setParam("donor_id_hash", donorIdHash);
            return this;
        }

        public APIRequestCreateExternalDonation requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateExternalDonation requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateExternalDonation requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateExternalDonation requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateExternalDonation requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateExternalDonation requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetExternalDonations
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetExternalDonations(String nodeId, APIContext context) {
            super(context, nodeId, "/external_donations", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetExternalDonations setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetExternalDonations setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetExternalDonations requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetExternalDonations requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetExternalDonations requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetExternalDonations requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetExternalDonations requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetExternalDonations requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateEndFundraiser
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateEndFundraiser(String nodeId, APIContext context) {
            super(context, nodeId, "/end_fundraiser", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateEndFundraiser setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateEndFundraiser setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateEndFundraiser requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateEndFundraiser requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateEndFundraiser requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateEndFundraiser requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateEndFundraiser requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateEndFundraiser requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetDonations
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetDonations(String nodeId, APIContext context) {
            super(context, nodeId, "/donations", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetDonations setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetDonations setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetDonations requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetDonations requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDonations requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetDonations requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDonations requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetDonations requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

